/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geotools.util.logging.Logging;

public class GeoServerTemplateLoader
implements TemplateLoader {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.template");
    FileTemplateLoader fileTemplateLoader;
    ClassTemplateLoader classTemplateLoader;
    GeoServerDataDirectory dd;
    protected ResourceInfo resource;
    WorkspaceInfo workspace;

    public GeoServerTemplateLoader(Class<?> caller, GeoServerResourceLoader rl) throws IOException {
        this(caller, rl == null ? new GeoServerDataDirectory((GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class)) : new GeoServerDataDirectory(rl));
    }

    public GeoServerTemplateLoader(Class<?> caller, GeoServerDataDirectory dd) throws IOException {
        this.dd = dd;
        this.fileTemplateLoader = new FileTemplateLoader(dd.root());
        if (caller != null) {
            this.classTemplateLoader = new ClassTemplateLoader(caller, "");
        }
    }

    public void setFeatureType(FeatureTypeInfo ft) {
        this.resource = ft;
    }

    public void setWMSLayer(WMSLayerInfo wms) {
        this.resource = wms;
    }

    public void setWMTSLayer(WMTSLayerInfo wmts) {
        this.resource = wmts;
    }

    public void setCoverage(CoverageInfo c) {
        this.resource = c;
    }

    public void setResource(ResourceInfo resource) {
        this.resource = resource;
    }

    public void setWorkspace(WorkspaceInfo workspace) {
        this.workspace = workspace;
    }

    public Object findTemplateSource(String path) throws IOException {
        Object source;
        File template = null;
        if (this.resource != null) {
            template = Resources.file((Resource)this.dd.get(this.resource, path));
            if (template == null) {
                template = Resources.file((Resource)this.dd.get(this.resource.getStore(), path));
            }
            if (template == null) {
                template = Resources.file((Resource)this.dd.get(this.resource.getStore().getWorkspace(), path));
            }
            if (template == null) {
                template = Resources.file((Resource)this.dd.getWorkspaces(path));
            }
            if (template != null) {
                return template;
            }
        }
        if (this.workspace != null) {
            if (template == null) {
                template = Resources.file((Resource)this.dd.get(this.workspace, path));
            }
            if (template == null) {
                template = Resources.file((Resource)this.dd.getWorkspaces(path));
            }
            if (template != null) {
                return template;
            }
        }
        if ((template = this.findTemplateSourceLegacy(path)) != null) {
            return template;
        }
        template = (File)this.fileTemplateLoader.findTemplateSource("templates" + File.separator + path);
        if (template != null) {
            return template;
        }
        if (this.classTemplateLoader != null && (source = this.classTemplateLoader.findTemplateSource(path)) != null) {
            return new ClassTemplateSource(path, source);
        }
        return null;
    }

    File findTemplateSourceLegacy(String path) throws IOException {
        File template = null;
        try {
            template = (File)this.fileTemplateLoader.findTemplateSource("featureTypes" + File.separator + path);
            if (template != null) {
                return template;
            }
            template = (File)this.fileTemplateLoader.findTemplateSource("coverages" + File.separator + path);
            if (template != null) {
                return template;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    public long getLastModified(Object source) {
        if (source instanceof File) {
            return this.fileTemplateLoader.getLastModified(source);
        }
        ClassTemplateSource wrapper = (ClassTemplateSource)source;
        return this.classTemplateLoader.getLastModified(wrapper.source);
    }

    public Reader getReader(Object source, String encoding) throws IOException {
        if (source instanceof File) {
            return this.fileTemplateLoader.getReader(source, encoding);
        }
        ClassTemplateSource wrapper = (ClassTemplateSource)source;
        return this.classTemplateLoader.getReader(wrapper.source, encoding);
    }

    public void closeTemplateSource(Object source) throws IOException {
        if (source instanceof File) {
            this.fileTemplateLoader.closeTemplateSource(source);
        } else {
            ClassTemplateSource wrapper = (ClassTemplateSource)source;
            this.classTemplateLoader.closeTemplateSource(wrapper.source);
            wrapper.path = null;
            wrapper.source = null;
        }
    }

    protected static class ClassTemplateSource {
        String path;
        Object source;

        public ClassTemplateSource(String path, Object source) {
            this.path = path;
            this.source = source;
        }
    }
}

