/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.xml;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.xml.GMLSchemaTranslator;
import org.vfny.geoserver.global.xml.NameSpaceTranslator;
import org.vfny.geoserver.global.xml.XMLSchemaTranslator;

public class NameSpaceTranslatorFactory {
    static final Logger LOGGER = Logging.getLogger(NameSpaceTranslatorFactory.class);
    private Map<String, Class<?>> namespaceTranslators = new HashMap();
    private Map<String, NameSpaceTranslator> namespaceTranslatorInstances = new HashMap<String, NameSpaceTranslator>();
    private static final NameSpaceTranslatorFactory instance = new NameSpaceTranslatorFactory();

    private NameSpaceTranslatorFactory() {
        this.namespaceTranslators.put("http://www.w3.org/2001/XMLSchema", XMLSchemaTranslator.class);
        this.namespaceTranslators.put("http://www.opengis.net/gml", GMLSchemaTranslator.class);
        this.addNameSpaceTranslator("xs", "http://www.w3.org/2001/XMLSchema");
        this.addNameSpaceTranslator("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addNameSpaceTranslator("gml", "http://www.opengis.net/gml");
    }

    public static NameSpaceTranslatorFactory getInstance() {
        return instance;
    }

    public void addNameSpaceTranslator(String prefix, String namespace) {
        if (prefix == null || namespace == null) {
            throw new NullPointerException();
        }
        try {
            Class<?> nstClass = this.namespaceTranslators.get(namespace);
            if (nstClass == null) {
                return;
            }
            Constructor<?> nstConstructor = nstClass.getConstructor(String.class);
            NameSpaceTranslator nst = (NameSpaceTranslator)nstConstructor.newInstance(prefix);
            this.namespaceTranslatorInstances.put(prefix, nst);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "", e);
        }
    }

    public NameSpaceTranslator getNameSpaceTranslator(String prefix) {
        return this.namespaceTranslatorInstances.get(prefix);
    }

    public void registerNameSpaceTranslator(String namespace, Class<? extends NameSpaceTranslator> nameSpaceTranslator) {
        if (nameSpaceTranslator != null) {
            this.namespaceTranslators.put(namespace, nameSpaceTranslator);
        }
    }
}

