/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.AbstractURLPublisher;
import org.geoserver.ows.FilePublisher;
import org.geoserver.platform.GeoServerResourceLoader;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;

public class FilePublisherTest {
    static FilePublisher publisher;
    static List<String[]> paths;

    @BeforeClass
    public static void create() throws Exception {
        File tmp = File.createTempFile("xyz", "123");
        tmp.delete();
        tmp.mkdirs();
        tmp.deleteOnExit();
        paths.add(FilePublisherTest.create(tmp, "with space", "ascii"));
        paths.add(FilePublisherTest.create(tmp, "with space", "l\u00e0t\u00een"));
        GeoServerResourceLoader loader = new GeoServerResourceLoader(tmp);
        publisher = new FilePublisher(loader);
        publisher.setServletContext((ServletContext)new MockServletContext());
    }

    static String[] create(File parent, String ... path) throws Exception {
        for (int i = 0; i < path.length - 1; ++i) {
            parent = new File(parent, path[i]);
            parent.deleteOnExit();
        }
        parent.mkdirs();
        String fname = path[path.length - 1];
        File file = new File(parent, fname);
        file.deleteOnExit();
        FileOutputStream fout = new FileOutputStream(file);
        fout.write(fname.getBytes("UTF-8"));
        fout.close();
        return path;
    }

    @AfterClass
    public static void destroy() {
    }

    private MockHttpServletResponse request(String[] path, String modifiedSince) throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setMethod("GET");
        StringBuilder b = new StringBuilder("/geoserver");
        for (int i = 0; i < path.length; ++i) {
            b.append('/').append(path[i]);
        }
        String uri = URLEncoder.encode(b.toString(), "UTF-8");
        request.setRequestURI(uri);
        if (modifiedSince != null) {
            request.addHeader("If-Modified-Since", (Object)modifiedSince);
        }
        MockHttpServletResponse response = new MockHttpServletResponse();
        publisher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        return response;
    }

    @Test
    public void testEncoding() throws Exception {
        for (Object[] objectArray : paths) {
            MockHttpServletResponse response = this.request((String[])objectArray, null);
            Assert.assertEquals((String)Arrays.toString(objectArray), (long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)objectArray[objectArray.length - 1], (Object)response.getContentAsString());
        }
    }

    @Test
    public void testLastModified() throws Exception {
        for (String[] path : paths) {
            MockHttpServletResponse response = this.request(path, null);
            String lastModified = response.getHeader("Last-Modified");
            Assert.assertNotNull((Object)lastModified);
            response = this.request(path, lastModified);
            Assert.assertEquals((long)304L, (long)response.getStatus());
            long timeStamp = AbstractURLPublisher.lastModified((String)lastModified) + 10000L;
            response = this.request(path, AbstractURLPublisher.lastModified((long)timeStamp));
            Assert.assertEquals((long)304L, (long)response.getStatus());
            response = this.request(path, AbstractURLPublisher.lastModified((long)(timeStamp -= 20000L)));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)path[path.length - 1], (Object)response.getContentAsString());
        }
    }

    static {
        paths = new ArrayList<String[]>();
    }
}

