/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xpath.XPathAPI;
import org.geoserver.ows.HelloWorld;
import org.geoserver.ows.OWS10ServiceExceptionHandler;
import org.geoserver.ows.Request;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.util.Version;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OWS10ServiceExceptionHandlerTest {
    private static OWS10ServiceExceptionHandler handler;
    private static MockHttpServletRequest request;
    private static MockHttpServletResponse response;
    private static Request requestInfo;
    private static final String XML_TYPE_TEXT = "text/xml";

    @BeforeClass
    public static void setupClass() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Field field = OWS10ServiceExceptionHandler.class.getDeclaredField("CONTENT_TYPE");
        field.setAccessible(true);
        field.set(null, XML_TYPE_TEXT);
    }

    @AfterClass
    public static void teardownClass() {
        System.clearProperty("ows10.exception.xml.responsetype");
    }

    @Before
    public void setUp() throws Exception {
        HelloWorld helloWorld = new HelloWorld();
        Service service = new Service("hello", (Object)helloWorld, new Version("1.0.0"), Collections.singletonList("hello"));
        request = new MockHttpServletRequest(){

            public int getServerPort() {
                return 8080;
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("geoserver");
        response = new MockHttpServletResponse();
        handler = new OWS10ServiceExceptionHandler();
        requestInfo = new Request();
        requestInfo.setHttpRequest((HttpServletRequest)request);
        requestInfo.setHttpResponse((HttpServletResponse)response);
        requestInfo.setService(service.getId());
        requestInfo.setVersion(service.getVersion().toString());
    }

    @Test
    public void testHandleServiceException() throws Exception {
        ServiceException exception = new ServiceException("hello service exception");
        exception.setCode("helloCode");
        exception.setLocator("helloLocator");
        exception.getExceptionText().add("helloText");
        handler.handleServiceException(exception, requestInfo);
        ByteArrayInputStream input = new ByteArrayInputStream(response.getContentAsString().getBytes());
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        Document doc = docBuilderFactory.newDocumentBuilder().parse(input);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testHandleServiceExceptionEncoding() throws Exception {
        String message = "foo & <foo> \"foo's\"";
        ServiceException exception = new ServiceException(message);
        exception.setLocator("test-locator");
        handler.handleServiceException(exception, requestInfo);
        ByteArrayInputStream input = new ByteArrayInputStream(response.getContentAsString().getBytes());
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        Document doc = docBuilderFactory.newDocumentBuilder().parse(input);
        Node exceptionText = XPathAPI.selectSingleNode((Node)doc, (String)"ows:ExceptionReport/ows:Exception/ows:ExceptionText/text()");
        Assert.assertNotNull((Object)exceptionText);
        Assert.assertEquals((String)"round-tripped through character entities", (Object)message, (Object)exceptionText.getTextContent());
    }

    @Test
    public void testHandleServiceExceptionEncodingMore() throws Exception {
        String message1 = "foo & <foo> \"foo's\"";
        String message2 = "a \"different\" <message>";
        ServiceException exception = new ServiceException(message1);
        exception.setLocator("test-locator");
        exception.getExceptionText().add(message2);
        handler.handleServiceException(exception, requestInfo);
        ByteArrayInputStream input = new ByteArrayInputStream(response.getContentAsString().getBytes());
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        Document doc = docBuilderFactory.newDocumentBuilder().parse(input);
        Node exceptionText = XPathAPI.selectSingleNode((Node)doc, (String)"ows:ExceptionReport/ows:Exception/ows:ExceptionText/text()");
        Assert.assertNotNull((Object)exceptionText);
        String message = message1 + "\n" + message2;
        Assert.assertEquals((String)"round-tripped through character entities", (Object)message, (Object)exceptionText.getTextContent());
    }

    @Test
    public void testHandleServiceExceptionCauses() throws Exception {
        IllegalArgumentException illegalArgument = new IllegalArgumentException("Illegal argument here");
        IOException ioException = new IOException("I/O exception here");
        ioException.initCause(illegalArgument);
        ServiceException serviceException = new ServiceException("hello service exception");
        serviceException.setCode("helloCode");
        serviceException.setLocator("helloLocator");
        serviceException.getExceptionText().add("helloText");
        serviceException.initCause((Throwable)ioException);
        handler.handleServiceException(serviceException, requestInfo);
        ByteArrayInputStream input = new ByteArrayInputStream(response.getContentAsString().getBytes());
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        Document doc = docBuilderFactory.newDocumentBuilder().parse(input);
        Node exceptionTextNode = XPathAPI.selectSingleNode((Node)doc, (String)"ows:ExceptionReport/ows:Exception/ows:ExceptionText/text()");
        Assert.assertNotNull((Object)exceptionTextNode);
        String exceptionText = exceptionTextNode.getNodeValue().replaceAll("\\s+", " ");
        Assert.assertTrue((exceptionText.indexOf(illegalArgument.getMessage()) != -1 ? 1 : 0) != 0);
        Assert.assertTrue((exceptionText.indexOf(ioException.getMessage()) != -1 ? 1 : 0) != 0);
        Assert.assertTrue((exceptionText.indexOf(serviceException.getMessage()) != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testHandleServiceExceptionNullMessages() throws Exception {
        NullPointerException npe = new NullPointerException();
        ServiceException serviceException = new ServiceException("hello service exception");
        serviceException.setCode("helloCode");
        serviceException.setLocator("helloLocator");
        serviceException.getExceptionText().add("NullPointerException");
        serviceException.initCause((Throwable)npe);
        handler.handleServiceException(serviceException, requestInfo);
        ByteArrayInputStream input = new ByteArrayInputStream(response.getContentAsString().getBytes());
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        Document doc = docBuilderFactory.newDocumentBuilder().parse(input);
        Node exceptionTextNode = XPathAPI.selectSingleNode((Node)doc, (String)"ows:ExceptionReport/ows:Exception/ows:ExceptionText/text()");
        Assert.assertNotNull((Object)exceptionTextNode);
        String exceptionText = exceptionTextNode.getNodeValue().replaceAll("\\s+", " ");
        Assert.assertEquals((Object)"hello service exception NullPointerException", (Object)exceptionText);
    }

    @Test
    public void exceptionType() throws Exception {
        String message1 = "foo & <foo> \"foo's\"";
        String message2 = "a \"different\" <message>";
        ServiceException exception = new ServiceException(message1);
        exception.setLocator("test-locator");
        exception.getExceptionText().add(message2);
        handler.handleServiceException(exception, requestInfo);
        Assert.assertEquals((Object)XML_TYPE_TEXT, (Object)response.getContentType());
    }
}

