/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.geoserver.ows.kvp.FormatOptionsKvpParser;

public class FormatOptionsKvpParserTest
extends TestCase {
    private FormatOptionsKvpParser parser;

    protected void setUp() throws Exception {
        this.parser = new FormatOptionsKvpParser();
    }

    public void testPairs() throws Exception {
        HashMap<String, String> expected = new HashMap<String, String>(){
            {
                this.put("key1", "value1");
                this.put("key2", "value2");
                this.put("key3", "true");
                this.put("key4", "value4");
            }
        };
        Map actual = (Map)this.parser.parse("key1:value1;key2:value2;key3;key4:value4");
        FormatOptionsKvpParserTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testEscapedSeparators() throws Exception {
        HashMap<String, String> expected = new HashMap<String, String>(){
            {
                this.put("key1", "value:1");
                this.put("key2", "value:2");
                this.put("key3", "value:3;ZZZ");
            }
        };
        Map actual = (Map)this.parser.parse("key1:value\\:1;key2:value\\:2;key3:value\\:3\\;ZZZ");
        FormatOptionsKvpParserTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testEmbeddedSeparators() throws Exception {
        HashMap<String, String> expected = new HashMap<String, String>(){
            {
                this.put("key1", "value:1");
                this.put("key2", "value:2");
                this.put("key3", "value:3:ZZ;XX");
            }
        };
        Map actual = (Map)this.parser.parse("key1:value:1;key2:value:2;key3:value:3\\:ZZ\\;XX");
        FormatOptionsKvpParserTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testErrors() throws Exception {
        HashMap<String, String> expected = new HashMap<String, String>(){
            {
                this.put("key1", "value:1");
                this.put("key2", "value:2");
                this.put("key3", "value:3");
            }
        };
        Map actual = (Map)this.parser.parse("key1:value:1;key2:value:2;key3:value:3");
        FormatOptionsKvpParserTest.assertEquals((int)expected.size(), (int)actual.size());
        FormatOptionsKvpParserTest.assertEquals((Object)expected, (Object)actual);
    }
}

