/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.BufferedReader;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;

public class Request {
    protected HttpServletRequest httpRequest;
    protected HttpServletResponse httpResponse;
    protected boolean get;
    protected boolean soap;
    protected Map kvp;
    protected Map rawKvp;
    protected BufferedReader input;
    protected String service;
    protected String request;
    protected String version;
    protected String namespace;
    protected Service serviceDescriptor;
    protected String context;
    protected String path;
    protected String outputFormat;
    protected Throwable error;
    protected Date timestamp;
    protected Operation operation;
    protected UUID identifier;
    private String soapNamespace;

    public Request() {
        this.timestamp = new Date();
        this.identifier = UUID.randomUUID();
    }

    public Request(Request other) {
        this.httpRequest = other.httpRequest;
        this.httpResponse = other.httpResponse;
        this.get = other.get;
        this.soap = other.soap;
        this.kvp = other.kvp;
        this.rawKvp = other.rawKvp;
        this.input = other.input;
        this.service = other.service;
        this.request = other.request;
        this.version = other.version;
        this.namespace = other.namespace;
        this.serviceDescriptor = other.serviceDescriptor;
        this.context = other.context;
        this.path = other.path;
        this.outputFormat = other.outputFormat;
        this.error = other.error;
        this.timestamp = other.timestamp;
        this.operation = other.operation;
        this.identifier = other.identifier;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    public boolean isGet() {
        return this.get;
    }

    public boolean isSOAP() {
        return this.soap;
    }

    public Map getKvp() {
        return this.kvp;
    }

    public Map getRawKvp() {
        return this.rawKvp;
    }

    public BufferedReader getInput() {
        return this.input;
    }

    public String getService() {
        return this.service;
    }

    public String getRequest() {
        return this.request;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Service getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Throwable getError() {
        return this.error;
    }

    public String toString() {
        return this.getService() + " " + this.getVersion() + " " + this.getRequest();
    }

    public void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setHttpResponse(HttpServletResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public void setGet(boolean get) {
        this.get = get;
    }

    public void setSOAP(boolean soap) {
        this.soap = soap;
    }

    public void setKvp(Map kvp) {
        this.kvp = kvp;
    }

    public void setOrAppendKvp(Map kvp) {
        if (this.kvp == null) {
            this.setKvp(kvp);
        } else {
            this.kvp.putAll(kvp);
        }
    }

    public void setRawKvp(Map rawKvp) {
        this.rawKvp = rawKvp;
    }

    public void setInput(BufferedReader input) {
        this.input = input;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setServiceDescriptor(Service serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Request other = (Request)obj;
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }

    public void setSOAPNamespace(String soapNamespace) {
        this.soapNamespace = soapNamespace;
    }

    public String getSOAPNamespace() {
        return this.soapNamespace;
    }
}

