/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.util.Collection;
import java.util.List;
import net.opengis.ows11.AcceptVersionsType;
import net.opengis.ows11.Ows11Factory;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.RequestUtils;
import org.geotools.util.Version;

public class OWS11AcceptVersionsKvpParser
extends KvpParser {
    public OWS11AcceptVersionsKvpParser() {
        super("AcceptVersions", AcceptVersionsType.class);
        this.setVersion(new Version("1.1.1"));
    }

    @Override
    public Object parse(String value) throws Exception {
        List versions = KvpUtils.readFlat(value);
        for (String version : versions) {
            RequestUtils.checkVersionNumber(version, "AcceptVersions");
        }
        AcceptVersionsType accepts = Ows11Factory.eINSTANCE.createAcceptVersionsType();
        accepts.getVersion().addAll((Collection)versions);
        return accepts;
    }
}

