/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.SystemUtils;
import org.geoserver.ows.ClasspathPublisher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class ClasspathPublisherTest {
    @Test
    public void testPathTraversalAnyOS() {
        ClasspathPublisherTest.doTestPathTraversal("/schemas/../META-INF/MANIFEST.MF");
    }

    @Test
    public void testPathTraversalWindowsOnly() {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_WINDOWS);
        ClasspathPublisherTest.doTestPathTraversal("/schemas/..\\META-INF/MANIFEST.MF");
    }

    private static void doTestPathTraversal(String path) {
        ClasspathPublisher publisher = new ClasspathPublisher();
        MockHttpServletRequest request = new MockHttpServletRequest("GET", path);
        MockHttpServletResponse response = new MockHttpServletResponse();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> publisher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.startsWith((String)"Contains invalid '..' path: "));
    }
}

