/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.AbstractURLPublisher;
import org.geoserver.ows.FilePublisher;
import org.geoserver.platform.GeoServerResourceLoader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;

public class FilePublisherTest {
    static FilePublisher publisher;
    static MockServletContext context;
    static List<String[]> paths;

    @BeforeClass
    public static void create() throws Exception {
        File tmp = File.createTempFile("xyz", "123");
        tmp.delete();
        tmp.mkdirs();
        tmp.deleteOnExit();
        paths.add(FilePublisherTest.create(tmp, "with space", "ascii"));
        paths.add(FilePublisherTest.create(tmp, "with space", "l\u00e0t\u00een"));
        GeoServerResourceLoader loader = new GeoServerResourceLoader(tmp);
        publisher = new FilePublisher(loader);
        context = new MockServletContext();
        publisher.setServletContext((ServletContext)context);
        Files.write(loader.createFile("index.html").toPath(), "BAD".getBytes(), new OpenOption[0]);
        loader.createFile("www/test.foo");
        loader.createFile("www/test.bar");
    }

    static String[] create(File parent, String ... path) throws Exception {
        for (int i = 0; i < path.length - 1; ++i) {
            parent = new File(parent, path[i]);
            parent.deleteOnExit();
        }
        parent.mkdirs();
        String fname = path[path.length - 1];
        File file = new File(parent, fname);
        file.deleteOnExit();
        try (FileOutputStream fout = new FileOutputStream(file);){
            fout.write(fname.getBytes(StandardCharsets.UTF_8));
        }
        return path;
    }

    @After
    public void resetProperty() {
        System.clearProperty("GEOSERVER_DISABLE_STATIC_WEB_FILES");
    }

    @AfterClass
    public static void destroy() {
    }

    private MockHttpServletResponse request(String[] path, String modifiedSince) throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/geoserver");
        request.setMethod("GET");
        StringBuilder b = new StringBuilder("/geoserver");
        for (String s : path) {
            b.append('/').append(s);
        }
        String uri = URLEncoder.encode(b.toString(), "UTF-8");
        request.setRequestURI(uri);
        if (modifiedSince != null) {
            request.addHeader("If-Modified-Since", (Object)modifiedSince);
        }
        MockHttpServletResponse response = new MockHttpServletResponse();
        publisher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        return response;
    }

    @Test
    public void testEncoding() throws Exception {
        for (Object[] objectArray : paths) {
            MockHttpServletResponse response = this.request((String[])objectArray, null);
            Assert.assertEquals((String)Arrays.toString(objectArray), (long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)objectArray[objectArray.length - 1], (Object)response.getContentAsString());
        }
    }

    @Test
    public void testLastModified() throws Exception {
        for (String[] path : paths) {
            MockHttpServletResponse response = this.request(path, null);
            String lastModified = response.getHeader("Last-Modified");
            Assert.assertNotNull((Object)lastModified);
            response = this.request(path, lastModified);
            Assert.assertEquals((long)304L, (long)response.getStatus());
            long timeStamp = AbstractURLPublisher.lastModified((String)lastModified) + 10000L;
            response = this.request(path, AbstractURLPublisher.lastModified((long)timeStamp));
            Assert.assertEquals((long)304L, (long)response.getStatus());
            response = this.request(path, AbstractURLPublisher.lastModified((long)(timeStamp -= 20000L)));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)path[path.length - 1], (Object)response.getContentAsString());
        }
    }

    @Test
    public void testMimeDefault() throws Exception {
        this.doTestTypeAndDisposition("www/", "test.bar", null, "application/octet-stream", "inline");
    }

    @Test
    public void testMimeTextXml() throws Exception {
        this.doTestTypeAndDisposition("www/", "test.foo", MediaType.TEXT_XML, "text/xml", "attachment");
    }

    @Test
    public void testMimeApplicationXml() throws Exception {
        this.doTestTypeAndDisposition("www/", "test.foo", MediaType.APPLICATION_XML, "application/xml", "attachment");
    }

    @Test
    public void testMimeImageSvgXml() throws Exception {
        this.doTestTypeAndDisposition("www/", "test.foo", MediaType.valueOf((String)"image/svg+xml"), "image/svg+xml", "attachment");
    }

    @Test
    public void testMimeTextHtmlPropUndefined() throws Exception {
        System.clearProperty("GEOSERVER_DISABLE_STATIC_WEB_FILES");
        this.doTestTypeAndDisposition("www/", "test.foo", MediaType.TEXT_HTML, "text/html", "inline");
    }

    @Test
    public void testMimeTextHtmlPropFalse() throws Exception {
        System.setProperty("GEOSERVER_DISABLE_STATIC_WEB_FILES", "false");
        this.doTestTypeAndDisposition("www/", "test.foo", MediaType.TEXT_HTML, "text/html", "inline");
    }

    @Test
    public void testMimeTextHtmlPropTrue() throws Exception {
        System.setProperty("GEOSERVER_DISABLE_STATIC_WEB_FILES", "true");
        this.doTestTypeAndDisposition("www/", "test.foo", MediaType.TEXT_HTML, "text/plain", "inline");
    }

    @Test
    public void testMimeApplicationJavascriptPropUndefined() throws Exception {
        System.clearProperty("GEOSERVER_DISABLE_STATIC_WEB_FILES");
        this.doTestTypeAndDisposition("www/", "test.foo", MediaType.valueOf((String)"application/javascript"), "application/javascript", "inline");
    }

    @Test
    public void testMimeApplicationJavascriptPropFalse() throws Exception {
        System.setProperty("GEOSERVER_DISABLE_STATIC_WEB_FILES", "false");
        this.doTestTypeAndDisposition("www/", "test.foo", MediaType.valueOf((String)"application/javascript"), "application/javascript", "inline");
    }

    @Test
    public void testMimeApplicationJavascriptPropTrue() throws Exception {
        System.setProperty("GEOSERVER_DISABLE_STATIC_WEB_FILES", "true");
        this.doTestTypeAndDisposition("www/", "test.foo", MediaType.valueOf((String)"application/javascript"), "text/plain", "inline");
    }

    @Test
    public void testMimeWhitelistedHtmlFile() throws Exception {
        System.setProperty("GEOSERVER_DISABLE_STATIC_WEB_FILES", "true");
        String content = this.doTestTypeAndDisposition("", "index.html", MediaType.TEXT_HTML, "text/html", "inline");
        Assert.assertEquals((Object)"GOOD", (Object)content);
        content = this.doTestTypeAndDisposition("", "accessDenied.html", MediaType.TEXT_HTML, "text/html", "inline");
        Assert.assertEquals((Object)"DENIED", (Object)content);
    }

    private String doTestTypeAndDisposition(String path, String filename, MediaType serverType, String responseType, String dispositionType) throws Exception {
        String[] paths = new String[]{path + filename};
        if (serverType != null) {
            context.addMimeType("foo", serverType);
        }
        MockHttpServletResponse response = this.request(paths, null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getHeader("Content-Type"), (Matcher)Matchers.startsWith((String)responseType));
        Assert.assertEquals((Object)(dispositionType + "; filename=\"" + filename + "\""), (Object)response.getHeader("Content-Disposition"));
        return response.getContentAsString();
    }

    static {
        paths = new ArrayList<String[]>();
    }
}

