/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.util.ResponseUtils;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class ResponseUtilsTest {
    @Test
    public void testBaseURL() {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setScheme("http");
        req.setServerPort(80);
        Assert.assertEquals((Object)"http://localhost/", (Object)ResponseUtils.baseURL((HttpServletRequest)req));
        req.setServerPort(1234);
        Assert.assertEquals((Object)"http://localhost:1234/", (Object)ResponseUtils.baseURL((HttpServletRequest)req));
        req.setScheme("https");
        Assert.assertEquals((Object)"https://localhost:1234/", (Object)ResponseUtils.baseURL((HttpServletRequest)req));
        req.setServerPort(443);
        Assert.assertEquals((Object)"https://localhost/", (Object)ResponseUtils.baseURL((HttpServletRequest)req));
    }

    @Test
    public void testPathQueryString() {
        String url = "http://localhost:8080/geoserver/wfs?service=WFS&version=1.0.0&request=GetCapabilities";
        Assert.assertEquals((Object)"/geoserver/wfs", (Object)ResponseUtils.getPath((String)url));
        Assert.assertEquals((Object)"service=WFS&version=1.0.0&request=GetCapabilities", (Object)ResponseUtils.getQueryString((String)url));
    }

    @Test
    public void testIncompleteURL() {
        String url = "/geoserver/wfs?service=WFS&version=1.0.0&request=GetCapabilities";
        Assert.assertEquals((Object)"/geoserver/wfs", (Object)ResponseUtils.getPath((String)url));
        Assert.assertEquals((Object)"service=WFS&version=1.0.0&request=GetCapabilities", (Object)ResponseUtils.getQueryString((String)url));
    }
}

