/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.xml.v1_0;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.opengis.ows10.ExceptionReportType;
import net.opengis.ows10.ExceptionType;
import org.geoserver.ows.xml.v1_0.OWS;
import org.geoserver.ows.xml.v1_0.OWSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.test.XMLTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ExceptionReportBindingTest
extends XMLTestSupport {
    protected Configuration createConfiguration() {
        return new OWSConfiguration();
    }

    Document dom(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(xml.getBytes()));
    }

    @Test
    public void testParseServiceException() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ows:ExceptionReport version=\"1.0.0\"\n  xsi:schemaLocation=\"http://www.opengis.net/ows http://demo.opengeo.org/geoserver/schemas/ows/1.0.0/owsExceptionReport.xsd\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ows=\"http://www.opengis.net/ows\">\n  <ows:Exception exceptionCode=\"InvalidParameterValue\" locator=\"service\">\n    <ows:ExceptionText>No service: ( madeUp )</ows:ExceptionText>\n  </ows:Exception>\n</ows:ExceptionReport>\n";
        this.document = this.dom(xml);
        Object result = this.parse(OWS.EXCEPTIONREPORT);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof ExceptionReportType));
        ExceptionReportType er = (ExceptionReportType)result;
        Assert.assertEquals((Object)"1.0.0", (Object)er.getVersion());
        Assert.assertEquals((long)1L, (long)er.getException().size());
        ExceptionType ex = (ExceptionType)er.getException().get(0);
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)ex.getExceptionCode());
        Assert.assertEquals((Object)"service", (Object)ex.getLocator());
        Assert.assertEquals((long)1L, (long)ex.getExceptionText().size());
        Assert.assertEquals((Object)"No service: ( madeUp )", (Object)ex.getExceptionText().get(0));
    }
}

