/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.FileSystemWatcher;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.ResourceNotification;
import org.geoserver.platform.resource.ResourceTheoryTest;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.theories.DataPoints;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

public class FileSystemResourceTheoryTest
extends ResourceTheoryTest {
    FileSystemResourceStore store;
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TestName testName = new TestName();

    @DataPoints
    public static String[] testPaths() {
        return new String[]{"FileA", "FileB", "DirC", "DirC/FileD", "DirE", "UndefF", "DirC/UndefF", "DirE/UndefF", "DirE/UndefG/UndefH/UndefI"};
    }

    @Override
    protected Resource getResource(String path) throws Exception {
        return this.store.get(path);
    }

    @Before
    public void setUp() throws Exception {
        this.folder.newFile("FileA");
        this.folder.newFile("FileB");
        File c = this.folder.newFolder("DirC");
        new File(c, "FileD").createNewFile();
        this.folder.newFolder("DirE");
        this.store = new FileSystemResourceStore(this.folder.getRoot());
    }

    @After
    public void after() throws Exception {
        if (this.store != null && this.store.watcher.get() != null) {
            ((FileSystemWatcher)this.store.watcher.get()).destroy();
        }
    }

    @Test
    public void invalid() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Contains invalid .. path");
        this.store.get("..");
    }

    @Test
    public void fileEvents() throws Exception {
        File fileD = Paths.toFile((File)this.store.baseDirectory, (String)"DirC/FileD");
        AwaitResourceListener listener = new AwaitResourceListener();
        this.store.get("DirC/FileD").addListener((ResourceListener)listener);
        ((FileSystemWatcher)this.store.getResourceNotificationDispatcher()).schedule(30L, TimeUnit.MILLISECONDS);
        long before = fileD.lastModified();
        long after = this.touch(fileD);
        Assert.assertTrue((String)"touched", (after > before ? 1 : 0) != 0);
        ResourceNotification n = listener.await(1, TimeUnit.SECONDS);
        Assert.assertNotNull((String)"detected event", (Object)n);
        Assert.assertEquals((String)"file modified", (Object)ResourceNotification.Kind.ENTRY_MODIFY, (Object)n.getKind());
        Assert.assertTrue((String)"Resource only", (boolean)n.events().isEmpty());
        listener.reset();
        fileD.delete();
        n = listener.await(5, TimeUnit.SECONDS);
        Assert.assertEquals((String)"file removed", (Object)ResourceNotification.Kind.ENTRY_DELETE, (Object)n.getKind());
        listener.reset();
        fileD.createNewFile();
        n = listener.await(5, TimeUnit.SECONDS);
        Assert.assertEquals((String)"file created", (Object)ResourceNotification.Kind.ENTRY_CREATE, (Object)n.getKind());
        this.store.get("DirC/FileD").removeListener((ResourceListener)listener);
    }

    private long touch(File file) {
        long origional = file.lastModified();
        if (origional == 0L) {
            try {
                Files.createFile(file.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return file.lastModified();
        }
        long after = origional;
        do {
            file.setLastModified(System.currentTimeMillis());
        } while (origional == (after = file.lastModified()));
        return after;
    }

    @Test
    public void eventNotification() throws InterruptedException {
        AwaitResourceListener listener = new AwaitResourceListener();
        ResourceNotification notification = new ResourceNotification(".", ResourceNotification.Kind.ENTRY_CREATE, 1000000L);
        CompletableFuture.runAsync(() -> listener.changed(notification));
        ResourceNotification n = listener.await(500, TimeUnit.MILLISECONDS);
        Assert.assertSame((Object)notification, (Object)n);
        listener.reset();
        this.expectedException.expect(ConditionTimeoutException.class);
        listener.await(100, TimeUnit.MILLISECONDS);
    }

    @Test
    public void directoryEvents() throws Exception {
        File fileA = Paths.toFile((File)this.store.baseDirectory, (String)"FileA");
        File fileB = Paths.toFile((File)this.store.baseDirectory, (String)"FileB");
        File dirC = Paths.toFile((File)this.store.baseDirectory, (String)"DirC");
        File fileD = Paths.toFile((File)this.store.baseDirectory, (String)"DirC/FileD");
        File dirE = Paths.toFile((File)this.store.baseDirectory, (String)"DirE");
        AwaitResourceListener listener = new AwaitResourceListener();
        this.store.get("").addListener((ResourceListener)listener);
        ((FileSystemWatcher)this.store.getResourceNotificationDispatcher()).schedule(100L, TimeUnit.MILLISECONDS);
        long before = fileB.lastModified();
        long after = this.touch(fileB);
        Assert.assertTrue((String)"touched", (after > before ? 1 : 0) != 0);
        ResourceNotification n = listener.await(500, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_MODIFY, (Object)n.getKind());
        Assert.assertEquals((Object)"", (Object)n.getPath());
        Assert.assertEquals((long)1L, (long)n.events().size());
        ResourceNotification.Event e = (ResourceNotification.Event)n.events().get(0);
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_MODIFY, (Object)e.getKind());
        Assert.assertEquals((Object)"FileB", (Object)e.getPath());
        listener.reset();
        fileA.delete();
        n = listener.await(5, TimeUnit.SECONDS);
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_MODIFY, (Object)n.getKind());
        Assert.assertEquals((Object)"", (Object)n.getPath());
        e = (ResourceNotification.Event)n.events().get(0);
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_DELETE, (Object)e.getKind());
        Assert.assertEquals((Object)"FileA", (Object)e.getPath());
        listener.reset();
        fileA.createNewFile();
        n = listener.await(2, TimeUnit.SECONDS);
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_MODIFY, (Object)n.getKind());
        Assert.assertEquals((Object)"", (Object)n.getPath());
        e = (ResourceNotification.Event)n.events().get(0);
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_CREATE, (Object)e.getKind());
        Assert.assertEquals((Object)"FileA", (Object)e.getPath());
        this.store.get("").removeListener((ResourceListener)listener);
    }

    @Test
    public void emptyDirectoryCreateEventShouldNotBeRaised() throws Exception {
        String dirName = this.testName.getMethodName();
        File watchedDir = Paths.toFile((File)this.store.baseDirectory, (String)dirName);
        FileSystemWatcher watcher = (FileSystemWatcher)this.store.getResourceNotificationDispatcher();
        watcher.schedule(100L, TimeUnit.MILLISECONDS);
        AwaitResourceListener listener = new AwaitResourceListener();
        watcher.addListener(watchedDir.getName(), (ResourceListener)listener);
        Assert.assertFalse((boolean)watchedDir.exists());
        Assert.assertTrue((boolean)watchedDir.mkdir());
        this.exception.expect(ConditionTimeoutException.class);
        listener.await(500, TimeUnit.MILLISECONDS);
    }

    @Test
    public void directoryCreateEventWithContents() throws Exception {
        String dirName = this.testName.getMethodName();
        File watchedDir = Paths.toFile((File)this.store.baseDirectory, (String)dirName);
        File fileA = new File(watchedDir, "FileA");
        FileSystemWatcher watcher = (FileSystemWatcher)this.store.getResourceNotificationDispatcher();
        watcher.schedule(100L, TimeUnit.MILLISECONDS);
        AwaitResourceListener listener = new AwaitResourceListener();
        watcher.addListener(watchedDir.getName(), (ResourceListener)listener);
        Assert.assertFalse((boolean)watchedDir.exists());
        Assert.assertTrue((boolean)watchedDir.mkdir());
        this.touch(fileA);
        Assert.assertTrue((boolean)fileA.exists());
        ResourceNotification n = listener.await(500, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)dirName, (Object)n.getPath());
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_CREATE, (Object)n.getKind());
        Assert.assertEquals((long)1L, (long)n.events().size());
        ResourceNotification.Event event = (ResourceNotification.Event)n.events().get(0);
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_CREATE, (Object)event.getKind());
        Assert.assertEquals((Object)"FileA", (Object)event.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dynamicAsyncDirectoryEvents() throws Exception {
        String dirName = this.testName.getMethodName();
        File watchedDir = Paths.toFile((File)this.store.baseDirectory, (String)dirName);
        FileSystemWatcher watcher = (FileSystemWatcher)this.store.getResourceNotificationDispatcher();
        watcher.schedule(100L, TimeUnit.MILLISECONDS);
        CopyOnWriteArrayList notifications = new CopyOnWriteArrayList();
        watcher.addListener(dirName, notifications::add);
        int fileCount = 256;
        Set files = IntStream.range(0, fileCount).mapToObj(i -> String.format("File%d", i)).collect(Collectors.toSet());
        ArrayBlockingQueue names = new ArrayBlockingQueue(files.size(), true, files);
        Callable<Void> asyncFileModifier = () -> {
            String resource;
            while ((resource = (String)names.poll()) != null) {
                try {
                    Thread.sleep(10L);
                    File f = new File(watchedDir, resource);
                    f.getParentFile().mkdir();
                    this.touch(f);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        };
        int nthreads = 8;
        ExecutorService executorService = Executors.newFixedThreadPool(8);
        try {
            executorService.invokeAll(Collections.nCopies(8, asyncFileModifier));
        }
        finally {
            executorService.shutdown();
        }
        for (int step = 0; step < 2000; ++step) {
            Thread.sleep(20L);
            if (notifications.stream().map(ResourceNotification::events).flatMap(Collection::stream).count() == (long)fileCount) break;
        }
        Assert.assertEquals((long)1L, (long)notifications.stream().filter(n -> n.getKind() == ResourceNotification.Kind.ENTRY_CREATE).count());
        Assert.assertEquals((long)(notifications.size() - 1), (long)notifications.stream().filter(n -> n.getKind() == ResourceNotification.Kind.ENTRY_MODIFY).count());
        List fileEvents = notifications.stream().map(ResourceNotification::events).flatMap(Collection::stream).collect(Collectors.toList());
        Assert.assertEquals((long)files.size(), (long)fileEvents.size());
    }

    @Override
    protected Resource getDirectory() {
        try {
            this.folder.newFolder("NonTestDir");
        }
        catch (IOException e) {
            Assert.fail();
        }
        return this.store.get("NonTestDir");
    }

    @Override
    protected Resource getResource() {
        try {
            this.folder.newFile("NonTestFile");
        }
        catch (IOException e) {
            Assert.fail();
        }
        return this.store.get("NonTestFile");
    }

    @Override
    protected Resource getUndefined() {
        return this.store.get("NonTestUndef");
    }

    static class AwaitResourceListener
    implements ResourceListener {
        private final AtomicReference<ResourceNotification> reference = new AtomicReference();

        AwaitResourceListener() {
        }

        public void changed(ResourceNotification notify) {
            this.reference.set(notify);
        }

        public void reset() {
            this.reference.set(null);
        }

        public ResourceNotification await(int timeout, TimeUnit unit) {
            return (ResourceNotification)Awaitility.await().pollInterval(5L, TimeUnit.MILLISECONDS).atMost((long)timeout, unit).untilAtomic(this.reference, IsNull.notNullValue());
        }
    }
}

