/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.geoserver.platform.resource.AbstractResourceNotificationDispatcherTest;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.ResourceNotification;
import org.geoserver.platform.resource.ResourceNotificationDispatcher;
import org.geoserver.platform.resource.SimpleResourceNotificationDispatcher;
import org.junit.Assert;
import org.junit.Test;

public class SimpleResourceNotificationDispatcherTest
extends AbstractResourceNotificationDispatcherTest {
    @Override
    protected ResourceNotificationDispatcher initWatcher() {
        return new SimpleResourceNotificationDispatcher();
    }

    @Test
    public void testRenameEvents() {
        Resource src = this.store.get("DirA");
        Resource dest = this.store.get("DirB");
        List events = SimpleResourceNotificationDispatcher.createRenameEvents((Resource)src, (Resource)dest);
        Assert.assertEquals((long)6L, (long)events.size());
        HashSet<String> set = new HashSet<String>();
        set.add("DirB");
        set.add("DirB/FileA1");
        set.add("DirB/FileA2");
        set.add("DirB/DirC");
        set.add("DirB/DirC/FileC1");
        set.add("DirB/DirC/FileC2");
        for (ResourceNotification.Event event : events) {
            String path = event.getPath();
            Assert.assertEquals((Object)(path.equals("DirB") || path.equals("DirB/FileA2") ? ResourceNotification.Kind.ENTRY_MODIFY : ResourceNotification.Kind.ENTRY_CREATE), (Object)event.getKind());
            Assert.assertTrue((boolean)set.remove(path));
        }
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testDeleteEvents() {
        Resource res = this.store.get("DirA");
        List events = SimpleResourceNotificationDispatcher.createEvents((Resource)res, (ResourceNotification.Kind)ResourceNotification.Kind.ENTRY_DELETE);
        Assert.assertEquals((long)6L, (long)events.size());
        HashSet<String> set = new HashSet<String>();
        set.add("DirA");
        set.add("DirA/FileA1");
        set.add("DirA/FileA2");
        set.add("DirA/DirC");
        set.add("DirA/DirC/FileC1");
        set.add("DirA/DirC/FileC2");
        for (ResourceNotification.Event event : events) {
            Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_DELETE, (Object)event.getKind());
            Assert.assertTrue((boolean)set.remove(event.getPath()));
        }
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testCreateEvents() {
        Resource res = this.store.get("DirD/DirE/DirF/FileQ");
        List events = SimpleResourceNotificationDispatcher.createEvents((Resource)res, (ResourceNotification.Kind)ResourceNotification.Kind.ENTRY_CREATE);
        Assert.assertEquals((long)4L, (long)events.size());
        HashSet<String> set = new HashSet<String>();
        set.add("DirD");
        set.add("DirD/DirE");
        set.add("DirD/DirE/DirF");
        set.add("DirD/DirE/DirF/FileQ");
        for (ResourceNotification.Event event : events) {
            Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_CREATE, (Object)event.getKind());
            Assert.assertTrue((boolean)set.remove(event.getPath()));
        }
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testPropagation() throws IOException {
        SimpleResourceNotificationDispatcher dispatch = new SimpleResourceNotificationDispatcher();
        final AtomicReference dirEvent = new AtomicReference();
        dispatch.addListener("DirB", new ResourceListener(){

            public void changed(ResourceNotification notify) {
                dirEvent.set(notify);
            }
        });
        dispatch.changed(new ResourceNotification("DirB/DirNew/FileNew", ResourceNotification.Kind.ENTRY_CREATE, System.currentTimeMillis(), SimpleResourceNotificationDispatcher.createEvents((Resource)this.store.get("DirB/DirNew/FileNew"), (ResourceNotification.Kind)ResourceNotification.Kind.ENTRY_CREATE)));
        Assert.assertNotNull(dirEvent.get());
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_MODIFY, (Object)((ResourceNotification)dirEvent.get()).getKind());
        Assert.assertEquals((Object)"DirB", (Object)((ResourceNotification)dirEvent.get()).getPath());
        Assert.assertEquals((long)2L, (long)((ResourceNotification)dirEvent.get()).events().size());
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_CREATE, (Object)((ResourceNotification.Event)((ResourceNotification)dirEvent.get()).events().get(0)).getKind());
        Assert.assertEquals((Object)"DirNew/FileNew", (Object)((ResourceNotification.Event)((ResourceNotification)dirEvent.get()).events().get(0)).getPath());
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_CREATE, (Object)((ResourceNotification.Event)((ResourceNotification)dirEvent.get()).events().get(1)).getKind());
        Assert.assertEquals((Object)"DirNew", (Object)((ResourceNotification.Event)((ResourceNotification)dirEvent.get()).events().get(1)).getPath());
    }
}

