/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.Optional;
import org.geoserver.platform.ModuleStatus;

public class RenderingEngineStatus
implements ModuleStatus {
    private static final String DEFAULT = "PLATFORM DEFAULT";
    private String provider = System.getProperty("sun.java2d.renderer", "PLATFORM DEFAULT");

    @Override
    public String getModule() {
        return "jvm";
    }

    @Override
    public Optional<String> getComponent() {
        return Optional.ofNullable("java2d");
    }

    @Override
    public String getName() {
        return "Rendering Engine";
    }

    @Override
    public Optional<String> getVersion() {
        return Optional.ofNullable(System.getProperty("java.version"));
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public Optional<String> getMessage() {
        StringBuilder msg = new StringBuilder();
        msg.append("Java 2D renderer configured with: ");
        msg.append(this.provider);
        return Optional.of(msg.toString());
    }

    @Override
    public Optional<String> getDocumentation() {
        return Optional.empty();
    }
}

