/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import javax.servlet.ServletContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.LockProvider;
import org.geoserver.platform.resource.MemoryLockProvider;
import org.geoserver.platform.resource.Resource;
import org.geoserver.util.IOUtils;
import org.springframework.web.context.ServletContextAware;

public class FileLockProvider
implements LockProvider,
ServletContextAware {
    public static Log LOGGER = LogFactory.getLog(FileLockProvider.class);
    private File root;
    int waitBeforeRetry = 20;
    int maxLockAttempts = 120000 / this.waitBeforeRetry;
    MemoryLockProvider memoryProvider = new MemoryLockProvider();

    public FileLockProvider() {
    }

    public FileLockProvider(File basePath) {
        this.root = basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource.Lock acquire(final String lockKey) {
        Resource.Lock lock;
        FileOutputStream currFos;
        File file;
        block16: {
            final Resource.Lock memoryLock = this.memoryProvider.acquire(lockKey);
            file = this.getFile(lockKey);
            currFos = null;
            FileLock currLock = null;
            try {
                int count;
                for (count = 0; currLock == null && count < this.maxLockAttempts; ++count) {
                    currFos = new FileOutputStream(file);
                    try {
                        currLock = currFos.getChannel().lock();
                        continue;
                    }
                    catch (OverlappingFileLockException e) {
                        IOUtils.closeQuietly(currFos);
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    catch (IOException e) {
                        IOUtils.closeQuietly(currFos);
                        try {
                            Thread.sleep(20L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (count >= this.maxLockAttempts) {
                    throw new IllegalStateException("Failed to get a lock on key " + lockKey + " after " + count + " attempts");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Lock " + lockKey + " acquired by thread " + Thread.currentThread().getId() + " on file " + file));
                }
                final FileOutputStream fos = currFos;
                final FileLock lock2 = currLock;
                currFos = null;
                currLock = null;
                lock = new Resource.Lock(){
                    boolean released;

                    @Override
                    public void release() {
                        if (this.released) {
                            return;
                        }
                        try {
                            this.released = true;
                            if (!lock2.isValid() && LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)("Lock key " + lockKey + " for releasing lock is unkonwn, it means this lock was never acquired, or was released twice. Current thread is: " + Thread.currentThread().getId() + ". Are you running two instances in the same JVM using NIO locks? This case is not supported and will generate exactly this error message"));
                                return;
                            }
                            try {
                                lock2.release();
                                IOUtils.closeQuietly(fos);
                                file.delete();
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug((Object)("Lock " + lockKey + " released by thread " + Thread.currentThread().getId()));
                                }
                            }
                            catch (IOException e) {
                                throw new IllegalStateException("Failure while trying to release lock for key " + lockKey, e);
                            }
                        }
                        finally {
                            memoryLock.release();
                        }
                    }

                    public String toString() {
                        return "FileLock " + file.getName();
                    }
                };
                if (currLock == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (currLock != null) {
                        currLock.release();
                        memoryLock.release();
                    }
                    IOUtils.closeQuietly(currFos);
                    file.delete();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failure while trying to get lock for key " + lockKey, e);
                }
            }
            currLock.release();
            memoryLock.release();
        }
        IOUtils.closeQuietly(currFos);
        file.delete();
        return lock;
    }

    private File getFile(String lockKey) {
        File locks = new File(this.root, "filelocks");
        locks.mkdirs();
        String sha1 = DigestUtils.sha1Hex((String)lockKey);
        return new File(locks, sha1 + ".lock");
    }

    public void setServletContext(ServletContext servletContext) {
        String data = GeoServerResourceLoader.lookupGeoServerDataDirectory(servletContext);
        if (data == null) {
            throw new IllegalStateException("Unable to determine data directory");
        }
        this.root = new File(data);
    }

    public String toString() {
        return "FileLockProvider " + this.root;
    }
}

