/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.exception;

import java.util.Locale;
import org.geoserver.platform.exception.GeoServerException;
import org.geoserver.platform.exception.GeoServerExceptions;
import org.geoserver.platform.exception.IGeoServerException;
import org.geoserver.platform.exception.TestException;
import org.geoserver.platform.exception.TestException2;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionLocalizeTest {
    @Test
    public void test() throws Exception {
        GeoServerException e = new TestException().id("hi");
        Assert.assertEquals((Object)"hello", (Object)GeoServerExceptions.localize((IGeoServerException)e));
    }

    @Test
    public void testFallback() throws Exception {
        GeoServerException e = new TestException2().id("hi");
        Assert.assertEquals((Object)"hello", (Object)GeoServerExceptions.localize((IGeoServerException)e, (Locale)Locale.FRENCH));
    }

    @Test
    public void testLocale() throws Exception {
        GeoServerException e = new TestException().id("hi");
        Assert.assertEquals((Object)"bonjour", (Object)GeoServerExceptions.localize((IGeoServerException)e, (Locale)Locale.FRENCH));
    }

    @Test
    public void testUnknownLocale() throws Exception {
        GeoServerException e = new TestException().id("hi");
        Assert.assertEquals((Object)"hello", (Object)GeoServerExceptions.localize((IGeoServerException)e, (Locale)Locale.GERMAN));
    }

    @Test
    public void testWithArgs() throws Exception {
        GeoServerException e = new TestException().id("hey").args(new Object[]{"neo"});
        Assert.assertEquals((Object)"hello neo", (Object)GeoServerExceptions.localize((IGeoServerException)e));
        Assert.assertEquals((Object)"bonjour neo", (Object)GeoServerExceptions.localize((IGeoServerException)e, (Locale)Locale.FRENCH));
    }

    @Test
    public void testWithNewDefault() throws Exception {
        Locale old = Locale.getDefault();
        Locale.setDefault(Locale.FRENCH);
        try {
            Assert.assertEquals((Object)"bonjour", (Object)GeoServerExceptions.localize((IGeoServerException)new TestException().id("hi")));
        }
        finally {
            Locale.setDefault(old);
        }
    }
}

