/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.geoserver.platform.resource.Resource;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class ResourceHasContents
extends BaseMatcher<Resource> {
    final byte[] contents;

    public ResourceHasContents(byte[] contents) {
        this.contents = contents;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matches(Object item) {
        if (!(item instanceof Resource)) return false;
        try (InputStream in = ((Resource)item).in();){
            byte[] result = new byte[this.contents.length];
            int len = in.read(result);
            if (len != this.contents.length) {
                boolean bl = false;
                return bl;
            }
            if (in.read() != -1) {
                boolean bl = false;
                return bl;
            }
            boolean bl = Arrays.equals(this.contents, result);
            return bl;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Exception while reading resource contents", ex);
        }
    }

    public void describeTo(Description description) {
        description.appendText("resource that contains: " + Arrays.toString(this.contents));
    }
}

