/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceDefined;
import org.geoserver.platform.resource.ResourceHasContents;
import org.geoserver.platform.resource.ResourceIsDirectory;
import org.geoserver.platform.resource.ResourceIsLeaf;
import org.geoserver.platform.resource.ResourceUndefined;
import org.hamcrest.Matcher;

public class ResourceMatchers {
    public static Matcher<Resource> defined() {
        return new ResourceDefined();
    }

    public static Matcher<Resource> undefined() {
        return new ResourceUndefined();
    }

    public static Matcher<Resource> resource() {
        return new ResourceIsLeaf();
    }

    public static Matcher<Resource> directory() {
        return new ResourceIsDirectory();
    }

    public static Matcher<Resource> hasContent(byte[] content) {
        return new ResourceHasContents(content);
    }
}

