/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.platform.AdvancedDispatchFilter;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class AdvancedDispatchFilterTest {
    @Test
    public void testPathIsNullNPE() {
        MyMockRequest request = new MyMockRequest("GET", "/test?name=0");
        request.setServerName("localhost");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain filterChain = new MockFilterChain();
        AdvancedDispatchFilter instance = new AdvancedDispatchFilter();
        try {
            instance.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)filterChain);
        }
        catch (Exception ex) {
            Assert.fail((String)"should work");
        }
    }

    @Test
    public void testHandlePathInfoNull() {
        MyMockRequest mockRequest = new MyMockRequest("GET", null);
        mockRequest.setPathInfo(null);
        Assert.assertNull((Object)mockRequest.getPathInfo());
        AdvancedDispatchFilter.AdvancedDispatchHttpRequest advRequest = new AdvancedDispatchFilter.AdvancedDispatchHttpRequest((HttpServletRequest)mockRequest);
        Assert.assertNull((Object)advRequest.getPathInfo());
        advRequest.servletPath = "/bar";
        mockRequest.setPathInfo("/bar/foo");
        Assert.assertEquals((Object)"/bar/foo", (Object)mockRequest.getPathInfo());
        Assert.assertEquals((Object)"/foo", (Object)advRequest.getPathInfo());
        mockRequest.setPathInfo("/foo");
        Assert.assertEquals((Object)"/foo", (Object)mockRequest.getPathInfo());
        Assert.assertEquals((Object)"/foo", (Object)advRequest.getPathInfo());
    }

    class MyMockRequest
    extends MockHttpServletRequest {
        public MyMockRequest(String method, String requestURI) {
            super(method, requestURI);
        }
    }
}

