/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.servlet.ServletContext;
import org.easymock.EasyMock;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GeoServerResourceLoaderTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testRequireSingleExistingFile() {
        GeoServerResourceLoader.requireFile((String)"pom.xml", (String)"Test fixture");
    }

    @Test
    public void testRequireTwoExistingFiles() {
        GeoServerResourceLoader.requireFile((String)("pom.xml" + File.pathSeparator + "src"), (String)"Test fixture");
    }

    @Test
    public void testRequireSingleMissingFile() {
        Assert.assertThrows(IllegalArgumentException.class, () -> GeoServerResourceLoader.requireFile((String)"does-not-exist", (String)"Test fixture"));
    }

    @Test
    public void testRequireSingleMissingFileOfTwo() {
        Assert.assertThrows(IllegalArgumentException.class, () -> GeoServerResourceLoader.requireFile((String)("pom.xml" + File.pathSeparator + "does-not-exist"), (String)"Test fixture"));
    }

    @Test
    public void testLookupRequireExistingFileJava() {
        Assume.assumeThat((Object)System.getenv("GEOSERVER_DATA_DIR"), (Matcher)CoreMatchers.nullValue());
        ServletContext context = (ServletContext)EasyMock.createMock(ServletContext.class);
        EasyMock.expect((Object)context.getInitParameter("GEOSERVER_REQUIRE_FILE")).andReturn(null);
        EasyMock.expect((Object)context.getInitParameter("GEOSERVER_DATA_DIR")).andReturn(null);
        EasyMock.expect((Object)context.getInitParameter("GEOSERVER_DATA_ROOT")).andReturn(null);
        EasyMock.expect((Object)context.getRealPath("/data")).andReturn((Object)"data");
        EasyMock.replay((Object[])new Object[]{context});
        System.setProperty("GEOSERVER_REQUIRE_FILE", "pom.xml");
        System.clearProperty("GEOSERVER_DATA_DIR");
        try {
            Assert.assertEquals((Object)"data", (Object)GeoServerResourceLoader.lookupGeoServerDataDirectory((ServletContext)context));
        }
        finally {
            System.clearProperty("GEOSERVER_REQUIRE_FILE");
        }
    }

    @Test
    public void testLookupRequireMissingFileJava() {
        ServletContext context = (ServletContext)EasyMock.createMock(ServletContext.class);
        EasyMock.expect((Object)context.getInitParameter("GEOSERVER_REQUIRE_FILE")).andReturn(null);
        EasyMock.expect((Object)context.getInitParameter("GEOSERVER_DATA_DIR")).andReturn(null);
        EasyMock.expect((Object)context.getInitParameter("GEOSERVER_DATA_ROOT")).andReturn(null);
        EasyMock.expect((Object)context.getRealPath("/data")).andReturn((Object)"data");
        EasyMock.replay((Object[])new Object[]{context});
        System.setProperty("GEOSERVER_REQUIRE_FILE", "does-not-exist");
        try {
            Assert.assertThrows(IllegalArgumentException.class, () -> GeoServerResourceLoader.lookupGeoServerDataDirectory((ServletContext)context));
        }
        finally {
            System.clearProperty("GEOSERVER_REQUIRE_FILE");
        }
    }

    @Test
    public void testLookupRequireMissingFileServlet() {
        ServletContext context = (ServletContext)EasyMock.createMock(ServletContext.class);
        EasyMock.expect((Object)context.getInitParameter("GEOSERVER_REQUIRE_FILE")).andReturn((Object)"does-not-exist");
        EasyMock.expect((Object)context.getInitParameter("GEOSERVER_DATA_DIR")).andReturn(null);
        EasyMock.expect((Object)context.getInitParameter("GEOSERVER_DATA_ROOT")).andReturn(null);
        EasyMock.expect((Object)context.getRealPath("/data")).andReturn((Object)"data");
        EasyMock.replay((Object[])new Object[]{context});
        Assert.assertThrows(IllegalArgumentException.class, () -> GeoServerResourceLoader.lookupGeoServerDataDirectory((ServletContext)context));
    }

    @Test
    public void testSetBaseDirectory() throws IOException {
        GeoServerResourceLoader loader = new GeoServerResourceLoader();
        Assert.assertNull((Object)loader.getBaseDirectory());
        Assert.assertEquals((Object)ResourceStore.EMPTY, (Object)loader.getResourceStore());
        this.tempFolder.create();
        File tempDir = this.tempFolder.getRoot();
        loader.setBaseDirectory(tempDir);
        Assert.assertEquals((Object)tempDir, (Object)loader.getBaseDirectory());
        Assert.assertTrue((boolean)(loader.getResourceStore() instanceof FileSystemResourceStore));
        ResourceStore mockStore = (ResourceStore)EasyMock.createMock(ResourceStore.class);
        loader = new GeoServerResourceLoader(mockStore);
        Assert.assertNull((Object)loader.getBaseDirectory());
        Assert.assertEquals((Object)mockStore, (Object)loader.getResourceStore());
        loader.setBaseDirectory(tempDir);
        Assert.assertEquals((Object)tempDir, (Object)loader.getBaseDirectory());
        Assert.assertEquals((Object)mockStore, (Object)loader.getResourceStore());
    }

    @Test
    public void fromRelativeURLTest() throws IOException {
        GeoServerResourceLoader loader = new GeoServerResourceLoader();
        this.tempFolder.create();
        File tempDir = this.tempFolder.getRoot();
        loader.setBaseDirectory(tempDir);
        Resource res = loader.fromURL("file:relative/with/special+characters%23%C3%BC");
        Assert.assertEquals((Object)"relative/with/special characters#\u00fc", (Object)res.path());
        try (OutputStream out = res.out();){
            out.write("someText".getBytes());
        }
        Assert.assertEquals((Object)"someText", (Object)Files.asCharSource((File)res.file(), (Charset)Charset.defaultCharset()).read());
    }
}

