/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.ResourceNotification;
import org.geoserver.platform.resource.ResourceNotificationDispatcher;
import org.geoserver.platform.resource.SimpleResourceNotificationDispatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class AbstractResourceNotificationDispatcherTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    protected FileSystemResourceStore store;
    protected ResourceNotificationDispatcher watcher;

    @Before
    public void setup() throws Exception {
        File dirA = this.folder.newFolder("DirA");
        File dirB = this.folder.newFolder("DirB");
        File dirC = new File(dirA, "DirC");
        dirC.mkdir();
        new File(dirA, "FileA1").createNewFile();
        new File(dirA, "FileA2").createNewFile();
        new File(dirB, "FileA2").createNewFile();
        new File(dirB, "FileB1").createNewFile();
        new File(dirB, "FileB2").createNewFile();
        new File(dirC, "FileC1").createNewFile();
        new File(dirC, "FileC2").createNewFile();
        this.store = new FileSystemResourceStore(this.folder.getRoot());
        this.watcher = this.initWatcher();
    }

    protected abstract ResourceNotificationDispatcher initWatcher() throws Exception;

    @Test
    public void testDeleteNotification() {
        Resource res = this.store.get("DirA");
        CheckingResourceListener chkDirA = new CheckingResourceListener(ResourceNotification.Kind.ENTRY_DELETE);
        CheckingResourceListener chkDirC = new CheckingResourceListener(ResourceNotification.Kind.ENTRY_DELETE);
        CheckingResourceListener chkFileA1 = new CheckingResourceListener(ResourceNotification.Kind.ENTRY_DELETE);
        CheckingResourceListener chkFileA2 = new CheckingResourceListener(ResourceNotification.Kind.ENTRY_DELETE);
        CheckingResourceListener chkFileC1 = new CheckingResourceListener(ResourceNotification.Kind.ENTRY_DELETE);
        CheckingResourceListener chkFileC2 = new CheckingResourceListener(ResourceNotification.Kind.ENTRY_DELETE);
        this.watcher.addListener(res.path(), (ResourceListener)chkDirA);
        this.watcher.addListener(res.get("FileA1").path(), (ResourceListener)chkFileA1);
        this.watcher.addListener(res.get("FileA2").path(), (ResourceListener)chkFileA2);
        this.watcher.addListener(res.get("DirC").path(), (ResourceListener)chkDirC);
        this.watcher.addListener(res.get("DirC/FileC1").path(), (ResourceListener)chkFileC1);
        this.watcher.addListener(res.get("DirC/FileC2").path(), (ResourceListener)chkFileC2);
        List events = SimpleResourceNotificationDispatcher.createEvents((Resource)res, (ResourceNotification.Kind)ResourceNotification.Kind.ENTRY_DELETE);
        this.watcher.changed(new ResourceNotification("DirA", ResourceNotification.Kind.ENTRY_DELETE, System.currentTimeMillis(), events));
        Assert.assertTrue((boolean)chkDirA.isChecked());
        Assert.assertTrue((boolean)chkFileA1.isChecked());
        Assert.assertTrue((boolean)chkFileA2.isChecked());
        Assert.assertTrue((boolean)chkDirC.isChecked());
        Assert.assertTrue((boolean)chkFileC1.isChecked());
        Assert.assertTrue((boolean)chkFileC2.isChecked());
        Assert.assertTrue((boolean)this.watcher.removeListener(res.path(), (ResourceListener)chkDirA));
        Assert.assertTrue((boolean)this.watcher.removeListener(res.get("FileA1").path(), (ResourceListener)chkFileA1));
        Assert.assertTrue((boolean)this.watcher.removeListener(res.get("FileA2").path(), (ResourceListener)chkFileA2));
        Assert.assertTrue((boolean)this.watcher.removeListener(res.get("DirC").path(), (ResourceListener)chkDirC));
        Assert.assertTrue((boolean)this.watcher.removeListener(res.get("DirC/FileC1").path(), (ResourceListener)chkFileC1));
        Assert.assertTrue((boolean)this.watcher.removeListener(res.get("DirC/FileC2").path(), (ResourceListener)chkFileC2));
    }

    @Test
    public void testDeleteWhileListening() {
        Resource res = this.store.get("DirA");
        ResourceListener deletingListener = new ResourceListener(){

            public void changed(ResourceNotification notify) {
                Assert.assertTrue((boolean)AbstractResourceNotificationDispatcherTest.this.watcher.removeListener(notify.getPath(), (ResourceListener)this));
            }
        };
        this.watcher.addListener(res.path(), deletingListener);
        this.watcher.changed(new ResourceNotification("DirA", ResourceNotification.Kind.ENTRY_DELETE, System.currentTimeMillis(), Collections.emptyList()));
        Assert.assertFalse((boolean)this.watcher.removeListener(res.path(), deletingListener));
    }

    @Test
    public void testModifyNotification() {
        Resource res = this.store.get("DirA/DirC/FileC1");
        CheckingResourceListener chkDirA = new CheckingResourceListener(ResourceNotification.Kind.ENTRY_MODIFY);
        CheckingResourceListener chkDirC = new CheckingResourceListener(ResourceNotification.Kind.ENTRY_MODIFY);
        CheckingResourceListener chkFileC1 = new CheckingResourceListener(ResourceNotification.Kind.ENTRY_MODIFY);
        this.watcher.addListener(res.path(), (ResourceListener)chkFileC1);
        this.watcher.addListener(this.store.get("DirA/DirC").path(), (ResourceListener)chkDirC);
        this.watcher.addListener(this.store.get("DirA").path(), (ResourceListener)chkDirA);
        List events = SimpleResourceNotificationDispatcher.createEvents((Resource)res, (ResourceNotification.Kind)ResourceNotification.Kind.ENTRY_MODIFY);
        this.watcher.changed(new ResourceNotification("DirA/DirC/FileC1", ResourceNotification.Kind.ENTRY_MODIFY, System.currentTimeMillis(), events));
        Assert.assertFalse((boolean)chkDirA.isChecked());
        Assert.assertTrue((boolean)chkDirC.isChecked());
        Assert.assertTrue((boolean)chkFileC1.isChecked());
        Assert.assertTrue((boolean)this.watcher.removeListener(res.path(), (ResourceListener)chkFileC1));
        Assert.assertTrue((boolean)this.watcher.removeListener(this.store.get("DirA/DirC").path(), (ResourceListener)chkDirC));
        Assert.assertTrue((boolean)this.watcher.removeListener(this.store.get("DirA").path(), (ResourceListener)chkDirA));
    }

    @Test
    public void testCreateNotification() {
        Resource res = this.store.get("DirA/DirC/DirD/FileQ");
        CheckingResourceListener chkDirA = new CheckingResourceListener(ResourceNotification.Kind.ENTRY_MODIFY);
        CheckingResourceListener chkDirC = new CheckingResourceListener(ResourceNotification.Kind.ENTRY_MODIFY);
        CheckingResourceListener chkDirD = new CheckingResourceListener(ResourceNotification.Kind.ENTRY_CREATE);
        CheckingResourceListener chkFileQ = new CheckingResourceListener(ResourceNotification.Kind.ENTRY_CREATE);
        this.watcher.addListener(res.path(), (ResourceListener)chkFileQ);
        this.watcher.addListener(this.store.get("DirA/DirC/DirD").path(), (ResourceListener)chkDirD);
        this.watcher.addListener(this.store.get("DirA/DirC").path(), (ResourceListener)chkDirC);
        this.watcher.addListener(this.store.get("DirA").path(), (ResourceListener)chkDirA);
        List events = SimpleResourceNotificationDispatcher.createEvents((Resource)res, (ResourceNotification.Kind)ResourceNotification.Kind.ENTRY_CREATE);
        this.watcher.changed(new ResourceNotification("DirA/DirC/DirD/FileQ", ResourceNotification.Kind.ENTRY_CREATE, System.currentTimeMillis(), events));
        Assert.assertFalse((boolean)chkDirA.isChecked());
        Assert.assertTrue((boolean)chkDirC.isChecked());
        Assert.assertTrue((boolean)chkDirD.isChecked());
        Assert.assertTrue((boolean)chkFileQ.isChecked());
        Assert.assertTrue((boolean)this.watcher.removeListener(res.path(), (ResourceListener)chkFileQ));
        Assert.assertTrue((boolean)this.watcher.removeListener(this.store.get("DirA/DirC/DirD").path(), (ResourceListener)chkDirD));
        Assert.assertTrue((boolean)this.watcher.removeListener(this.store.get("DirA/DirC").path(), (ResourceListener)chkDirC));
        Assert.assertTrue((boolean)this.watcher.removeListener(this.store.get("DirA").path(), (ResourceListener)chkDirA));
    }

    protected static class CheckingResourceListener
    implements ResourceListener {
        private boolean checked = false;
        private ResourceNotification.Kind kind;

        public CheckingResourceListener(ResourceNotification.Kind kind) {
            this.kind = kind;
        }

        public void changed(ResourceNotification notify) {
            if (this.kind == notify.getKind()) {
                this.checked = true;
            }
        }

        public boolean isChecked() {
            return this.checked;
        }
    }
}

