/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.FileWatcher;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.PlaceholderConfigurerSupport;
import org.springframework.core.Constants;
import org.springframework.util.PropertyPlaceholderHelper;

public class GeoServerEnvironment {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.platform");
    private static final Constants constants = new Constants(PlaceholderConfigurerSupport.class);
    private static volatile boolean allowEnvParametrization = Boolean.valueOf(System.getProperty("ALLOW_ENV_PARAMETRIZATION", "false"));
    private static final String PROPERTYFILENAME = "geoserver-environment.properties";
    static final String ENV_PROPERTIES_NAME = "ENV_PROPERTIES";
    private final String propertiesPath = GeoServerExtensions.getProperty("ENV_PROPERTIES");
    private static final String nullValue = "null";
    private final PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper(constants.asString("DEFAULT_PLACEHOLDER_PREFIX"), constants.asString("DEFAULT_PLACEHOLDER_SUFFIX"), constants.asString("DEFAULT_VALUE_SEPARATOR"), true);
    private final PropertyPlaceholderHelper.PlaceholderResolver resolver = name -> this.resolvePlaceholder(name);
    private FileWatcher<Properties> configFile;
    private Properties props;

    public static boolean allowEnvParametrization() {
        return allowEnvParametrization;
    }

    public static synchronized void reloadAllowEnvParametrization() {
        allowEnvParametrization = Boolean.valueOf(System.getProperty("ALLOW_ENV_PARAMETRIZATION", "false"));
    }

    public Properties getProps() {
        return this.props;
    }

    public GeoServerEnvironment() {
        try {
            this.configFile = this.getEnvironmentProperties(this.propertiesPath);
            this.props = this.configFile.read();
        }
        catch (Exception e) {
            String file = this.propertiesPath != null ? this.propertiesPath : PROPERTYFILENAME;
            LOGGER.log(Level.WARNING, "Could not find any '" + file + "' property file.", e);
            this.props = new Properties();
        }
    }

    private FileWatcher<Properties> getEnvironmentProperties(String propertiesFilePath) {
        if (propertiesFilePath != null && !"".equals(propertiesFilePath)) {
            File propertyFile = new File(propertiesFilePath);
            if (propertyFile.exists()) {
                return this.loadGeoServerEnvProps(propertyFile);
            }
            String message = "File " + this.propertiesPath + " not found. Trying to load the environment properties from GeoServer datadir.";
            LOGGER.warning(message);
        }
        return this.loadGeoServerEnvProps(PROPERTYFILENAME);
    }

    private FileWatcher<Properties> loadGeoServerEnvProps(File propertyFile) {
        return this.loadGeoServerEnvProps(Files.asResource(propertyFile));
    }

    private FileWatcher<Properties> loadGeoServerEnvProps(String propertyFile) {
        GeoServerResourceLoader loader = GeoServerExtensions.bean(GeoServerResourceLoader.class);
        Resource resource = loader.get(propertyFile);
        return this.loadGeoServerEnvProps(resource);
    }

    private FileWatcher<Properties> loadGeoServerEnvProps(Resource propertyFile) {
        return new FileWatcher<Properties>(propertyFile){

            @Override
            protected Properties parseFileContents(InputStream in) throws IOException {
                Properties p = new Properties();
                p.load(in);
                return p;
            }
        };
    }

    protected String resolvePlaceholder(String placeholder) {
        String propVal = this.resolveSystemProperty(placeholder);
        if (this.configFile != null && this.configFile.isModified()) {
            try {
                this.props = this.configFile.read();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not find any 'geoserver-environment.properties' property file.", e);
                this.props = new Properties();
            }
        }
        if (this.props != null && propVal == null) {
            propVal = this.props.getProperty(placeholder);
        }
        return propVal;
    }

    protected String resolveSystemProperty(String key) {
        try {
            String value = System.getProperty(key);
            if (value == null) {
                value = System.getenv(key);
            }
            return value;
        }
        catch (Throwable ex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Could not access system property '" + key + "': " + ex);
            }
            return null;
        }
    }

    protected String resolveStringValue(String strVal) throws BeansException {
        String resolved = this.helper.replacePlaceholders(strVal, this.resolver);
        return resolved.equals(nullValue) ? null : resolved;
    }

    public Object resolveValue(Object value) {
        if (value != null && value instanceof String) {
            return this.resolveStringValue((String)value);
        }
        return value;
    }

    public boolean isStale() {
        return this.configFile != null && this.configFile.isModified();
    }
}

