/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.geoserver.util.LoggerRule;
import org.geotools.util.logging.LoggerAdapter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LoggerRuleTest {
    @Test
    public void testDoNothingUntilRun() {
        Logger log = (Logger)EasyMock.createMock((String)"log", Logger.class);
        Description desc = (Description)EasyMock.createMock((String)"desc", Description.class);
        Statement base = (Statement)EasyMock.createMock((String)"base", Statement.class);
        EasyMock.replay((Object[])new Object[]{log, desc, base});
        LoggerRule rule = new LoggerRule(log, Level.FINE);
        rule.apply(base, desc);
        EasyMock.verify((Object[])new Object[]{log, desc, base});
    }

    @Test
    public void testCleansUp() throws Throwable {
        Logger log = (Logger)EasyMock.createMock((String)"log", Logger.class);
        Description desc = (Description)EasyMock.createMock((String)"desc", Description.class);
        Statement base = (Statement)EasyMock.createMock((String)"base", Statement.class);
        EasyMock.expect((Object)log.getLevel()).andReturn((Object)Level.OFF);
        log.setLevel(Level.FINE);
        EasyMock.expectLastCall().once();
        Capture handlerCap = Capture.newInstance((CaptureType)CaptureType.LAST);
        log.addHandler((Handler)EasyMock.capture((Capture)handlerCap));
        EasyMock.expectLastCall().once();
        base.evaluate();
        EasyMock.expectLastCall().andAnswer(() -> {
            EasyMock.verify((Object[])new Object[]{log});
            EasyMock.reset((Object[])new Object[]{log});
            log.removeHandler((Handler)handlerCap.getValue());
            EasyMock.expectLastCall().once();
            log.setLevel(Level.OFF);
            EasyMock.expectLastCall().once();
            EasyMock.replay((Object[])new Object[]{log});
            return null;
        });
        EasyMock.replay((Object[])new Object[]{log, desc, base});
        LoggerRule rule = new LoggerRule(log, Level.FINE);
        Statement s = rule.apply(base, desc);
        s.evaluate();
        EasyMock.verify((Object[])new Object[]{log, desc, base});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleansUpAfterException() throws Throwable {
        Logger log = (Logger)EasyMock.createMock((String)"log", Logger.class);
        Description desc = (Description)EasyMock.createMock((String)"desc", Description.class);
        Statement base = (Statement)EasyMock.createMock((String)"base", Statement.class);
        EasyMock.expect((Object)log.getLevel()).andReturn((Object)Level.OFF);
        log.setLevel(Level.FINE);
        EasyMock.expectLastCall().once();
        Capture handlerCap = Capture.newInstance((CaptureType)CaptureType.LAST);
        IllegalArgumentException ex = new IllegalArgumentException();
        log.addHandler((Handler)EasyMock.capture((Capture)handlerCap));
        EasyMock.expectLastCall().once();
        base.evaluate();
        EasyMock.expectLastCall().andAnswer(() -> {
            EasyMock.verify((Object[])new Object[]{log});
            EasyMock.reset((Object[])new Object[]{log});
            log.removeHandler((Handler)handlerCap.getValue());
            EasyMock.expectLastCall().once();
            log.setLevel(Level.OFF);
            EasyMock.expectLastCall().once();
            EasyMock.replay((Object[])new Object[]{log});
            throw ex;
        });
        EasyMock.replay((Object[])new Object[]{log, desc, base});
        LoggerRule rule = new LoggerRule(log, Level.FINE);
        Statement s = rule.apply(base, desc);
        try {
            Assert.assertThrows(IllegalArgumentException.class, () -> s.evaluate());
        }
        catch (Throwable throwable) {
            EasyMock.verify((Object[])new Object[]{log, desc, base});
            throw throwable;
        }
        EasyMock.verify((Object[])new Object[]{log, desc, base});
    }

    @Test
    public void testRecordsLogs() throws Throwable {
        Logger log = (Logger)EasyMock.createMock((String)"log", Logger.class);
        Description desc = (Description)EasyMock.createMock((String)"desc", Description.class);
        Statement base = (Statement)EasyMock.createMock((String)"base", Statement.class);
        EasyMock.expect((Object)log.getLevel()).andReturn((Object)Level.OFF);
        log.setLevel(Level.FINE);
        EasyMock.expectLastCall().once();
        Capture handlerCap = Capture.newInstance((CaptureType)CaptureType.LAST);
        LogRecord record = (LogRecord)EasyMock.createMock((String)"record1", LogRecord.class);
        log.addHandler((Handler)EasyMock.capture((Capture)handlerCap));
        EasyMock.expectLastCall().once();
        base.evaluate();
        EasyMock.expectLastCall().andAnswer(() -> {
            EasyMock.verify((Object[])new Object[]{log});
            EasyMock.reset((Object[])new Object[]{log});
            log.removeHandler((Handler)handlerCap.getValue());
            EasyMock.expectLastCall().once();
            log.setLevel(Level.OFF);
            EasyMock.expectLastCall().once();
            ((Handler)handlerCap.getValue()).publish(record);
            MatcherAssert.assertThat(((LoggerRule)handlerCap.getValue()).records(), (Matcher)Matchers.contains((Object[])new LogRecord[]{record}));
            EasyMock.replay((Object[])new Object[]{log});
            return null;
        });
        EasyMock.replay((Object[])new Object[]{log, desc, base});
        LoggerRule rule = new LoggerRule(log, Level.FINE);
        Statement s = rule.apply(base, desc);
        s.evaluate();
        EasyMock.verify((Object[])new Object[]{log, desc, base});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssertFail() throws Throwable {
        Logger log = (Logger)EasyMock.createMock((String)"log", Logger.class);
        Description desc = (Description)EasyMock.createMock((String)"desc", Description.class);
        Statement base = (Statement)EasyMock.createMock((String)"base", Statement.class);
        EasyMock.expect((Object)log.getLevel()).andReturn((Object)Level.OFF);
        log.setLevel(Level.FINE);
        EasyMock.expectLastCall().once();
        Capture handlerCap = Capture.newInstance((CaptureType)CaptureType.LAST);
        LogRecord record = (LogRecord)EasyMock.createMock((String)"record1", LogRecord.class);
        log.addHandler((Handler)EasyMock.capture((Capture)handlerCap));
        EasyMock.expectLastCall().once();
        base.evaluate();
        EasyMock.expectLastCall().andAnswer(() -> {
            EasyMock.verify((Object[])new Object[]{log});
            EasyMock.reset((Object[])new Object[]{log});
            log.removeHandler((Handler)handlerCap.getValue());
            EasyMock.expectLastCall().once();
            log.setLevel(Level.OFF);
            EasyMock.expectLastCall().once();
            EasyMock.replay((Object[])new Object[]{log});
            ((Handler)handlerCap.getValue()).publish(record);
            ((LoggerRule)handlerCap.getValue()).assertLogged((Matcher<? super LogRecord>)Matchers.sameInstance((Object)record));
            ((LoggerRule)handlerCap.getValue()).assertLogged((Matcher<? super LogRecord>)Matchers.not((Matcher)Matchers.anything()));
            return null;
        });
        EasyMock.replay((Object[])new Object[]{log, desc, base});
        LoggerRule rule = new LoggerRule(log, Level.FINE);
        Statement s = rule.apply(base, desc);
        try {
            s.evaluate();
            Assert.fail((String)"Expected Assertion Exception");
        }
        catch (AssertionError ex) {
            try {
                MatcherAssert.assertThat((Object)ex, (Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.containsString((String)"Expected record")));
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{log, desc, base});
                throw throwable;
            }
            EasyMock.verify((Object[])new Object[]{log, desc, base});
        }
        EasyMock.verify((Object[])new Object[]{log, desc, base});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssertPass() throws Throwable {
        Logger log = (Logger)EasyMock.createMock((String)"log", Logger.class);
        Description desc = (Description)EasyMock.createMock((String)"desc", Description.class);
        Statement base = (Statement)EasyMock.createMock((String)"base", Statement.class);
        EasyMock.expect((Object)log.getLevel()).andReturn((Object)Level.OFF);
        log.setLevel(Level.FINE);
        EasyMock.expectLastCall().once();
        Capture handlerCap = Capture.newInstance((CaptureType)CaptureType.LAST);
        LogRecord record = (LogRecord)EasyMock.createMock((String)"record1", LogRecord.class);
        log.addHandler((Handler)EasyMock.capture((Capture)handlerCap));
        EasyMock.expectLastCall().once();
        base.evaluate();
        EasyMock.expectLastCall().andAnswer(() -> {
            EasyMock.verify((Object[])new Object[]{log});
            EasyMock.reset((Object[])new Object[]{log});
            log.removeHandler((Handler)handlerCap.getValue());
            EasyMock.expectLastCall().once();
            log.setLevel(Level.OFF);
            EasyMock.expectLastCall().once();
            EasyMock.replay((Object[])new Object[]{log});
            ((Handler)handlerCap.getValue()).publish(record);
            ((LoggerRule)handlerCap.getValue()).assertLogged((Matcher<? super LogRecord>)Matchers.sameInstance((Object)record));
            return null;
        });
        EasyMock.replay((Object[])new Object[]{log, desc, base});
        LoggerRule rule = new LoggerRule(log, Level.FINE);
        Statement s = rule.apply(base, desc);
        try {
            s.evaluate();
        }
        catch (Throwable throwable) {
            EasyMock.verify((Object[])new Object[]{log, desc, base});
            throw throwable;
        }
        EasyMock.verify((Object[])new Object[]{log, desc, base});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdapter() throws Throwable {
        Logger log = (Logger)EasyMock.createMock((String)"log", LoggerAdapter.class);
        Description desc = (Description)EasyMock.createMock((String)"desc", Description.class);
        Statement base = (Statement)EasyMock.createMock((String)"base", Statement.class);
        EasyMock.expect((Object)log.getLevel()).andReturn((Object)Level.OFF);
        log.setLevel(Level.FINE);
        EasyMock.expectLastCall().once();
        Capture handlerCap = Capture.newInstance((CaptureType)CaptureType.LAST);
        LogRecord record = (LogRecord)EasyMock.createMock((String)"record1", LogRecord.class);
        log.addHandler((Handler)EasyMock.capture((Capture)handlerCap));
        EasyMock.expectLastCall().once();
        base.evaluate();
        EasyMock.expectLastCall().andAnswer(() -> {
            EasyMock.verify((Object[])new Object[]{log});
            EasyMock.reset((Object[])new Object[]{log});
            log.removeHandler((Handler)handlerCap.getValue());
            EasyMock.expectLastCall().once();
            log.setLevel(Level.OFF);
            EasyMock.expectLastCall().once();
            EasyMock.replay((Object[])new Object[]{log});
            ((Handler)handlerCap.getValue()).publish(record);
            ((LoggerRule)handlerCap.getValue()).assertLogged((Matcher<? super LogRecord>)Matchers.sameInstance((Object)record));
            return null;
        });
        EasyMock.replay((Object[])new Object[]{log, desc, base});
        LoggerRule rule = new LoggerRule(log, Level.FINE);
        Statement s = rule.apply(base, desc);
        try {
            s.evaluate();
        }
        catch (AssumptionViolatedException ex) {
            block4: {
                try {
                    if (ex.getMessage().equals("LoggerRule can't capture logs for LoggerAdapter")) break block4;
                    throw ex;
                }
                catch (Throwable throwable) {
                    EasyMock.verify((Object[])new Object[]{log, desc, base});
                    throw throwable;
                }
            }
            EasyMock.verify((Object[])new Object[]{log, desc, base});
        }
        EasyMock.verify((Object[])new Object[]{log, desc, base});
    }
}

