/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.util.Properties;
import org.junit.rules.ExternalResource;

public class PropertyRule
extends ExternalResource {
    final Properties props;
    final String name;
    String oldValue;

    public static PropertyRule system(String name) {
        return new PropertyRule(System.getProperties(), name);
    }

    public PropertyRule(Properties props, String name) {
        this.props = props;
        this.name = name;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setValue(String value) {
        this.props.setProperty(this.name, value);
    }

    public void clearValue() {
        this.props.remove(this.name);
    }

    public String getName() {
        return this.name;
    }

    protected void before() throws Throwable {
        this.oldValue = this.props.getProperty(this.name);
    }

    protected void after() {
        if (this.oldValue == null) {
            this.props.remove(this.name);
        } else {
            this.props.setProperty(this.name, this.oldValue);
        }
    }
}

