/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ExceptionThrowingController {
    @GetMapping
    @RequestMapping(path={"/rest/exception"})
    public void handleException(@RequestParam(name="message", required=false) String message, @RequestParam(name="code", required=false) Integer code) {
        throw new RestException(message != null ? message : "Unknown error", code != null ? HttpStatus.valueOf((int)code) : HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @GetMapping
    @RequestMapping(path={"/rest/error"})
    public void handleError() {
        throw new RuntimeException("An internal error occurred");
    }

    @GetMapping
    @RequestMapping(path={"/rest/notfound"})
    public void handleNotFound() {
        throw new ResourceNotFoundException("I'm not there");
    }

    @GetMapping
    @RequestMapping(path={"/rest/npe"})
    public void handleNPE() {
        throw new NullPointerException();
    }
}

