/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.geotools.util.logging.Log4J2Logger;
import org.geotools.util.logging.LoggerAdapter;

class LoggingCapturer {
    private Logger logger;
    private List<String> messages = List.of();
    private CapturingAdaptor capturer;

    public LoggingCapturer(Logger logger) {
        this.logger = logger;
    }

    public LoggingCapturer start() {
        this.stop();
        this.capturer = this.createCapturer();
        this.messages = new CopyOnWriteArrayList<String>();
        this.capturer.startCapturing();
        return this;
    }

    public List<String> stop() {
        if (null != this.capturer) {
            this.capturer.stopCapturing();
        }
        this.capturer = null;
        return this.getMessages();
    }

    public List<String> getMessages() {
        return List.copyOf(this.messages);
    }

    private CapturingAdaptor createCapturer() {
        if (this.logger instanceof LoggerAdapter) {
            if (this.logger instanceof Log4J2Logger) {
                return new Log4j2Capturer();
            }
            throw new UnsupportedOperationException("There's capturing adapter for " + this.logger.getClass().getCanonicalName());
        }
        return new JULCapturer();
    }

    private class Log4j2Capturer
    extends AbstractAppender
    implements CapturingAdaptor {
        org.apache.logging.log4j.core.Logger coreLogger;

        public Log4j2Capturer() {
            super("TestCapturingAppender", null, null, true, Property.EMPTY_ARRAY);
        }

        @Override
        public void startCapturing() {
            String name = LoggingCapturer.this.logger.getName();
            org.apache.logging.log4j.Logger log4jLogger = LogManager.getLogger((String)name);
            this.coreLogger = (org.apache.logging.log4j.core.Logger)log4jLogger;
            this.coreLogger.addAppender((Appender)this);
            super.start();
        }

        @Override
        public void stopCapturing() {
            if (null != this.coreLogger) {
                this.coreLogger.removeAppender((Appender)this);
                this.coreLogger = null;
            }
        }

        public void append(LogEvent event) {
            LoggingCapturer.this.messages.add(event.getMessage().getFormattedMessage());
        }
    }

    private class JULCapturer
    extends Handler
    implements CapturingAdaptor {
        private JULCapturer() {
        }

        @Override
        public void startCapturing() {
            LoggingCapturer.this.logger.addHandler(this);
        }

        @Override
        public void stopCapturing() {
            LoggingCapturer.this.logger.removeHandler(this);
        }

        @Override
        public void publish(LogRecord record) {
            LoggingCapturer.this.messages.add(record.getMessage());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private static interface CapturingAdaptor {
        public void startCapturing();

        public void stopCapturing();
    }
}

