/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.converters;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.io.IOException;
import java.util.Collection;
import org.codehaus.jettison.mapped.Configuration;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.config.util.SecureXStream;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.rest.RequestInfo;
import org.geoserver.rest.converters.XStreamJSONMessageConverter;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestListWrapper;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public abstract class XStreamCatalogListConverter
extends XStreamMessageConverter<RestListWrapper<?>> {
    public XStreamCatalogListConverter(MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
    }

    protected boolean supports(Class<?> clazz) {
        return RestListWrapper.class.isAssignableFrom(clazz);
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    @Override
    public RestListWrapper<?> readInternal(Class<? extends RestListWrapper<?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new HttpMessageNotReadableException(((Object)((Object)this)).getClass().getName() + " does not support deserialization of catalog lists", inputMessage);
    }

    @Override
    public void writeInternal(RestListWrapper<?> wrapper, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        XStream xstream = this.createXStreamInstance();
        Class targetClass = wrapper.getObjectClass();
        Collection<?> data = wrapper.getCollection();
        this.aliasCollection(data, xstream, targetClass, wrapper);
        this.configureXStream(xstream, targetClass, wrapper);
        xstream.toXML(data, outputMessage.getBody());
    }

    protected void configureXStream(XStream xstream, final Class<?> clazz, final RestListWrapper<?> wrapper) {
        XStreamPersister xp = this.xpf.createXMLPersister();
        wrapper.configurePersister(xp, this);
        final String name = this.getItemName(xp, clazz);
        xstream.alias(name, clazz);
        xstream.registerConverter((Converter)new CollectionConverter(xstream.getMapper()){

            public boolean canConvert(Class type) {
                return Collection.class.isAssignableFrom(type);
            }

            protected void writeCompleteItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
                writer.startNode(name);
                context.convertAnother(item);
                writer.endNode();
            }
        });
        xstream.registerConverter(new Converter(){

            public boolean canConvert(Class type) {
                return clazz.isAssignableFrom(type);
            }

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                String ref;
                if (clazz.equals(LayerInfo.class) && OwsUtils.getter((Class)clazz, (String)"prefixedName", String.class) != null && RequestInfo.get() != null && !RequestInfo.get().getPagePath().contains("/workspaces/")) {
                    ref = (String)OwsUtils.get((Object)source, (String)"prefixedName");
                } else if (OwsUtils.getter((Class)clazz, (String)"name", String.class) != null) {
                    ref = (String)OwsUtils.get((Object)source, (String)"name");
                } else if (OwsUtils.getter((Class)clazz, (String)"id", String.class) != null) {
                    ref = (String)OwsUtils.get((Object)source, (String)"id");
                } else if (OwsUtils.getter((Class)clazz, (String)"id", Long.class) != null) {
                    ref = OwsUtils.get((Object)source, (String)"id").toString();
                } else {
                    throw new RuntimeException("Could not determine identifier for: " + clazz.getName());
                }
                writer.startNode(wrapper.getItemAttributeName());
                writer.setValue(ref);
                writer.endNode();
                XStreamCatalogListConverter.this.encodeLink(XStreamCatalogListConverter.this.encode(ref), writer);
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                return null;
            }
        });
    }

    protected void aliasCollection(Object data, XStream xstream, Class<?> clazz, RestListWrapper<?> wrapper) {
        XStreamPersister xp = this.xpf.createXMLPersister();
        wrapper.configurePersister(xp, this);
        String alias = this.getItemName(xp, clazz);
        xstream.alias(alias + "s", Collection.class, data.getClass());
    }

    protected String getItemName(XStreamPersister xp, Class<?> clazz) {
        return xp.getClassAliasingMapper().serializedClass(clazz);
    }

    public static class JSONXStreamListConverter
    extends XStreamCatalogListConverter {
        public JSONXStreamListConverter() {
            super(MediaType.APPLICATION_JSON, XStreamJSONMessageConverter.TEXT_JSON);
        }

        @Override
        public void encodeLink(String link, HierarchicalStreamWriter writer) {
            writer.startNode("href");
            writer.setValue(this.href(link));
            writer.endNode();
        }

        @Override
        public void encodeCollectionLink(String link, HierarchicalStreamWriter writer) {
            writer.setValue(this.href(link));
        }

        @Override
        public void writeInternal(RestListWrapper<?> wrapper, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
            if (wrapper.getCollection().size() == 1) {
                this.writeSingleElementCollection(wrapper, outputMessage);
            } else {
                super.writeInternal(wrapper, outputMessage);
            }
        }

        @Override
        protected XStream createXStreamInstance() {
            boolean useSerializeAsArray = false;
            return this.createXStreamInstance(useSerializeAsArray);
        }

        @Override
        public String getExtension() {
            return "json";
        }

        @Override
        public String getMediaType() {
            return "application/json";
        }

        private XStream createXStreamInstance(boolean useSerializeAsArray) {
            Configuration configuration = new Configuration();
            configuration.setRootElementArrayWrapper(false);
            return new SecureXStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver(configuration, useSerializeAsArray));
        }

        private void writeSingleElementCollection(RestListWrapper<?> wrapper, HttpOutputMessage outputMessage) throws IOException {
            boolean useSerializeAsArray = true;
            XStream xstream = this.createXStreamInstance(true);
            XStreamPersister xp = this.xpf.createXMLPersister();
            wrapper.configurePersister(xp, this);
            Class targetClass = wrapper.getObjectClass();
            String itemName = this.getItemName(xp, targetClass);
            String collectionAlias = itemName + "s";
            this.configureSingleElementCollectionXStream(xstream, targetClass, wrapper);
            ListRoot data = new ListRoot(wrapper.getCollection());
            xstream.alias(collectionAlias, ListRoot.class);
            xstream.aliasField(itemName, ListRoot.class, "values");
            xstream.alias(itemName, targetClass);
            xstream.aliasSystemAttribute(null, "class");
            xstream.toXML((Object)data, outputMessage.getBody());
        }

        protected void configureSingleElementCollectionXStream(XStream xstream, Class<?> clazz, RestListWrapper<?> wrapper) {
            super.configureXStream(xstream, clazz, wrapper);
            xstream.registerConverter((Converter)new CollectionConverter(xstream.getMapper()){

                public boolean canConvert(Class type) {
                    return Collection.class.isAssignableFrom(type);
                }

                protected void writeCompleteItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
                    super.writeBareItem(item, context, writer);
                }
            });
        }

        static class ListRoot {
            private Collection<?> values;

            ListRoot(Collection<?> values) {
                this.values = values;
            }

            public Collection<?> getValues() {
                return this.values;
            }
        }
    }

    public static class XMLXStreamListConverter
    extends XStreamCatalogListConverter {
        public XMLXStreamListConverter() {
            super(MediaType.APPLICATION_XML, MediaType.TEXT_XML);
        }

        @Override
        protected XStream createXStreamInstance() {
            return new SecureXStream();
        }

        @Override
        public void encodeLink(String link, HierarchicalStreamWriter writer) {
            this.encodeAlternateAtomLink(link, writer);
        }

        @Override
        public void encodeCollectionLink(String link, HierarchicalStreamWriter writer) {
            this.encodeAlternateAtomLink(link, writer);
        }

        @Override
        public String getMediaType() {
            return "application/atom+xml";
        }

        @Override
        public String getExtension() {
            return "xml";
        }
    }
}

