/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.File;
import java.net.URL;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geotools.util.URLs;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class CoverageControllerWCSTest
extends CatalogRESTTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpDefaultRasterLayers();
    }

    @Before
    public void addBlueMarbleCoverage() throws Exception {
        ((SystemTestData)this.getTestData()).addDefaultRasterLayer(SystemTestData.TASMANIA_BM, this.getCatalog());
    }

    void addCoverageStore(boolean autoConfigureCoverage) throws Exception {
        URL zip = ((Object)((Object)this)).getClass().getResource("test-data/usa.zip");
        byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)zip));
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/usaWorldImage/file.worldimage" + (!autoConfigureCoverage ? "?configure=none" : ""), bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
    }

    @Test
    public void testGetAllByCoverageStore() throws Exception {
        this.removeStore("gs", "usaWorldImage");
        String req = "wcs?service=wcs&request=getcoverage&version=1.1.1&identifier=gs:usa&boundingbox=-100,30,-80,44,EPSG:4326&format=image/tiff&gridbasecrs=EPSG:4326&store=true";
        Document dom = this.getAsDOM(req);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        this.addCoverageStore(true);
        dom = this.getAsDOM("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages.xml");
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("coverage").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//coverage/name[text()='usa'])", (Document)dom);
    }

    @Test
    public void testPostAsXML() throws Exception {
        this.removeStore("gs", "usaWorldImage");
        String req = "wcs?service=wcs&request=getcoverage&version=1.1.1&identifier=gs:usa&boundingbox=-100,30,-80,44,EPSG:4326&format=image/tiff&gridbasecrs=EPSG:4326&store=true";
        Document dom = this.getAsDOM(req);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        this.addCoverageStore(false);
        dom = this.getAsDOM("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages.xml");
        Assert.assertEquals((long)0L, (long)dom.getElementsByTagName("coverage").getLength());
        String xml = "<coverage><name>usa</name><title>usa is a A raster file accompanied by a spatial data file</title><description>Generated from WorldImage</description><srs>EPSG:4326</srs><supportedFormats><string>PNG</string><string>GEOTIFF</string></supportedFormats><requestSRS><string>EPSG:4326</string></requestSRS><responseSRS><string>EPSG:4326</string></responseSRS><store>usaWorldImage</store><namespace>gs</namespace></coverage>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/gs/coveragestores/usaWorldImage/coverages/usa"));
        dom = this.getAsDOM(req);
        Assert.assertEquals((Object)"wcs:Coverages", (Object)dom.getDocumentElement().getNodeName());
        dom = this.getAsDOM("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages/usa.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"-130.85168", (String)"/coverage/latLonBoundingBox/minx", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"983 598", (String)"/coverage/grid/range/high", (Document)dom);
        dom = this.getAsDOM("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages.xml");
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("coverage").getLength());
    }

    @Test
    public void testPostAsJSON() throws Exception {
        this.removeStore("gs", "usaWorldImage");
        String request = "wcs?service=wcs&request=getcoverage&version=1.1.1&identifier=gs:usa&boundingbox=-100,30,-80,44,EPSG:4326&format=image/tiff&gridbasecrs=EPSG:4326&store=true";
        Document document = this.getAsDOM(request);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)document.getDocumentElement().getNodeName());
        this.addCoverageStore(false);
        JSONObject json = (JSONObject)this.getAsJSON("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages.json");
        MatcherAssert.assertThat((Object)json.getString("coverages").isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        String content = "{    \"coverage\": {        \"description\": \"Generated from WorldImage\",        \"name\": \"usa\",        \"namespace\": \"gs\",        \"requestSRS\": {            \"string\": [                \"EPSG:4326\"            ]        },        \"responseSRS\": {            \"string\": [                \"EPSG:4326\"            ]        },        \"srs\": \"EPSG:4326\",        \"store\": \"usaWorldImage\",        \"supportedFormats\": {            \"string\": [                \"PNG\",                \"GEOTIFF\"            ]        },        \"title\": \"usa is a A raster file accompanied by a spatial data file\"    }}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages", content, "application/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/gs/coveragestores/usaWorldImage/coverages/usa"));
        document = this.getAsDOM(request);
        Assert.assertEquals((Object)"wcs:Coverages", (Object)document.getDocumentElement().getNodeName());
        json = (JSONObject)this.getAsJSON("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages/usa.json");
        MatcherAssert.assertThat((Object)json.getJSONObject("coverage").getString("name"), (Matcher)CoreMatchers.is((Object)"usa"));
        MatcherAssert.assertThat((Object)json.getJSONObject("coverage").getJSONObject("latLonBoundingBox").getString("minx"), (Matcher)CoreMatchers.is((Object)"-130.85168"));
        MatcherAssert.assertThat((Object)json.getJSONObject("coverage").getJSONObject("grid").getJSONObject("range").getString("high"), (Matcher)CoreMatchers.is((Object)"983 598"));
        json = (JSONObject)this.getAsJSON("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages.json");
        JSONArray coverages = json.getJSONObject("coverages").getJSONArray("coverage");
        MatcherAssert.assertThat((Object)coverages.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)coverages.getJSONObject(0).getString("name"), (Matcher)CoreMatchers.is((Object)"usa"));
    }

    @Test
    public void testPostAsXMLWithNativeName() throws Exception {
        this.removeStore("gs", "usaWorldImage");
        String req = "wcs?service=wcs&request=getcoverage&version=1.1.1&identifier=gs:differentName&boundingbox=-100,30,-80,44,EPSG:4326&format=image/tiff&gridbasecrs=EPSG:4326&store=true";
        Document dom = this.getAsDOM(req);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        this.addCoverageStore(false);
        dom = this.getAsDOM("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages.xml");
        Assert.assertEquals((long)0L, (long)dom.getElementsByTagName("coverage").getLength());
        String xml = "<coverage><name>differentName</name><title>usa is a A raster file accompanied by a spatial data file</title><description>Generated from WorldImage</description><srs>EPSG:4326</srs><supportedFormats><string>PNG</string><string>GEOTIFF</string></supportedFormats><requestSRS><string>EPSG:4326</string></requestSRS><responseSRS><string>EPSG:4326</string></responseSRS><store>usaWorldImage</store><namespace>gs</namespace><nativeCoverageName>usa</nativeCoverageName></coverage>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/gs/coveragestores/usaWorldImage/coverages/differentName"));
        dom = this.getAsDOM(req);
        Assert.assertEquals((Object)"wcs:Coverages", (Object)dom.getDocumentElement().getNodeName());
        dom = this.getAsDOM("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages/differentName.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"-130.85168", (String)"/coverage/latLonBoundingBox/minx", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"983 598", (String)"/coverage/grid/range/high", (Document)dom);
    }

    @Test
    public void testPostNewAsXMLWithNativeCoverageName() throws Exception {
        this.removeStore("gs", "usaWorldImage");
        String req = "wcs?service=wcs&request=getcoverage&version=1.1.1&identifier=gs:differentName&boundingbox=-100,30,-80,44,EPSG:4326&format=image/tiff&gridbasecrs=EPSG:4326&store=true";
        Document dom = this.getAsDOM(req);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        this.addCoverageStore(false);
        dom = this.getAsDOM("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages.xml");
        Assert.assertEquals((long)0L, (long)dom.getElementsByTagName("coverage").getLength());
        String xml = "<coverage><name>differentName</name><nativeCoverageName>usa</nativeCoverageName></coverage>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/gs/coveragestores/usaWorldImage/coverages/differentName"));
        dom = this.getAsDOM(req);
        Assert.assertEquals((Object)"wcs:Coverages", (Object)dom.getDocumentElement().getNodeName());
        dom = this.getAsDOM("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages/differentName.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"differentName", (String)"/coverage/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"differentName", (String)"/coverage/title", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"usa", (String)"/coverage/nativeCoverageName", (Document)dom);
    }

    @Test
    public void testPostNewAsXMLWithNativeNameFallback() throws Exception {
        this.removeStore("gs", "usaWorldImage");
        String req = "wcs?service=wcs&request=getcoverage&version=1.1.1&identifier=gs:differentName&boundingbox=-100,30,-80,44,EPSG:4326&format=image/tiff&gridbasecrs=EPSG:4326&store=true";
        Document dom = this.getAsDOM(req);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        this.addCoverageStore(false);
        dom = this.getAsDOM("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages.xml");
        Assert.assertEquals((long)0L, (long)dom.getElementsByTagName("coverage").getLength());
        String xml = "<coverage><name>differentName</name><nativeName>usa</nativeName></coverage>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/gs/coveragestores/usaWorldImage/coverages/differentName"));
        dom = this.getAsDOM(req);
        Assert.assertEquals((Object)"wcs:Coverages", (Object)dom.getDocumentElement().getNodeName());
        dom = this.getAsDOM("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages/differentName.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"differentName", (String)"/coverage/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"differentName", (String)"/coverage/title", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"usa", (String)"/coverage/nativeCoverageName", (Document)dom);
    }
}

