/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.wcs.WCSInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class LocalWCSSettingsControllerTest
extends CatalogRESTTestSupport {
    @After
    public void revertChanges() {
        LocalWorkspace.remove();
        this.revertService(WCSInfo.class, "sf");
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GeoServer geoServer = this.getGeoServer();
        WorkspaceInfo ws = geoServer.getCatalog().getWorkspaceByName("sf");
        LocalWorkspace.set((WorkspaceInfo)ws);
        WCSInfo wcsInfo = (WCSInfo)geoServer.getService(WCSInfo.class);
        wcsInfo.setWorkspace(ws);
        geoServer.save((ServiceInfo)wcsInfo);
    }

    @After
    public void clearLocalWorkspace() throws Exception {
        LocalWorkspace.remove();
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/services/wcs/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wcsinfo = (JSONObject)jsonObject.get("wcs");
        Assert.assertEquals((Object)"WCS", (Object)wcsinfo.get("name"));
        JSONObject workspace = (JSONObject)wcsinfo.get("workspace");
        Assert.assertNotNull((Object)workspace);
        Assert.assertEquals((Object)"sf", (Object)workspace.get("name"));
        Assert.assertEquals((Object)"false", (Object)wcsinfo.get("verbose").toString().trim());
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/services/wcs/workspaces/sf/settings.xml");
        Assert.assertEquals((Object)"wcs", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wcs/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf", (String)"/wcs/workspace/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WCS", (String)"/wcs/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wcs/verbose", (Document)dom);
    }

    @Test
    public void testGetAsHTML() throws Exception {
        this.getAsDOM("/rest/services/wcs/workspaces/sf/settings.html");
    }

    @Test
    public void testCreateAsJSON() throws Exception {
        this.removeLocalWorkspace();
        String input = "{'wcs': {'id' : 'wcs', 'name' : 'WCS', 'workspace': {'name': 'sf'},'enabled': 'true'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wcs/workspaces/sf/settings", input, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON json = this.getAsJSON("/rest/services/wcs/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wmsinfo = (JSONObject)jsonObject.get("wcs");
        Assert.assertEquals((Object)"WCS", (Object)wmsinfo.get("name"));
        JSONObject workspace = (JSONObject)wmsinfo.get("workspace");
        Assert.assertNotNull((Object)workspace);
        Assert.assertEquals((Object)"sf", (Object)workspace.get("name"));
    }

    @Test
    public void testCreateAsXML() throws Exception {
        this.removeLocalWorkspace();
        String xml = "<wcs><id>wcs</id><workspace><name>sf</name></workspace><name>OGC:WCS</name><enabled>false</enabled></wcs>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wcs/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wcs/workspaces/sf/settings.xml");
        Assert.assertEquals((Object)"wcs", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wcs/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf", (String)"/wcs/workspace/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"OGC:WCS", (String)"/wcs/name", (Document)dom);
    }

    @Test
    public void testPutAsJSON() throws Exception {
        String json = "{'wcs': {'id':'wcs','workspace':{'name':'sf'},'enabled':'false','name':'WCS'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wcs/workspaces/sf/settings", json, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON jsonMod = this.getAsJSON("/rest/services/wcs/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)jsonMod;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wcsinfo = (JSONObject)jsonObject.get("wcs");
        Assert.assertEquals((Object)"false", (Object)wcsinfo.get("enabled").toString().trim());
    }

    @Test
    public void testPutAsXML() throws Exception {
        String xml = "<wcs><id>wcs</id><workspace><name>sf</name></workspace><enabled>false</enabled></wcs>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wcs/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wcs/workspaces/sf/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wcs/enabled", (Document)dom);
    }

    @Test
    public void testPutFullAsXML() throws Exception {
        String xml = IOUtils.toString((InputStream)LocalWCSSettingsControllerTest.class.getResourceAsStream("wcs.xml"), (Charset)StandardCharsets.UTF_8);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wcs/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wcs/workspaces/sf/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wcs/enabled", (Document)dom);
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/services/wcs/workspaces/sf/settings").getStatus());
        boolean thrown = false;
        try {
            this.getAsJSON("/rest/services/wcs/sf/settings.json");
        }
        catch (JSONException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }

    private void removeLocalWorkspace() {
        GeoServer geoServer = this.getGeoServer();
        WorkspaceInfo ws = geoServer.getCatalog().getWorkspaceByName("sf");
        WCSInfo wcsInfo = (WCSInfo)geoServer.getService(ws, WCSInfo.class);
        geoServer.remove((ServiceInfo)wcsInfo);
    }
}

