/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.Filter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geoserver.security.impl.AbstractUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class ResourceAccessManagerWMSTest
extends WMSTestSupport {
    static final Logger LOGGER = Logging.getLogger(ResourceAccessManagerWMSTest.class);

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath:/org/geoserver/wms/ResourceAccessManagerContext.xml");
    }

    protected List<Filter> getFilters() {
        return Collections.singletonList((Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GeoServerUserGroupStore ugStore = this.getSecurityManager().loadUserGroupService(AbstractUserGroupService.DEFAULT_NAME).createStore();
        ugStore.addUser(ugStore.createUserObject("cite", "cite", true));
        ugStore.store();
        GeoServerRoleStore roleStore = this.getSecurityManager().getActiveRoleService().createStore();
        GeoServerRole role = roleStore.createRoleObject("ROLE_DUMMY");
        roleStore.addRole(role);
        roleStore.associateRoleToUser(role, "cite");
        roleStore.store();
        this.prepare();
    }

    public void prepare() throws Exception {
        Catalog catalog = this.getCatalog();
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        tam.putLimits("cite", (CatalogInfo)catalog.getWorkspaceByName("cite"), (AccessLimits)new WorkspaceAccessLimits(CatalogMode.MIXED, false, false));
    }

    @Test
    public void testGetCapabilitiesLimitedWorkspace() throws Exception {
        this.setRequestAuth("cite", "cite");
        MockHttpServletResponse response = this.getAsServletResponse("cite/wms?service=WMS&version=1.1.1&request=GetCapabilities");
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }
}

