/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import java.lang.reflect.Type;
import java.util.Map;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.service.ServiceSettingsController;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSXStreamLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/services/wms"}, produces={"application/json", "application/xml", "text/html"})
public class WMSSettingsController
extends ServiceSettingsController<WMSInfo> {
    @Autowired
    public WMSSettingsController(GeoServer geoServer) {
        super(geoServer, WMSInfo.class);
    }

    @PutMapping(value={"/settings", "/workspaces/{workspaceName}/settings"}, consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void serviceSettingsPut(@RequestBody WMSInfo info, @PathVariable(required=false) String workspaceName) {
        super.serviceSettingsPut((ServiceInfo)info, workspaceName);
    }

    public String getTemplateName(Object object) {
        return "wmsSettings";
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return WMSInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        persister.setHideFeatureTypeAttributes();
        persister.setCallback(new XStreamPersister.Callback(){

            protected ServiceInfo getServiceObject() {
                ServiceInfo service;
                Map uriTemplateVars = WMSSettingsController.this.getURITemplateVariables();
                String workspace = (String)uriTemplateVars.get("workspaceName");
                if (workspace != null) {
                    WorkspaceInfo ws = WMSSettingsController.this.geoServer.getCatalog().getWorkspaceByName(workspace);
                    service = WMSSettingsController.this.geoServer.getService(ws, WMSInfo.class);
                } else {
                    service = WMSSettingsController.this.geoServer.getService(WMSInfo.class);
                }
                return service;
            }

            protected Class<WMSInfo> getObjectClass() {
                return WMSInfo.class;
            }
        });
        WMSXStreamLoader.initXStreamPersister((XStreamPersister)persister);
    }
}

