/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.wms.WMSInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class LocalWMSSettingsControllerTest
extends CatalogRESTTestSupport {
    @After
    public void clearLocalWorkspace() throws Exception {
        LocalWorkspace.remove();
        this.revertService(WMSInfo.class, "sf");
    }

    @Before
    public void initLocalWMS() throws Exception {
        WorkspaceInfo ws;
        GeoServer geoServer = this.getGeoServer();
        WMSInfo wmsInfo = (WMSInfo)geoServer.getService(ws = geoServer.getCatalog().getWorkspaceByName("sf"), WMSInfo.class);
        if (wmsInfo != null) {
            geoServer.remove((ServiceInfo)wmsInfo);
        }
        wmsInfo = (WMSInfo)geoServer.getFactory().create(WMSInfo.class);
        wmsInfo.setName("WMS");
        wmsInfo.setWorkspace(ws);
        geoServer.add((ServiceInfo)wmsInfo);
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/services/wms/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wmsinfo = (JSONObject)jsonObject.get("wms");
        Assert.assertEquals((Object)"WMS", (Object)wmsinfo.get("name"));
        JSONObject workspace = (JSONObject)wmsinfo.get("workspace");
        Assert.assertNotNull((Object)workspace);
        Assert.assertEquals((Object)"sf", (Object)workspace.get("name"));
        JSONObject watermark = (JSONObject)wmsinfo.get("watermark");
        Assert.assertEquals((Object)"false", (Object)watermark.get("enabled").toString().trim());
        Assert.assertEquals((Object)"Nearest", (Object)wmsinfo.get("interpolation"));
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/services/wms/workspaces/sf/settings.xml");
        Assert.assertEquals((Object)"wms", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wms/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf", (String)"/wms/workspace/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WMS", (String)"/wms/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wms/watermark/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Nearest", (String)"/wms/interpolation", (Document)dom);
    }

    @Test
    public void testGetAsHTML() throws Exception {
        this.getAsDOM("/rest/services/wms/workspaces/sf/settings.html");
    }

    @Test
    public void testCreateAsJSON() throws Exception {
        this.removeLocalWorkspace();
        String input = "{'wms': {'id' : 'wms_sf', 'workspace':{'name':'sf'},'name' : 'WMS', 'enabled': 'true'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wms/workspaces/sf/settings", input, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON json = this.getAsJSON("/rest/services/wms/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wmsinfo = (JSONObject)jsonObject.get("wms");
        Assert.assertEquals((Object)"WMS", (Object)wmsinfo.get("name"));
        Assert.assertEquals((Object)"true", (Object)wmsinfo.get("enabled").toString().trim());
        JSONObject workspace = (JSONObject)wmsinfo.get("workspace");
        Assert.assertNotNull((Object)workspace);
        Assert.assertEquals((Object)"sf", (Object)workspace.get("name"));
    }

    @Test
    public void testCreateAsXML() throws Exception {
        this.removeLocalWorkspace();
        String xml = "<wms><id>wms_sf</id><workspace><name>sf</name></workspace><name>OGC:WMS</name><enabled>false</enabled><interpolation>Nearest</interpolation></wms>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wms/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wms/workspaces/sf/settings.xml");
        Assert.assertEquals((Object)"wms", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wms/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf", (String)"/wms/workspace/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"OGC:WMS", (String)"/wms/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wms/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Nearest", (String)"/wms/interpolation", (Document)dom);
    }

    @Test
    public void testPutAsJSON() throws Exception {
        String json = "{'wms': {'id':'wms','workspace':{'name':'sf'},'enabled':'false','name':'WMS'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wms/workspaces/sf/settings", json, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON jsonMod = this.getAsJSON("/rest/services/wms/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)jsonMod;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wmsinfo = (JSONObject)jsonObject.get("wms");
        Assert.assertEquals((Object)"false", (Object)wmsinfo.get("enabled").toString().trim());
    }

    @Test
    public void testPutAsXML() throws Exception {
        String xml = "<wms><id>wms</id><workspace><name>sf</name></workspace><enabled>false</enabled></wms>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wms/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wms/workspaces/sf/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wms/enabled", (Document)dom);
    }

    @Test
    public void testPutFullAsXML() throws Exception {
        String xml = IOUtils.toString((InputStream)LocalWMSSettingsControllerTest.class.getResourceAsStream("wms.xml"), (Charset)StandardCharsets.UTF_8);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wms/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wms/workspaces/sf/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wms/enabled", (Document)dom);
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/services/wms/workspaces/sf/settings").getStatus());
        boolean thrown = false;
        try {
            this.getAsJSON("/rest/services/wms/workspaces/sf/settings.json");
        }
        catch (JSONException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }

    private void removeLocalWorkspace() {
        GeoServer geoServer = this.getGeoServer();
        WorkspaceInfo ws = geoServer.getCatalog().getWorkspaceByName("sf");
        WMSInfo wmsInfo = (WMSInfo)geoServer.getService(ws, WMSInfo.class);
        geoServer.remove((ServiceInfo)wmsInfo);
    }
}

