/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class WMTSSettingsControllerTest
extends CatalogRESTTestSupport {
    @After
    public void revertChanges() {
        this.revertService(WMTSInfo.class, null);
    }

    @Test
    public void testGetASJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/services/wmts/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wmtsinfo = (JSONObject)jsonObject.get("wmts");
        Assert.assertEquals((Object)"true", (Object)wmtsinfo.get("enabled").toString().trim());
        Assert.assertEquals((Object)"WMTS", (Object)wmtsinfo.get("name"));
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/services/wmts/settings.xml");
        Assert.assertEquals((Object)"wmts", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("name").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wmts/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WMTS", (String)"/wmts/name", (Document)dom);
    }

    @Test
    public void testGetAsHTML() throws Exception {
        this.getAsDOM("/rest/services/wmts/settings.html");
    }

    @Test
    public void testPutAsJSON() throws Exception {
        String json = "{'wmts': {'id':'wmts','enabled':'false','name':'WMTS', 'title':'New Title'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wmts/settings", json, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON jsonMod = this.getAsJSON("/rest/services/wmts/settings.json");
        JSONObject jsonObject = (JSONObject)jsonMod;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wmtsinfo = (JSONObject)jsonObject.get("wmts");
        Assert.assertEquals((Object)"false", (Object)wmtsinfo.get("enabled").toString().trim());
        Assert.assertEquals((Object)"WMTS", (Object)wmtsinfo.get("name"));
        Assert.assertEquals((Object)"New Title", (Object)wmtsinfo.get("title"));
    }

    @Test
    public void testPutAsXML() throws Exception {
        String xml = "<wmts><id>wmts</id><enabled>false</enabled><name>WMTS</name><title>New Title</title><maintainer>http://geoserver.org/comm</maintainer></wmts>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wmts/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wmts/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wmts/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WMTS", (String)"/wmts/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"New Title", (String)"/wmts/title", (Document)dom);
    }

    @Test
    public void testRoundTripJSON() throws Exception {
        JSONObject original = (JSONObject)this.getAsJSON("/rest/services/wmts/settings.json");
        Assert.assertNotNull((Object)original);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wmts/settings", original.toString(), "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON updated = this.getAsJSON("/rest/services/wmts/settings.json");
        Assert.assertEquals((Object)original, (Object)updated);
    }

    @Test
    public void testRoundTripXML() throws Exception {
        Document original = this.getAsDOM("/rest/services/wmts/settings.xml");
        Assert.assertEquals((Object)"wmts", (Object)original.getDocumentElement().getLocalName());
        String originalString = this.documentToString(original);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wmts/settings", originalString, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document updated = this.getAsDOM("/rest/services/wmts/settings.xml");
        Assert.assertEquals((Object)originalString, (Object)this.documentToString(updated));
    }

    private String documentToString(Document doc) throws Exception {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        WMTSInfo i = (WMTSInfo)geoServer.getService(WMTSInfo.class);
        i.setEnabled(true);
        geoServer.save((ServiceInfo)i);
        String xml = "<wmts><id>wmts</id><name>WMTS</name><title>GeoServer Web Map Service</title><maintainer>http://geoserver.org/comm</maintainer></wmts>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wmts/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wmts/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wmts/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WMTS", (String)"/wmts/name", (Document)dom);
        i = (WMTSInfo)geoServer.getService(WMTSInfo.class);
        Assert.assertTrue((boolean)i.isEnabled());
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse("/rest/services/wmts/settings").getStatus());
    }
}

