/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class LocalWMTSSettingsControllerTest
extends CatalogRESTTestSupport {
    @After
    public void clearLocalWorkspace() throws Exception {
        LocalWorkspace.remove();
        this.revertService(WMTSInfo.class, "sf");
    }

    @Before
    public void initLocalWMTS() throws Exception {
        WorkspaceInfo ws;
        GeoServer geoServer = this.getGeoServer();
        WMTSInfo wmtsInfo = (WMTSInfo)geoServer.getService(ws = geoServer.getCatalog().getWorkspaceByName("sf"), WMTSInfo.class);
        if (wmtsInfo != null) {
            geoServer.remove((ServiceInfo)wmtsInfo);
        }
        wmtsInfo = (WMTSInfo)geoServer.getFactory().create(WMTSInfo.class);
        wmtsInfo.setName("WMTS");
        wmtsInfo.setWorkspace(ws);
        geoServer.add((ServiceInfo)wmtsInfo);
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/services/wmts/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wmtsinfo = (JSONObject)jsonObject.get("wmts");
        Assert.assertEquals((Object)"WMTS", (Object)wmtsinfo.get("name"));
        JSONObject workspace = (JSONObject)wmtsinfo.get("workspace");
        Assert.assertNotNull((Object)workspace);
        Assert.assertEquals((Object)"sf", (Object)workspace.get("name"));
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/services/wmts/workspaces/sf/settings.xml");
        Assert.assertEquals((Object)"wmts", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wmts/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf", (String)"/wmts/workspace/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WMTS", (String)"/wmts/name", (Document)dom);
    }

    @Test
    public void testGetAsHTML() throws Exception {
        this.getAsDOM("/rest/services/wmts/workspaces/sf/settings.html");
    }

    @Test
    public void testCreateAsJSON() throws Exception {
        this.removeLocalWorkspace();
        String input = "{'wmts': {'id' : 'wmts_sf', 'workspace':{'name':'sf'},'name' : 'WMTS', 'enabled': 'true'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wmts/workspaces/sf/settings", input, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON json = this.getAsJSON("/rest/services/wmts/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wmtsinfo = (JSONObject)jsonObject.get("wmts");
        Assert.assertEquals((Object)"WMTS", (Object)wmtsinfo.get("name"));
        Assert.assertEquals((Object)"true", (Object)wmtsinfo.get("enabled").toString().trim());
        JSONObject workspace = (JSONObject)wmtsinfo.get("workspace");
        Assert.assertNotNull((Object)workspace);
        Assert.assertEquals((Object)"sf", (Object)workspace.get("name"));
    }

    @Test
    public void testCreateAsXML() throws Exception {
        this.removeLocalWorkspace();
        String xml = "<wmts><id>wmts_sf</id><workspace><name>sf</name></workspace><name>WMTS</name><enabled>false</enabled></wmts>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wmts/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wmts/workspaces/sf/settings.xml");
        Assert.assertEquals((Object)"wmts", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wmts/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf", (String)"/wmts/workspace/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WMTS", (String)"/wmts/name", (Document)dom);
    }

    @Test
    public void testPutAsJSON() throws Exception {
        String json = "{'wmts': {'id':'wmts','workspace':{'name':'sf'},'enabled':'false','name':'WMTS'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wmts/workspaces/sf/settings", json, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON jsonMod = this.getAsJSON("/rest/services/wmts/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)jsonMod;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wmtsinfo = (JSONObject)jsonObject.get("wmts");
        Assert.assertEquals((Object)"false", (Object)wmtsinfo.get("enabled").toString().trim());
    }

    @Test
    public void testPutAsXML() throws Exception {
        String xml = "<wmts><id>wmts</id><workspace><name>sf</name></workspace><enabled>false</enabled></wmts>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wmts/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wmts/workspaces/sf/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wmts/enabled", (Document)dom);
    }

    @Test
    public void testPutFullAsXML() throws Exception {
        String xml = IOUtils.toString((InputStream)LocalWMTSSettingsControllerTest.class.getResourceAsStream("wmts.xml"), (Charset)StandardCharsets.UTF_8);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wmts/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wmts/workspaces/sf/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wmts/enabled", (Document)dom);
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/services/wmts/workspaces/sf/settings").getStatus());
        boolean thrown = false;
        try {
            this.getAsJSON("/rest/services/wmts/workspaces/sf/settings.json");
        }
        catch (JSONException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }

    private void removeLocalWorkspace() {
        GeoServer geoServer = this.getGeoServer();
        WorkspaceInfo ws = geoServer.getCatalog().getWorkspaceByName("sf");
        WMTSInfo wmtsInfo = (WMTSInfo)geoServer.getService(ws, WMTSInfo.class);
        geoServer.remove((ServiceInfo)wmtsInfo);
    }
}

