/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import java.lang.reflect.Type;
import java.util.Map;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.gwc.wmts.WMTSInfoImpl;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.service.ServiceSettingsController;
import org.geoserver.wms.WMSXStreamLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/services/wmts"}, produces={"application/json", "application/xml", "text/html"})
public class WMTSSettingsController
extends ServiceSettingsController<WMTSInfo> {
    @Autowired
    public WMTSSettingsController(GeoServer geoServer) {
        super(geoServer, WMTSInfo.class);
    }

    @PutMapping(value={"/settings", "/workspaces/{workspaceName}/settings"}, consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void serviceSettingsPut(@RequestBody WMTSInfo info, @PathVariable(required=false) String workspaceName) {
        super.serviceSettingsPut((ServiceInfo)info, workspaceName);
    }

    public String getTemplateName(Object object) {
        return "wmtsSettings";
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return WMTSInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        persister.setHideFeatureTypeAttributes();
        persister.getClassAliasingMapper().addClassAlias("wmts", WMTSInfoImpl.class);
        persister.setCallback(new XStreamPersister.Callback(){

            protected ServiceInfo getServiceObject() {
                ServiceInfo service;
                Map uriTemplateVars = WMTSSettingsController.this.getURITemplateVariables();
                String workspace = (String)uriTemplateVars.get("workspaceName");
                if (workspace != null) {
                    WorkspaceInfo ws = WMTSSettingsController.this.geoServer.getCatalog().getWorkspaceByName(workspace);
                    service = WMTSSettingsController.this.geoServer.getService(ws, WMTSInfo.class);
                } else {
                    service = WMTSSettingsController.this.geoServer.getService(WMTSInfo.class);
                }
                return service;
            }

            protected Class<WMTSInfo> getObjectClass() {
                return WMTSInfo.class;
            }
        });
        WMSXStreamLoader.initXStreamPersister((XStreamPersister)persister);
    }
}

