/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourcePoolTest;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.data.property.PropertyDataStore;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataStoreControllerTest
extends CatalogRESTTestSupport {
    @BeforeClass
    public static void registerTestDirectoryStore() {
        DataStoreFinder.registerFactory((DataStoreFactorySpi)ResourcePoolTest.TEST_DIRECTORY_STORE_FACTORY_SPI);
    }

    @AfterClass
    public static void deregisterTestDirectoryStore() {
        DataStoreFinder.deregisterFactory((DataStoreFactorySpi)ResourcePoolTest.TEST_DIRECTORY_STORE_FACTORY_SPI);
    }

    @Before
    public void addDataStores() throws IOException {
        this.removeStore("sf", "newDataStore");
        this.removeStore("sf", "sf");
        ((SystemTestData)this.getTestData()).addVectorLayer(SystemTestData.PRIMITIVEGEOFEATURE, catalog);
        ((SystemTestData)this.getTestData()).addVectorLayer(SystemTestData.AGGREGATEGEOFEATURE, catalog);
        ((SystemTestData)this.getTestData()).addVectorLayer(SystemTestData.GENERICENTITY, catalog);
    }

    @Test
    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores.xml");
        Assert.assertEquals((long)catalog.getStoresByWorkspace("sf", DataStoreInfo.class).size(), (long)dom.getElementsByTagName("dataStore").getLength());
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/datastores/sf.json");
        JSONObject dataStore = ((JSONObject)json).getJSONObject("dataStore");
        Assert.assertNotNull((Object)dataStore);
        Assert.assertEquals((Object)"sf", (Object)dataStore.get("name"));
        Assert.assertEquals((Object)"sf", (Object)dataStore.getJSONObject("workspace").get("name"));
        Assert.assertNotNull((Object)dataStore.get("connectionParameters"));
    }

    @Test
    public void testGetAllAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/datastores.json");
        Assert.assertTrue((boolean)(json instanceof JSONObject));
        Object datastores = ((JSONObject)json).getJSONObject("dataStores").get("dataStore");
        Assert.assertNotNull((Object)datastores);
        if (datastores instanceof JSONArray) {
            Assert.assertEquals((long)catalog.getDataStoresByWorkspace("sf").size(), (long)((JSONArray)datastores).size());
        } else {
            Assert.assertEquals((long)1L, (long)catalog.getDataStoresByWorkspace("sf").size());
        }
    }

    @Test
    public void testGetAllAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores.html");
        List datastores = catalog.getDataStoresByWorkspace("sf");
        NodeList links = xp.getMatchingNodes("//html:a", dom);
        Assert.assertEquals((long)datastores.size(), (long)links.getLength());
        for (int i = 0; i < datastores.size(); ++i) {
            DataStoreInfo ds = (DataStoreInfo)datastores.get(i);
            Element link = (Element)links.item(i);
            Assert.assertTrue((boolean)link.getAttribute("href").endsWith(ds.getName() + ".html"));
        }
    }

    @Test
    public void testPutAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.putAsServletResponse("/rest/workspaces/sf/datastores").getStatus());
    }

    @Test
    public void testDeleteAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/datastores").getStatus());
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.xml");
        this.print(dom);
        Assert.assertEquals((Object)"dataStore", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"sf", (Object)xp.evaluate("/dataStore/name", dom));
        Assert.assertEquals((Object)"sf", (Object)xp.evaluate("/dataStore/workspace/name", dom));
        XMLAssert.assertXpathExists((String)"/dataStore/connectionParameters", (Document)dom);
        MatcherAssert.assertThat((Object)xp.evaluate("/dataStore/featureTypes/atom:link/@href", dom), (Matcher)Matchers.endsWith((String)"/rest/workspaces/sf/datastores/sf/featuretypes.xml"));
    }

    @Test
    public void testRoundTripGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.xml");
        Assert.assertEquals((Object)"dataStore", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"sf", (Object)xp.evaluate("/dataStore/name", dom));
        Assert.assertEquals((Object)"sf", (Object)xp.evaluate("/dataStore/workspace/name", dom));
        XMLAssert.assertXpathExists((String)"/dataStore/connectionParameters", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/dataStore/enabled", (Document)dom);
        String xml = "<dataStore><name>sf</name><enabled>false</enabled></dataStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/datastores/sf", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/dataStore/enabled", (Document)dom);
        Assert.assertFalse((boolean)catalog.getDataStoreByName("sf", "sf").isEnabled());
    }

    @Test
    public void testGetAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.html");
        DataStoreInfo ds = catalog.getDataStoreByName("sf");
        List featureTypes = catalog.getFeatureTypesByDataStore(ds);
        NodeList links = xp.getMatchingNodes("//html:a", dom);
        Assert.assertEquals((long)featureTypes.size(), (long)links.getLength());
        for (int i = 0; i < featureTypes.size(); ++i) {
            FeatureTypeInfo ft = (FeatureTypeInfo)featureTypes.get(i);
            Element link = (Element)links.item(i);
            Assert.assertTrue((boolean)link.getAttribute("href").endsWith(ft.getName() + ".html"));
        }
    }

    @Test
    public void testGetWrongDataStore() throws Exception {
        String ws = "sf";
        String ds = "sfssssss";
        String requestPath = "/rest/workspaces/" + ws + "/datastores/" + ds + ".html";
        String exception = "No such datastore: " + ws + "," + ds;
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().contains(exception));
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertFalse((boolean)response.getContentAsString().contains(exception));
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
    }

    File setupNewDataStore() throws Exception {
        return this.setupNewDataStore("newDataStore");
    }

    File setupNewDataStore(String name) throws Exception {
        Properties props = new Properties();
        props.put("_", "name:StringpointProperty:Point");
        props.put("NewDataStore.0", "'zero'|POINT(0 0)");
        props.put("NewDataStore.1", "'one'|POINT(1 1)");
        File dir = new File("./target/nds/" + name);
        dir.mkdirs();
        File file = new File(dir, name + ".properties");
        file.deleteOnExit();
        dir.deleteOnExit();
        props.store(new FileOutputStream(file), null);
        return dir;
    }

    @Test
    public void testPostAsXML() throws Exception {
        File dir = this.setupNewDataStore();
        String xml = "<dataStore><name>newDataStore</name><connectionParameters><namespace><string>sf</string></namespace><directory><string>" + dir.getAbsolutePath() + "</string></directory></connectionParameters><workspace>sf</workspace></dataStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/datastores", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/sf/datastores/newDataStore"));
        DataStoreInfo newDataStore = catalog.getDataStoreByName("newDataStore");
        Assert.assertNotNull((Object)newDataStore);
        Assert.assertNotNull((Object)newDataStore.getDateCreated());
        DataStore ds = (DataStore)newDataStore.getDataStore(null);
        Assert.assertNotNull((Object)ds);
    }

    @Test
    public void testPostAsXMLNoWorkspace() throws Exception {
        File dir = this.setupNewDataStore();
        String xml = "<dataStore><name>newDataStore</name><connectionParameters><namespace><string>sf</string></namespace><directory><string>" + dir.getAbsolutePath() + "</string></directory></connectionParameters></dataStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/datastores", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/sf/datastores/newDataStore"));
        DataStoreInfo newDataStore = catalog.getDataStoreByName("newDataStore");
        Assert.assertNotNull((Object)newDataStore);
        Assert.assertNotNull((Object)newDataStore.getDateCreated());
        DataStore ds = (DataStore)newDataStore.getDataStore(null);
        Assert.assertNotNull((Object)ds);
    }

    @Test
    public void testPostAsJSON() throws Exception {
        this.removeStore("sf", "newDataStore");
        File dir = this.setupNewDataStore();
        String json = "{'dataStore':{'connectionParameters': {'namespace': {'string':'sf'},'directory': {'string':'" + dir.getAbsolutePath().replace('\\', '/') + "'}},'workspace':'sf','name':'newDataStore',}}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/datastores", json, "text/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/sf/datastores/newDataStore"));
        DataStoreInfo newDataStore = catalog.getDataStoreByName("newDataStore");
        Assert.assertNotNull((Object)newDataStore);
        Assert.assertNotNull((Object)newDataStore.getDateCreated());
        DataStore ds = (DataStore)newDataStore.getDataStore(null);
        Assert.assertNotNull((Object)ds);
    }

    @Test
    public void testPostToResource() throws Exception {
        String xml = "<dataStore><name>sf</name><enabled>false</enabled></dataStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/datastores/sf", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testPut() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/dataStore/enabled", (Document)dom);
        String xml = "<dataStore><name>sf</name><enabled>false</enabled></dataStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/datastores/sf", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/dataStore/enabled", (Document)dom);
        Assert.assertFalse((boolean)catalog.getDataStoreByName("sf", "sf").isEnabled());
        Assert.assertNotNull((Object)catalog.getDataStoreByName("sf", "sf").getDateModified());
    }

    @Test
    public void testPut2() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//dataStore/connectionParameters/*)", (Document)dom);
        String xml = "<dataStore><name>sf</name><connectionParameters><one><string>1</string></one><two><string>2</string></two></connectionParameters></dataStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/datastores/sf", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        DataStoreInfo ds = catalog.getDataStoreByName("sf", "sf");
        Assert.assertEquals((long)2L, (long)ds.getConnectionParameters().size());
        Assert.assertTrue((boolean)ds.getConnectionParameters().containsKey("one"));
        Assert.assertTrue((boolean)ds.getConnectionParameters().containsKey("two"));
        Assert.assertNotNull((Object)ds.getDateModified());
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        DataStoreInfo ds = catalog.getDataStoreByName("sf", "sf");
        Assert.assertTrue((boolean)ds.isEnabled());
        String xml = "<dataStore><name>sf</name></dataStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/datastores/sf", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)ds.isEnabled());
    }

    @Test
    public void testPutNonExistant() throws Exception {
        String xml = "<dataStore><name>changed</name></dataStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/datastores/nonExistant", xml, "text/xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testDeleteNonExistant() throws Exception {
        Assert.assertEquals((long)404L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/nonExistant").getStatus());
    }

    @Test
    public void testDelete() throws Exception {
        this.removeStore("sf", "newDataStore");
        File dir = this.setupNewDataStore();
        String xml = "<dataStore><name>newDataStore</name><connectionParameters><entry><string>namespace</string><string>sf</string></entry><entry><string>directory</string><string>" + dir.getAbsolutePath() + "</string></entry></connectionParameters><workspace>sf</workspace></dataStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/datastores", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)catalog.getDataStoreByName("sf", "newDataStore"));
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/newDataStore").getStatus());
        Assert.assertNull((Object)catalog.getDataStoreByName("sf", "newDataStore"));
    }

    @Test
    public void testDeleteNonEmptyForbidden() throws Exception {
        Assert.assertEquals((long)403L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/sf").getStatus());
    }

    @Test
    public void testDeleteRecursive() throws Exception {
        Assert.assertNotNull((Object)catalog.getDataStoreByName("sf", "sf"));
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/sf/datastores/sf?recurse=true");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNull((Object)catalog.getDataStoreByName("sf", "sf"));
        for (FeatureTypeInfo ft : catalog.getFeatureTypes()) {
            if (!ft.getStore().getName().equals("sf")) continue;
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteNonEmptyNonRecursiveNonUniqueStoreOnWorkspace() throws Exception {
        String store1 = "aa_sf";
        String store2 = "zz_sf";
        this.createDataStore("sf", store1);
        this.createDataStore("sf", store2);
        try {
            List dataStoresByWorkspace = catalog.getDataStoresByWorkspace("sf");
            Assert.assertEquals((long)3L, (long)dataStoresByWorkspace.size());
            Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/" + store1).getStatus());
            Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/" + store2).getStatus());
            Assert.assertNull((Object)catalog.getDataStoreByName("sf", store1));
            Assert.assertNull((Object)catalog.getDataStoreByName("sf", store2));
        }
        finally {
            this.removeStore("sf", store1);
            this.removeStore("sf", store2);
        }
    }

    private void createDataStore(String workspace, String name) throws Exception {
        this.removeStore(workspace, name);
        File dir = this.setupNewDataStore(name);
        String xml = "<dataStore><name>" + name + "</name><connectionParameters><entry><string>namespace</string><string>" + workspace + "</string></entry><entry><string>directory</string><string>" + dir.getAbsolutePath() + "</string></entry></connectionParameters><workspace>" + workspace + "</workspace></dataStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/datastores", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
    }

    @Test
    public void testPutNameChange() throws Exception {
        Assert.assertNotNull((Object)catalog.getDataStoreByName("sf", "sf"));
        String xml = "<dataStore><name>sff</name></dataStore>";
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse("/rest/workspaces/sf/datastores/sf", xml, "text/xml").getStatus());
        Assert.assertNotNull((Object)catalog.getDataStoreByName("sf", "sff"));
        this.removeStore("sf", "sff");
    }

    @Test
    public void testPutWorkspaceChange() throws Exception {
        String xml = "<dataStore><workspace>gs</workspace></dataStore>";
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse("/rest/workspaces/sf/datastores/sf", xml, "text/xml").getStatus());
        Assert.assertNotNull((Object)catalog.getDataStoreByName("gs", "sf"));
        this.removeStore("gs", "sf");
    }

    @Test
    public void testDataStoreReset() throws Exception {
        DataStoreInfo store = this.getCatalog().getDataStoreByName(SystemTestData.PRIMITIVEGEOFEATURE.getPrefix());
        DataStore dataStore = (DataStore)store.getDataStore(null);
        Assert.assertNotNull((Object)dataStore);
        MatcherAssert.assertThat((Object)dataStore, (Matcher)Matchers.instanceOf(PropertyDataStore.class));
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(this.getLayerId(SystemTestData.PRIMITIVEGEOFEATURE));
        FeatureType featureType = fti.getFeatureType();
        Assert.assertNotNull((Object)featureType.getDescriptor("description"));
        Assert.assertNull((Object)featureType.getDescriptor("identifier"));
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/datastores/sf/reset", "", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        try (InputStream is = SystemTestData.class.getResourceAsStream("PrimitiveGeoFeatureId.properties");
             OutputStream os = this.getDataDirectory().get(new String[]{"sf/PrimitiveGeoFeature.properties"}).out();){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        store = this.getCatalog().getDataStoreByName(SystemTestData.PRIMITIVEGEOFEATURE.getPrefix());
        DataStore dataStoreNew = (DataStore)store.getDataStore(null);
        Assert.assertNotNull((Object)dataStoreNew);
        MatcherAssert.assertThat((Object)dataStoreNew, (Matcher)Matchers.instanceOf(PropertyDataStore.class));
        Assert.assertNotSame((Object)dataStoreNew, (Object)dataStore);
        fti = this.getCatalog().getFeatureTypeByName(this.getLayerId(SystemTestData.PRIMITIVEGEOFEATURE));
        FeatureType featureTypeNew = fti.getFeatureType();
        Assert.assertNotSame((Object)featureTypeNew, (Object)featureType);
        Assert.assertNotNull((Object)featureTypeNew.getDescriptor("description"));
        Assert.assertNotNull((Object)featureTypeNew.getDescriptor("identifier"));
    }
}

