/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class SecuredControllerAccessTest
extends GeoServerSystemTestSupport {
    protected List<Filter> getFilters() {
        return Collections.singletonList((Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Before
    public void setRequestCredentials() throws Exception {
        this.setRequestAuth("admin", "geoserver");
    }

    @Test
    public void testGetStatusAuthorized() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/about/status.xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.dom(this.getBinaryInputStream(response));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//status[name='GeoServer Main'])", (Document)dom);
    }

    @Test
    public void testGetStatusNotAuthorized() throws Exception {
        this.setRequestAuth(null, null);
        MockHttpServletResponse response = this.getAsServletResponse("/rest/about/status.xml");
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    @Test
    public void testHeadStatus() throws Exception {
        MockHttpServletRequest request = this.createRequest("/rest/about/status.xml");
        request.setMethod("HEAD");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testOptionsStatus() throws Exception {
        MockHttpServletRequest request = this.createRequest("/rest/about/status.xml");
        request.setMethod("OPTIONS");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }
}

