/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.data.test.TestData;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.rest.catalog.StyleController;
import org.geotools.api.style.Style;
import org.geotools.util.URLs;
import org.geotools.util.Version;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StyleControllerTest
extends CatalogRESTTestSupport {
    @Before
    public void removeStyles() throws IOException {
        this.removeStyle("gs", "foo");
        this.removeStyle(null, "foo");
        this.removeStyle(this.getCatalog().getDefaultWorkspace().getName(), "foo");
    }

    @Before
    public void addPondsStyle() throws IOException {
        ((SystemTestData)this.getTestData()).addStyle(SystemTestData.PONDS.getLocalPart(), this.getCatalog());
    }

    @Before
    public void restoreLayers() throws IOException {
        this.revertLayer(SystemTestData.BASIC_POLYGONS);
    }

    @Test
    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/styles.xml");
        List styles = catalog.getStyles();
        XMLAssert.assertXpathEvaluatesTo((String)("" + styles.size()), (String)"count(//style)", (Document)dom);
    }

    @Test
    public void testGetAllASJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/styles.json");
        this.print(json);
        List styles = catalog.getStyles();
        Assert.assertEquals((long)styles.size(), (long)((JSONObject)json).getJSONObject("styles").getJSONArray("style").size());
    }

    @Test
    public void testGetAllAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/styles.html");
        this.print(dom);
        List styles = catalog.getStylesByWorkspace(CatalogFacade.NO_WORKSPACE);
        NodeList links = xp.getMatchingNodes("//html:a", dom);
        for (int i = 0; i < styles.size(); ++i) {
            StyleInfo s = (StyleInfo)styles.get(i);
            Element link = (Element)links.item(i);
            String href = link.getAttribute("href");
            Assert.assertTrue((String)("Expected href to bed with " + s.getName() + ".html but was " + href), (boolean)href.endsWith(s.getName() + ".html"));
        }
    }

    @Test
    public void testGetAllFromWorkspace() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/gs/styles.xml");
        Assert.assertEquals((Object)"styles", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//style)", (Document)dom);
        this.addStyleToWorkspace("foo");
        dom = this.getAsDOM("/rest/workspaces/gs/styles.xml");
        Assert.assertEquals((Object)"styles", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//style)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//style/name[text() = 'foo']", (Document)dom);
    }

    void addStyleToWorkspace(String name) {
        Catalog cat = this.getCatalog();
        StyleInfo s = cat.getFactory().createStyle();
        s.setName(name);
        s.setFilename(name + ".sld");
        s.setWorkspace(cat.getWorkspaceByName("gs"));
        cat.add(s);
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/styles/Ponds.xml");
        Assert.assertEquals((Object)"style", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"Ponds", (String)"/style/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Ponds.sld", (String)"/style/filename", (Document)dom);
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/styles/Ponds.json");
        JSONObject style = ((JSONObject)json).getJSONObject("style");
        Assert.assertEquals((Object)"Ponds", (Object)style.get("name"));
        Assert.assertEquals((Object)"Ponds.sld", (Object)style.get("filename"));
    }

    @Test
    public void testGetWrongStyle() throws Exception {
        String ws = "gs";
        String style = "foooooo";
        String requestPath = "/rest/styles/" + style + ".html";
        String requestPath2 = "/rest/workspaces/" + ws + "/styles/" + style + ".html";
        String exception = "No such style: " + style;
        String exception2 = "No such style " + style + " in workspace " + ws;
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().contains(exception));
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertFalse((boolean)response.getContentAsString().contains(exception));
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
        response = this.getAsServletResponse(requestPath2);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().contains(exception2));
        response = this.getAsServletResponse(requestPath2 + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertFalse((boolean)response.getContentAsString().contains(exception2));
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
    }

    @Test
    public void testGetAsSLD() throws Exception {
        Document dom = this.getAsDOM("/rest/styles/Ponds.sld");
        Assert.assertEquals((Object)"StyledLayerDescriptor", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testGetFromWorkspace() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("/rest/workspaces/gs/styles/foo.xml");
        Assert.assertEquals((long)404L, (long)resp.getStatus());
        this.addStyleToWorkspace("foo");
        resp = this.getAsServletResponse("/rest/workspaces/gs/styles/foo.xml");
        Assert.assertEquals((long)200L, (long)resp.getStatus());
        Document dom = this.getAsDOM("/rest/workspaces/gs/styles/foo.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"foo", (String)"/style/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"gs", (String)"/style/workspace/name", (Document)dom);
    }

    @Test
    public void testGetGlobalWithDuplicateInDefaultWorkspace() throws Exception {
        Catalog cat = this.getCatalog();
        String styleName = "foo";
        String wsName = cat.getDefaultWorkspace().getName();
        StyleInfo s = cat.getFactory().createStyle();
        s.setName(styleName);
        s.setFilename(styleName + ".sld");
        s.setWorkspace(cat.getDefaultWorkspace());
        cat.add(s);
        MockHttpServletResponse resp = this.getAsServletResponse("/rest/styles/foo.xml");
        Assert.assertEquals((long)404L, (long)resp.getStatus());
        s = cat.getFactory().createStyle();
        s.setName(styleName);
        s.setFilename(styleName + ".sld");
        cat.add(s);
        Document dom = this.getAsDOM("/rest/styles/foo.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"foo", (String)"/style/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"/style/workspace/name", (Document)dom);
        dom = this.getAsDOM("/rest/workspaces/" + wsName + "/styles/foo.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"foo", (String)"/style/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)wsName, (String)"/style/workspace/name", (Document)dom);
    }

    String newSLDXML() {
        return "<sld:StyledLayerDescriptor xmlns:sld='http://www.opengis.net/sld'><sld:NamedLayer><sld:Name>foo</sld:Name><sld:UserStyle><sld:Name>foo</sld:Name><sld:FeatureTypeStyle><sld:Name>foo</sld:Name></sld:FeatureTypeStyle></sld:UserStyle></sld:NamedLayer></sld:StyledLayerDescriptor>";
    }

    String newSLD11XML() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" version=\"1.1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xsi:schemaLocation=\"http://www.opengis.net/sld http://schemas.opengis.net/sld/1.1.0/StyledLayerDescriptor.xsd\" xmlns:se=\"http://www.opengis.net/se\">\n  <NamedLayer>\n    <se:Name>foo</se:Name>\n    <UserStyle>\n      <se:Name>foo</se:Name>\n      <se:FeatureTypeStyle>\n        <se:Rule>\n          <se:Name>Single symbol</se:Name>\n          <se:LineSymbolizer>\n            <se:Stroke>\n              <se:SvgParameter name=\"stroke\">#aa6e8e</se:SvgParameter>\n              <se:SvgParameter name=\"stroke-width\">2</se:SvgParameter>\n              <se:SvgParameter name=\"stroke-linejoin\">round</se:SvgParameter>\n              <se:SvgParameter name=\"stroke-linecap\">round</se:SvgParameter>\n            </se:Stroke>\n          </se:LineSymbolizer>\n        </se:Rule>\n      </se:FeatureTypeStyle>\n    </UserStyle>\n  </NamedLayer>\n</StyledLayerDescriptor>";
    }

    @Test
    public void testPostAsSLD() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles", xml, "application/vnd.ogc.sld+xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/styles/foo"));
        Assert.assertNotNull((Object)catalog.getStyleByName("foo"));
    }

    @Test
    public void testPostAsSLD11() throws Exception {
        String xml = this.newSLD11XML();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles", xml, "application/vnd.ogc.se+xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/styles/foo"));
        StyleInfo style = catalog.getStyleByName("foo");
        Assert.assertNotNull((Object)style);
        Assert.assertNotNull((Object)style.getSLD());
    }

    @Test
    public void testPostExternalEntityAsSLD() throws Exception {
        String xml = IOUtils.toString((URL)TestData.class.getResource("externalEntities.sld"), (Charset)StandardCharsets.UTF_8);
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles", xml, "application/vnd.ogc.sld+xml");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        String message = response.getContentAsString();
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed"));
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"/this/file/does/not/exist"));
    }

    @Test
    public void testPostAsSLDToWorkspace() throws Exception {
        Assert.assertNull((Object)catalog.getStyleByName("gs", "foo"));
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/styles", xml, "application/vnd.ogc.sld+xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/gs/styles/foo"));
        Assert.assertNotNull((Object)catalog.getStyleByName("gs", "foo"));
        Assert.assertNotNull((Object)catalog.getStyleByName("gs", "foo").getDateCreated());
        GeoServerResourceLoader rl = this.getResourceLoader();
        Assert.assertNotNull((Object)rl.find(new String[]{"workspaces", "gs", "styles", "foo.sld"}));
    }

    @Test
    public void testPostAsSLD11ToWorkspace() throws Exception {
        Assert.assertNull((Object)catalog.getStyleByName("gs", "foo"));
        String xml = this.newSLD11XML();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/styles", xml, "application/vnd.ogc.se+xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/gs/styles/foo"));
        Assert.assertNotNull((Object)catalog.getStyleByName("gs", "foo"));
        Assert.assertNotNull((Object)catalog.getStyleByName("gs", "foo").getDateCreated());
        GeoServerResourceLoader rl = this.getResourceLoader();
        Assert.assertNotNull((Object)rl.find(new String[]{"workspaces", "gs", "styles", "foo.sld"}));
        StyleInfo styleInfo = catalog.getStyleByName("gs:foo");
        Assert.assertNotNull((Object)styleInfo);
        Assert.assertNotNull((Object)styleInfo.getSLD());
    }

    @Test
    public void testPostAsSLDWithName() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles?name=bar", xml, "application/vnd.ogc.sld+xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/styles/bar"));
        Assert.assertNotNull((Object)catalog.getStyleByName("bar"));
        Assert.assertNotNull((Object)catalog.getStyleByName("bar").getDateCreated());
    }

    @Test
    public void testStyleWithSpaceInName() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles?name=Default%20Styler", xml, "application/vnd.ogc.sld+xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        MatcherAssert.assertThat((Object)response.getHeader("Location"), (Matcher)Matchers.endsWith((String)"/styles/Default%20Styler"));
        Assert.assertNotNull((Object)catalog.getStyleByName("Default Styler"));
        response = this.deleteAsServletResponse("/rest/styles/Default+Styler");
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testPostToWorkspace() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getStyleByName("gs", "foo"));
        String xml = "<style><name>foo</name><filename>foo.sld</filename></style>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/styles", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"text/plain"));
        Assert.assertNotNull((Object)cat.getStyleByName("gs", "foo"));
        Assert.assertNotNull((Object)cat.getStyleByName("gs", "foo").getDateCreated());
    }

    @Test
    public void testPut() throws Exception {
        StyleInfo style = catalog.getStyleByName("Ponds");
        Assert.assertEquals((Object)"Ponds.sld", (Object)style.getFilename());
        String xml = "<style><name>Ponds</name><filename>Forests.sld</filename></style>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds", xml.getBytes(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        style = catalog.getStyleByName("Ponds");
        Assert.assertEquals((Object)"Forests.sld", (Object)style.getFilename());
        Assert.assertNotNull((Object)style.getDateModified());
    }

    @Test
    public void testGetWithMetadataAsXML() throws Exception {
        StyleInfo style = catalog.getStyleByName("Ponds");
        style.getMetadata().put("cacheAgeMax", (Serializable)((Object)"300"));
        catalog.save(style);
        Document dom = this.getAsDOM("/rest/styles/Ponds.xml");
        Assert.assertEquals((Object)"style", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"Ponds", (String)"/style/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Ponds.sld", (String)"/style/filename", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"300", (String)"/style/metadata/entry[@key='cacheAgeMax']", (Document)dom);
    }

    @Test
    public void testGetWithMetadataAsJSON() throws Exception {
        StyleInfo style = catalog.getStyleByName("Ponds");
        style.getMetadata().put("cacheAgeMax", (Serializable)((Object)"300"));
        style.getMetadata().put("surename", (Serializable)((Object)"test1"));
        catalog.save(style);
        JSON json = this.getAsJSON("/rest/styles/Ponds.json");
        JSONObject styleJson = ((JSONObject)json).getJSONObject("style");
        Assert.assertEquals((Object)"Ponds", (Object)styleJson.get("name"));
        Assert.assertEquals((Object)"Ponds.sld", (Object)styleJson.get("filename"));
        Collection entryCollection = JSONArray.toCollection((JSONArray)styleJson.getJSONObject("metadata").getJSONArray("entry"), JSONObject.class);
        Assert.assertTrue((boolean)entryCollection.stream().anyMatch(j -> "cacheAgeMax".equals(j.getString("@key")) && "300".equals(j.getString("$"))));
        Assert.assertTrue((boolean)entryCollection.stream().anyMatch(j -> "surename".equals(j.getString("@key")) && "test1".equals(j.getString("$"))));
    }

    @Test
    public void testPutWithMetadata() throws Exception {
        StyleInfo style = catalog.getStyleByName("Ponds");
        Assert.assertEquals((Object)"Ponds.sld", (Object)style.getFilename());
        String xml = "<style><name>Ponds</name><filename>Forests.sld</filename><metadata> <entry key=\"cacheAgeMax\">300</entry> </metadata></style>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds", xml.getBytes(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        style = catalog.getStyleByName("Ponds");
        Assert.assertEquals((Object)"Forests.sld", (Object)style.getFilename());
        MetadataMap metadata = style.getMetadata();
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((long)1L, (long)metadata.size());
        Assert.assertEquals((Object)"300", (Object)metadata.get((Object)"cacheAgeMax"));
        Assert.assertNotNull((Object)style.getDateModified());
    }

    @Test
    public void testPutJSONWithMetadata() throws Exception {
        StyleInfo style = catalog.getStyleByName("Ponds");
        Assert.assertEquals((Object)"Ponds.sld", (Object)style.getFilename());
        String json = "{\"style\": {\"name\":\"Ponds\",\"format\":\"sld\",\"languageVersion\":{\"version\":\"1.0.0\"},\"filename\":\"Ponds.sld\",\"metadata\":{\"entry\":[{\"@key\":\"cacheAgeMax\",\"$\":\"300\"},{\"@key\":\"surename\",\"$\":\"test1\"}]}}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds.json", json.getBytes(), "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        style = catalog.getStyleByName("Ponds");
        Assert.assertEquals((Object)"Ponds.sld", (Object)style.getFilename());
        MetadataMap metadata = style.getMetadata();
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((long)2L, (long)metadata.size());
        Assert.assertEquals((Object)"300", (Object)metadata.get((Object)"cacheAgeMax"));
        Assert.assertEquals((Object)"test1", (Object)metadata.get((Object)"surename"));
        Assert.assertNotNull((Object)style.getDateModified());
    }

    @Test
    public void testPutAsSLD() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds", xml, "application/vnd.ogc.sld+xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Style s = catalog.getStyleByName("Ponds").getStyle();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SLDHandler handler = new SLDHandler();
        handler.encode(Styles.sld((Style)s), SLDHandler.VERSION_10, false, (OutputStream)out);
        xml = new String(out.toByteArray());
        Assert.assertTrue((boolean)xml.contains("<sld:Name>foo</sld:Name>"));
    }

    @Test
    public void testPutAsSLDWithCharset() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds", xml, "application/vnd.ogc.sld+xml; charset=utf-8");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Style s = catalog.getStyleByName("Ponds").getStyle();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SLDHandler handler = new SLDHandler();
        handler.encode(Styles.sld((Style)s), SLDHandler.VERSION_10, false, (OutputStream)out);
        xml = new String(out.toByteArray());
        Assert.assertTrue((boolean)xml.contains("<sld:Name>foo</sld:Name>"));
    }

    @Test
    public void testPutAsSLD11Raw() throws Exception {
        String xml = this.newSLD11XML();
        StyleInfo infoBefore = catalog.getStyleByName("Ponds");
        MatcherAssert.assertThat((Object)infoBefore.getFormatVersion(), (Matcher)CoreMatchers.equalTo((Object)SLDHandler.VERSION_10));
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds?raw=true", xml, "application/vnd.ogc.se+xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        StyleInfo infoAfter = catalog.getStyleByName("Ponds");
        MatcherAssert.assertThat((Object)infoAfter.getFormatVersion(), (Matcher)CoreMatchers.equalTo((Object)SLDHandler.VERSION_11));
        Assert.assertNotNull((Object)infoAfter.getDateModified());
    }

    @Test
    public void testPutVersionBackAndForth() throws Exception {
        this.testPutAsSLD11Raw();
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds?raw=true", xml, "application/vnd.ogc.sld+xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        StyleInfo infoAfter = catalog.getStyleByName("Ponds");
        MatcherAssert.assertThat((Object)infoAfter.getFormatVersion(), (Matcher)CoreMatchers.equalTo((Object)SLDHandler.VERSION_10));
        Assert.assertNotNull((Object)infoAfter.getDateModified());
    }

    @Test
    public void testPutAsSLDWithExtension() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds.sld", xml, "application/vnd.ogc.sld+xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Style s = catalog.getStyleByName("Ponds").getStyle();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SLDHandler handler = new SLDHandler();
        handler.encode(Styles.sld((Style)s), SLDHandler.VERSION_10, false, (OutputStream)out);
        xml = new String(out.toByteArray());
        Assert.assertTrue((boolean)xml.contains("<sld:Name>foo</sld:Name>"));
    }

    @Test
    public void testRawPutAsSLD() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds?raw=true", xml, "application/vnd.ogc.sld+xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Style s = catalog.getStyleByName("Ponds").getStyle();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SLDHandler handler = new SLDHandler();
        handler.encode(Styles.sld((Style)s), SLDHandler.VERSION_10, false, (OutputStream)out);
        xml = new String(out.toByteArray());
        Assert.assertTrue((boolean)xml.contains("<sld:Name>foo</sld:Name>"));
    }

    @Test
    public void testRawPutAsInvalidSLD() throws Exception {
        String xml = "This is not valid SLD";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds?raw=true", xml, "application/vnd.ogc.sld+xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        StyleInfo styleInfo = catalog.getStyleByName("Ponds");
        String fileName = styleInfo.getFilename();
        GeoServerResourceLoader resources = this.getGeoServer().getCatalog().getResourceLoader();
        Resource resource = resources.get("styles/" + fileName);
        String content = new String(resource.getContents());
        Assert.assertFalse((String)"replaced", (boolean)content.contains("<sld:Name>foo</sld:Name>"));
        Assert.assertTrue((String)"replaced", (boolean)content.contains("not valid"));
    }

    @Test
    public void testPutToWorkspace() throws Exception {
        this.testPostToWorkspace();
        Catalog cat = this.getCatalog();
        Assert.assertEquals((Object)"foo.sld", (Object)cat.getStyleByName("gs", "foo").getFilename());
        String xml = "<style><filename>bar.sld</filename></style>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/styles/foo", xml, "application/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"bar.sld", (Object)cat.getStyleByName("gs", "foo").getFilename());
        Assert.assertNotNull((Object)cat.getStyleByName("gs", "foo").getDateModified());
    }

    @Test
    public void testPutToWorkspaceChangeWorkspace() throws Exception {
        this.testPostToWorkspace();
        String xml = "<style><workspace>cite</workspace></style>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/styles/foo", xml, "application/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((String)"cite", (Object)this.getCatalog().getStyleByName("cite", "foo"));
        Assert.assertNotNull((String)"cite", (Object)this.getCatalog().getStyleByName("cite", "foo").getWorkspace());
        Assert.assertEquals((Object)"cite", (Object)this.getCatalog().getStyleByName("cite", "foo").getWorkspace().getName());
        Assert.assertNotNull((Object)this.getCatalog().getStyleByName("cite", "foo").getDateModified());
    }

    @Test
    public void testPutToWorkspaceChangeWorkspaceBackToGlobal() throws Exception {
        this.testPostToWorkspace();
        String xml = "<style><workspace></workspace></style>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/styles/foo", xml, "application/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((String)"no workspace", (Object)this.getCatalog().getStyleByName("foo"));
        Assert.assertNull((String)"no workspace", (Object)this.getCatalog().getStyleByName("foo").getWorkspace());
        Assert.assertNotNull((Object)this.getCatalog().getStyleByName("foo").getDateModified());
    }

    @Test
    public void testPutRenameDefault() throws Exception {
        StyleInfo style = catalog.getStyleByName("Ponds");
        Assert.assertEquals((Object)"Ponds.sld", (Object)style.getFilename());
        String xml = "<style><name>Ponds</name><filename>Forests.sld</filename></style>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/line", xml.getBytes(), "text/xml");
        Assert.assertEquals((long)500L, (long)response.getStatus());
    }

    @Test
    public void testPutAsSLDNamedLayer() throws Exception {
        String xml = "<StyledLayerDescriptor version='1.0.0'  xsi:schemaLocation='http://www.opengis.net/sld StyledLayerDescriptor.xsd'  xmlns='http://www.opengis.net/sld'  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <NamedLayer>\n    <Name>Streams</Name>\n  </NamedLayer>\n  <NamedLayer>\n    <Name>RoadSegments</Name>\n  </NamedLayer>\n</StyledLayerDescriptor>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds", xml, "application/vnd.ogc.sld+xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((Object)catalog.getStyleByName("Ponds"));
        Assert.assertNotNull((Object)catalog.getStyleByName("Ponds").getDateModified());
    }

    @Test
    public void testPutAsSLDNamedLayerInvalid() throws Exception {
        String xml = "<StyledLayerDescriptor version='1.0.0'  xsi:schemaLocation='http://www.opengis.net/sld StyledLayerDescriptor.xsd'  xmlns='http://www.opengis.net/sld'  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <NamedLayer>\n    <Name>Stream</Name>\n  </NamedLayer>\n  <NamedLayer>\n    <Name>Streams</Name>\n  </NamedLayer>\n</StyledLayerDescriptor>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/Ponds", xml, "application/vnd.ogc.sld+xml");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"Invalid style:No layer or layer group named 'Stream' found in the catalog", (Object)response.getContentAsString());
    }

    @Test
    public void testStyleNotFoundGloballyWhenInWorkspace() throws Exception {
        this.testPostToWorkspace();
        Catalog cat = this.getCatalog();
        Assert.assertEquals((Object)"foo.sld", (Object)cat.getStyleByName("gs", "foo").getFilename());
        String xml = "<style><filename>bar.sld</filename></style>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/styles/foo", xml, "application/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = this.putAsServletResponse("/rest/styles/gs:foo", xml, "application/xml");
        Assert.assertEquals((long)500L, (long)response.getStatus());
    }

    @Test
    public void testDelete() throws Exception {
        String xml = "<style><name>dummy</name><filename>dummy.sld</filename></style>";
        this.post("/rest/styles", xml, "text/xml");
        Assert.assertNotNull((Object)catalog.getStyleByName("dummy"));
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/styles/dummy");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNull((Object)catalog.getStyleByName("dummy"));
    }

    @Test
    public void testDeleteDefault() throws Exception {
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/styles/line");
        Assert.assertEquals((long)500L, (long)response.getStatus());
    }

    @Test
    public void testDeleteWithLayerReference() throws Exception {
        Assert.assertNotNull((Object)catalog.getStyleByName("Ponds"));
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/styles/Ponds");
        Assert.assertEquals((long)403L, (long)response.getStatus());
        Assert.assertNotNull((Object)catalog.getStyleByName("Ponds"));
    }

    @Test
    public void testDeleteWithLayerReferenceAndRecurse() throws Exception {
        Assert.assertNotNull((Object)catalog.getStyleByName("Ponds"));
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/styles/Ponds?recurse=true");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNull((Object)catalog.getStyleByName("Ponds"));
    }

    @Test
    public void testDeleteWithoutPurge() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles", xml, "application/vnd.ogc.sld+xml");
        Assert.assertNotNull((Object)catalog.getStyleByName("foo"));
        Assert.assertTrue((boolean)new File(Resources.directory((Resource)this.getDataDirectory().getStyles(new String[0])), "foo.sld").exists());
        response = this.deleteAsServletResponse("/rest/styles/foo");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertFalse((boolean)new File(Resources.directory((Resource)this.getDataDirectory().getStyles(new String[0])), "foo.sld").exists());
        Assert.assertTrue((boolean)new File(Resources.directory((Resource)this.getDataDirectory().getStyles(new String[0])), "foo.sld.bak").exists());
    }

    @Test
    public void testDeleteWithPurge() throws Exception {
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles", xml, "application/vnd.ogc.sld+xml");
        Assert.assertNotNull((Object)catalog.getStyleByName("foo"));
        Assert.assertTrue((boolean)new File(Resources.directory((Resource)this.getDataDirectory().getStyles(new String[0])), "foo.sld").exists());
        response = this.deleteAsServletResponse("/rest/styles/foo?purge=true");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertFalse((boolean)new File(Resources.directory((Resource)this.getDataDirectory().getStyles(new String[0])), "foo.sld").exists());
    }

    @Test
    public void testDeleteFromWorkspace() throws Exception {
        this.testPostToWorkspace();
        Catalog cat = this.getCatalog();
        Assert.assertNotNull((Object)cat.getStyleByName("gs", "foo"));
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/gs/styles/foo.xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNull((Object)cat.getStyleByName("gs", "foo"));
    }

    @Test
    public void testDeleteFromWorkspaceWithPurge() throws Exception {
        this.testPostAsSLDToWorkspace();
        Catalog cat = this.getCatalog();
        Assert.assertNotNull((Object)cat.getStyleByName("gs", "foo"));
        GeoServerResourceLoader rl = this.getResourceLoader();
        Assert.assertNotNull((Object)rl.find(new String[]{"workspaces", "gs", "styles", "foo.sld"}));
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/gs/styles/foo?purge=true");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNull((Object)cat.getStyleByName("gs", "foo"));
        Assert.assertNull((Object)rl.find(new String[]{"workspaces", "gs", "styles", "foo.sld"}));
    }

    @Test
    public void testGetAllByLayer() throws Exception {
        Document dom = this.getAsDOM("/rest/layers/cite:BasicPolygons/styles.xml");
        LayerInfo layer = catalog.getLayerByName("cite:BasicPolygons");
        XMLAssert.assertXpathEvaluatesTo((String)("" + layer.getStyles().size()), (String)"count(//style)", (Document)dom);
    }

    @Test
    public void testPostByLayer() throws Exception {
        LayerInfo l = catalog.getLayerByName("cite:BasicPolygons");
        int nstyles = l.getStyles().size();
        String xml = "<style><name>Ponds</name></style>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layers/cite:BasicPolygons/styles", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"text/plain"));
        LayerInfo l2 = catalog.getLayerByName("cite:BasicPolygons");
        Assert.assertEquals((long)(nstyles + 1), (long)l2.getStyles().size());
        Assert.assertTrue((boolean)l2.getStyles().contains(catalog.getStyleByName("Ponds")));
    }

    @Test
    public void testPostByLayerWithDefault() throws Exception {
        ((SystemTestData)this.getTestData()).addVectorLayer(SystemTestData.BASIC_POLYGONS, this.getCatalog());
        LayerInfo l = catalog.getLayerByName("cite:BasicPolygons");
        int nstyles = l.getStyles().size();
        String xml = "<style><name>Ponds</name></style>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layers/cite:BasicPolygons/styles?default=true", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"text/plain"));
        LayerInfo l2 = catalog.getLayerByName("cite:BasicPolygons");
        Assert.assertEquals((long)(nstyles + 1), (long)l2.getStyles().size());
        Assert.assertEquals((Object)catalog.getStyleByName("Ponds"), (Object)l2.getDefaultStyle());
        Assert.assertNotNull((Object)l2.getDefaultStyle().getDateModified());
    }

    @Test
    public void testPostByLayerExistingWithDefault() throws Exception {
        ((SystemTestData)this.getTestData()).addVectorLayer(SystemTestData.BASIC_POLYGONS, this.getCatalog());
        this.testPostByLayer();
        LayerInfo l = catalog.getLayerByName("cite:BasicPolygons");
        int nstyles = l.getStyles().size();
        String xml = "<style><name>Ponds</name></style>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layers/cite:BasicPolygons/styles?default=true", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"text/plain"));
        LayerInfo l2 = catalog.getLayerByName("cite:BasicPolygons");
        Assert.assertEquals((long)nstyles, (long)l2.getStyles().size());
        Assert.assertEquals((Object)catalog.getStyleByName("Ponds"), (Object)l2.getDefaultStyle());
        Assert.assertNotNull((Object)l2.getDefaultStyle().getDateModified());
    }

    @Test
    @Ignore
    public void testPostAsPSL() throws Exception {
        Properties props = new Properties();
        props.put("type", "point");
        props.put("color", "ff0000");
        StringWriter out = new StringWriter();
        props.store(out, "comment!");
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles?name=foo", out.toString(), "application/prs.gs.psl");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/styles/foo"));
        Assert.assertNotNull((Object)catalog.getStyleByName("foo"));
        Assert.assertNotNull((Object)catalog.getStyleByName("foo").getDateCreated());
        Resource style = this.getDataDirectory().style(this.getCatalog().getStyleByName("foo"));
        props = new Properties();
        try (InputStream in = style.in();){
            props.load(in);
            Assert.assertEquals((Object)"point", (Object)props.getProperty("type"));
        }
        in = style.in();
        try {
            out = new StringWriter();
            IOUtils.copy((InputStream)in, (Writer)out, (String)"UTF-8");
            Assert.assertFalse((boolean)out.toString().startsWith("#comment!"));
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Test
    @Ignore
    public void testPostAsPSLRaw() throws Exception {
        Properties props = new Properties();
        props.put("type", "point");
        props.put("color", "ff0000");
        StringWriter out = new StringWriter();
        props.store(out, "comment!");
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles?name=foo&raw=true", out.toString(), "application/prs.gs.psl");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/styles/foo"));
        Resource style = this.getDataDirectory().style(this.getCatalog().getStyleByName("foo"));
        try (InputStream in = style.in();){
            out = new StringWriter();
            IOUtils.copy((InputStream)in, (Writer)out, (String)"UTF-8");
            Assert.assertTrue((boolean)out.toString().startsWith("#comment!"));
        }
    }

    @Test
    @Ignore
    public void testGetAsPSL() throws Exception {
        Properties props = new Properties();
        props.load(this.get("/rest/styles/Ponds.properties"));
        Assert.assertEquals((Object)"polygon", (Object)props.getProperty("type"));
    }

    @Test
    @Ignore
    public void testPutAsPSL() throws Exception {
        this.testPostAsPSL();
        Properties props = new Properties();
        props.put("type", "line");
        props.put("color", "00ff00");
        StringWriter out = new StringWriter();
        props.store(out, "comment!");
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/foo", out.toString(), "application/prs.gs.psl");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Resource style = this.getDataDirectory().style(this.getCatalog().getStyleByName("foo"));
        try (InputStream in = style.in();){
            props = new Properties();
            props.load(in);
            Assert.assertEquals((Object)"line", (Object)props.getProperty("type"));
        }
        in = style.in();
        try {
            out = new StringWriter();
            IOUtils.copy((InputStream)in, (Writer)out, (String)"UTF-8");
            Assert.assertFalse((boolean)out.toString().startsWith("#comment!"));
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Test
    @Ignore
    public void testPutAsPSLRaw() throws Exception {
        this.testPostAsPSL();
        Properties props = new Properties();
        props.put("type", "line");
        props.put("color", "00ff00");
        StringWriter out = new StringWriter();
        props.store(out, "comment!");
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/foo?raw=true", out.toString(), "application/prs.gs.psl");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Resource style = this.getDataDirectory().style(this.getCatalog().getStyleByName("foo"));
        try (InputStream in = style.in();){
            props = new Properties();
            props.load(in);
            Assert.assertEquals((Object)"line", (Object)props.getProperty("type"));
        }
        in = style.in();
        try {
            out = new StringWriter();
            IOUtils.copy((InputStream)in, (Writer)out, (String)"UTF-8");
            Assert.assertTrue((boolean)out.toString().startsWith("#comment!"));
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Test
    public void testPostAsSE() throws Exception {
        String xml = "<StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\"        xmlns:se=\"http://www.opengis.net/se\" version=\"1.1.0\">  <NamedLayer>   <UserStyle>    <se:Name>UserSelection</se:Name>    <se:FeatureTypeStyle>     <se:Rule>      <se:PolygonSymbolizer>       <se:Fill>        <se:SvgParameter name=\"fill\">#FF0000</se:SvgParameter>       </se:Fill>      </se:PolygonSymbolizer>     </se:Rule>    </se:FeatureTypeStyle>   </UserStyle>  </NamedLayer> </StyledLayerDescriptor>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles?name=foo", xml, "application/vnd.ogc.se+xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/styles/foo"));
        StyleInfo style = catalog.getStyleByName("foo");
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((Object)"sld", (Object)style.getFormat());
        Assert.assertEquals((Object)SLDHandler.VERSION_11, (Object)style.getFormatVersion());
        Assert.assertNotNull((Object)style.getDateCreated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostToWorkspaceSLDPackage() throws Exception {
        File testTemp = new File("./target/sld-temp");
        testTemp.mkdirs();
        StyleController.TEMP_DIR_ROOT = testTemp.toPath();
        try {
            Catalog cat = this.getCatalog();
            Assert.assertNull((Object)cat.getStyleByName("gs", "foo"));
            URL zip = ((Object)((Object)this)).getClass().getResource("test-data/foo.zip");
            byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)zip));
            int initialSize = testTemp.listFiles(f -> f.getName().startsWith("_sld")).length;
            MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/styles", bytes, "application/zip");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
            Assert.assertNotNull((Object)cat.getStyleByName("gs", "foo"));
            Assert.assertNotNull((Object)cat.getStyleByName("gs", "foo").getDateCreated());
            Document d = this.getAsDOM("/rest/workspaces/gs/styles/foo.sld");
            Assert.assertEquals((Object)"StyledLayerDescriptor", (Object)d.getDocumentElement().getNodeName());
            XpathEngine engine = XMLUnit.newXpathEngine();
            NodeList list = engine.getMatchingNodes("//sld:StyledLayerDescriptor/sld:NamedLayer/sld:UserStyle/sld:FeatureTypeStyle/sld:Rule/sld:PointSymbolizer/sld:Graphic/sld:ExternalGraphic/sld:OnlineResource", d);
            Assert.assertEquals((long)1L, (long)list.getLength());
            Element onlineResource = (Element)list.item(0);
            Assert.assertEquals((Object)"gear.png", (Object)onlineResource.getAttribute("xlink:href"));
            Assert.assertNotNull((Object)this.getCatalog().getResourceLoader().find("workspaces/gs/styles/gear.png"));
            Assert.assertNotNull((Object)this.getCatalog().getResourceLoader().find("workspaces/gs/styles/foo.sld"));
            int finalSize = testTemp.listFiles(f -> f.getName().startsWith("_sld")).length;
            Assert.assertEquals((long)initialSize, (long)finalSize);
        }
        finally {
            StyleController.TEMP_DIR_ROOT = null;
        }
    }

    @Test
    public void testPostWithExternalEntities() throws Exception {
        URL zip = ((Object)((Object)this)).getClass().getResource("test-data/externalEntities.zip");
        byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)zip));
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/styles", bytes, "application/zip");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        String content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed"));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"/this/file/does/not/exist"));
    }

    @Test
    public void testPostSLDPackageWithBMPIcon() throws Exception {
        URL zip = ((Object)((Object)this)).getClass().getResource("parking_bmp.zip");
        byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)zip));
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles?name=parking", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        GeoServerResourceLoader loader = this.getCatalog().getResourceLoader();
        Assert.assertNotNull((String)"parking.sld not found", (Object)loader.find("styles/parking.sld"));
        Assert.assertNotNull((String)"parking.bmp not found", (Object)loader.find("styles/parking.bmp"));
    }

    @Test
    public void testPutToWorkspaceSLDPackage() throws Exception {
        this.testPostAsSLDToWorkspace();
        Catalog cat = this.getCatalog();
        Assert.assertNotNull((Object)cat.getStyleByName("gs", "foo"));
        URL zip = ((Object)((Object)this)).getClass().getResource("test-data/foo.zip");
        byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)zip));
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/styles/foo", bytes, "application/zip");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((Object)cat.getStyleByName("gs", "foo"));
        Assert.assertNotNull((Object)cat.getStyleByName("gs", "foo").getDateCreated());
        Document d = this.getAsDOM("/rest/workspaces/gs/styles/foo.sld");
        Assert.assertEquals((Object)"StyledLayerDescriptor", (Object)d.getDocumentElement().getNodeName());
        XpathEngine engine = XMLUnit.newXpathEngine();
        NodeList list = engine.getMatchingNodes("//sld:StyledLayerDescriptor/sld:NamedLayer/sld:UserStyle/sld:FeatureTypeStyle/sld:Rule/sld:PointSymbolizer/sld:Graphic/sld:ExternalGraphic/sld:OnlineResource", d);
        Assert.assertEquals((long)1L, (long)list.getLength());
        Element onlineResource = (Element)list.item(0);
        Assert.assertEquals((Object)"gear.png", (Object)onlineResource.getAttribute("xlink:href"));
        Assert.assertNotNull((Object)this.getCatalog().getResourceLoader().find("workspaces/gs/styles/gear.png"));
        Assert.assertNotNull((Object)this.getCatalog().getResourceLoader().find("workspaces/gs/styles/foo.sld"));
    }

    @Test
    public void testPostSLDPackage() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getStyleByName("foo"));
        URL zip = ((Object)((Object)this)).getClass().getResource("test-data/foo.zip");
        byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)zip));
        MockHttpServletResponse response = this.postAsServletResponse("/rest/styles", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)cat.getStyleByName("foo"));
        Assert.assertNotNull((Object)cat.getStyleByName("foo").getDateCreated());
        Document d = this.getAsDOM("/rest/styles/foo.sld");
        Assert.assertEquals((Object)"StyledLayerDescriptor", (Object)d.getDocumentElement().getNodeName());
        XpathEngine engine = XMLUnit.newXpathEngine();
        NodeList list = engine.getMatchingNodes("//sld:StyledLayerDescriptor/sld:NamedLayer/sld:UserStyle/sld:FeatureTypeStyle/sld:Rule/sld:PointSymbolizer/sld:Graphic/sld:ExternalGraphic/sld:OnlineResource", d);
        Assert.assertEquals((long)1L, (long)list.getLength());
        Element onlineResource = (Element)list.item(0);
        Assert.assertEquals((Object)"gear.png", (Object)onlineResource.getAttribute("xlink:href"));
        Assert.assertNotNull((Object)this.getCatalog().getResourceLoader().find("styles/gear.png"));
        Assert.assertNotNull((Object)this.getCatalog().getResourceLoader().find("styles/foo.sld"));
    }

    @Test
    public void testPutSLDPackage() throws Exception {
        this.testPostAsSLD();
        Catalog cat = this.getCatalog();
        Assert.assertNotNull((Object)cat.getStyleByName("foo"));
        URL zip = ((Object)((Object)this)).getClass().getResource("test-data/foo.zip");
        byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)zip));
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/foo", bytes, "application/zip");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNotNull((Object)cat.getStyleByName("foo"));
        Assert.assertNotNull((Object)cat.getStyleByName("foo").getDateModified());
        Document d = this.getAsDOM("/rest/styles/foo.sld");
        Assert.assertEquals((Object)"StyledLayerDescriptor", (Object)d.getDocumentElement().getNodeName());
        XpathEngine engine = XMLUnit.newXpathEngine();
        NodeList list = engine.getMatchingNodes("//sld:StyledLayerDescriptor/sld:NamedLayer/sld:UserStyle/sld:FeatureTypeStyle/sld:Rule/sld:PointSymbolizer/sld:Graphic/sld:ExternalGraphic/sld:OnlineResource", d);
        Assert.assertEquals((long)1L, (long)list.getLength());
        Element onlineResource = (Element)list.item(0);
        Assert.assertEquals((Object)"gear.png", (Object)onlineResource.getAttribute("xlink:href"));
        Assert.assertNotNull((Object)this.getCatalog().getResourceLoader().find("styles/gear.png"));
        Assert.assertNotNull((Object)this.getCatalog().getResourceLoader().find("styles/foo.sld"));
    }

    @Test
    public void testUpdateSLD11With10() throws Exception {
        this.testPostAsSLD11();
        StyleInfo style11 = catalog.getStyleByName("foo");
        Assert.assertEquals((Object)new Version("1.1.0"), (Object)style11.getFormatVersion());
        String xml = this.newSLDXML();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/styles/foo", xml, "application/vnd.ogc.sld+xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        StyleInfo style10 = catalog.getStyleByName("foo");
        Assert.assertEquals((Object)new Version("1.0.0"), (Object)style10.getFormatVersion());
    }

    protected MockHttpServletResponse putAsServletResponse(String path, byte[] body, String contentType, String accepts) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("PUT");
        request.setContentType(contentType);
        request.setContent(body);
        request.addHeader("Accept", (Object)accepts);
        request.addHeader("Content-type", (Object)contentType);
        return this.dispatch((HttpServletRequest)request);
    }
}

