/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.io.IOException;
import java.text.MessageFormat;
import net.sf.json.JSONObject;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.rest.security.SecurityRESTTestSupport;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class MasterPasswordControllerTest
extends SecurityRESTTestSupport {
    static final String MP_URI_JSON = "/rest/security/masterpw.json";
    static final String MP_URI_XML = "/rest/security/masterpw.xml";
    String xmlTemplate = "<masterPassword><oldMasterPassword>{0}</oldMasterPassword><newMasterPassword>{1}</newMasterPassword></masterPassword>";
    String jsonTemplate = "{\"oldMasterPassword\":\"%s\",\"newMasterPassword\":\"%s\"}";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        MasterPasswordProviderConfig masterPasswordConfig = this.getSecurityManager().loadMasterPassswordProviderConfig(this.getSecurityManager().getMasterPasswordConfig().getProviderName());
        masterPasswordConfig.setLoginEnabled(true);
        this.getSecurityManager().saveMasterPasswordProviderConfig(masterPasswordConfig);
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM(MP_URI_XML, 200);
        Assert.assertEquals((Object)"masterPassword", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"geoserver", (Object)xp.evaluate("/masterPassword/oldMasterPassword", dom));
    }

    @Test
    public void testGetAsXMLNotAuthorized() throws Exception {
        this.logout();
        Assert.assertEquals((long)403L, (long)this.getAsServletResponse(MP_URI_XML).getStatus());
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON(MP_URI_JSON);
        String password = (String)json.get("oldMasterPassword");
        Assert.assertEquals((Object)"geoserver", (Object)password);
    }

    @Test
    public void testUnallowedMethod() throws Exception {
        boolean failed = false;
        try {
            this.getSecurityManager().getMasterPasswordForREST();
        }
        catch (IOException ex) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
    }

    @Test
    public void testPutUnauthorized() throws Exception {
        this.logout();
        String body = MessageFormat.format(this.xmlTemplate, "geoserver", "abc");
        Assert.assertEquals((long)405L, (long)this.putAsServletResponse(MP_URI_XML, body, "text/xml").getStatus());
    }

    @Test
    public void testPutInvalidNewPassword() throws Exception {
        String body = MessageFormat.format(this.xmlTemplate, "geoserver", "abc");
        Assert.assertEquals((long)422L, (long)this.putAsServletResponse(MP_URI_XML, body, "text/xml").getStatus());
    }

    @Test
    public void testPutInvalidCurrentPassword() throws Exception {
        String body = MessageFormat.format(this.xmlTemplate, "geoserverXY", "geoserver1");
        Assert.assertEquals((long)422L, (long)this.putAsServletResponse(MP_URI_XML, body, "text/xml").getStatus());
    }

    @Test
    public void testPutAsXML() throws Exception {
        String body = MessageFormat.format(this.xmlTemplate, "geoserver", "geoserver1");
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(MP_URI_XML, body, "text/xml").getStatus());
        Assert.assertTrue((boolean)this.getSecurityManager().checkMasterPassword("geoserver1"));
        body = MessageFormat.format(this.xmlTemplate, "geoserver1", "geoserver");
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(MP_URI_XML, body, "text/xml").getStatus());
        Assert.assertTrue((boolean)this.getSecurityManager().checkMasterPassword("geoserver"));
    }

    @Test
    public void testPutAsJSON() throws Exception {
        String body = String.format(this.jsonTemplate, "geoserver", "geoserver1");
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(MP_URI_JSON, body, "text/json").getStatus());
        Assert.assertTrue((boolean)this.getSecurityManager().checkMasterPassword("geoserver1"));
        body = String.format(this.jsonTemplate, "geoserver1", "geoserver");
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(MP_URI_JSON, body, "text/json").getStatus());
        Assert.assertTrue((boolean)this.getSecurityManager().checkMasterPassword("geoserver"));
    }
}

