/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.io.IOException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.security.RolesRestController;
import org.geoserver.rest.security.UsersRestController;
import org.geoserver.rest.security.xml.JaxbGroupList;
import org.geoserver.rest.security.xml.JaxbRoleList;
import org.geoserver.rest.security.xml.JaxbUser;
import org.geoserver.rest.security.xml.JaxbUserList;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.test.GeoServerTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.HttpStatus;

public class UserRoleRestControllerTest
extends GeoServerTestSupport {
    private static final String USER_SERVICE = "default";
    protected UsersRestController usersController;
    protected RolesRestController rolesController;

    @Before
    public void oneTimeSetUp() throws Exception {
        this.setValidating(true);
        super.oneTimeSetUp();
        this.usersController = (UsersRestController)applicationContext.getBean(UsersRestController.class);
        this.rolesController = (RolesRestController)applicationContext.getBean(RolesRestController.class);
    }

    @Test
    public void testRolesAndUsers() throws PasswordPolicyException, IOException {
        JaxbUser user = new JaxbUser();
        user.setUserName("pipo");
        user.setPassword("secret");
        user.setEnabled(Boolean.valueOf(true));
        this.usersController.insertUser(USER_SERVICE, user);
        this.usersController.insertGroup(USER_SERVICE, "clowns");
        this.usersController.insertGroup(USER_SERVICE, "circus");
        this.usersController.associateUserToGroup(USER_SERVICE, "pipo", "clowns");
        this.usersController.associateUserToGroup(USER_SERVICE, "pipo", "circus");
        JaxbUserList users = this.usersController.getUsers(USER_SERVICE);
        boolean found = false;
        for (Object u : users.getUsers()) {
            if (!"pipo".equals(u.getUserName())) continue;
            Assert.assertTrue((boolean)u.isEnabled());
            found = true;
        }
        Assert.assertTrue((boolean)found);
        users = this.usersController.getUsersFromGroup(USER_SERVICE, "clowns");
        found = false;
        for (Object u : users.getUsers()) {
            if (!"pipo".equals(u.getUserName())) continue;
            Assert.assertTrue((boolean)u.isEnabled());
            found = true;
        }
        Assert.assertTrue((boolean)found);
        JaxbGroupList groups = this.usersController.getGroupsFromUser(USER_SERVICE, "pipo");
        Assert.assertEquals((long)2L, (long)groups.getGroups().size());
        Assert.assertTrue((boolean)groups.getGroups().contains("clowns"));
        Assert.assertTrue((boolean)groups.getGroups().contains("circus"));
        this.usersController.disassociateUserFromGroup(USER_SERVICE, "pipo", "circus");
        groups = this.usersController.getGroupsFromUser(USER_SERVICE, "pipo");
        Assert.assertEquals((long)1L, (long)groups.getGroups().size());
        Assert.assertTrue((boolean)groups.getGroups().contains("clowns"));
        Assert.assertFalse((boolean)groups.getGroups().contains("circus"));
        this.usersController.deleteGroup(USER_SERVICE, "circus");
        Assert.assertEquals((long)1L, (long)groups.getGroups().size());
        Assert.assertTrue((boolean)groups.getGroups().contains("clowns"));
        Assert.assertFalse((boolean)groups.getGroups().contains("circus"));
        user = new JaxbUser();
        user.setEnabled(Boolean.valueOf(false));
        this.usersController.updateUser(USER_SERVICE, "pipo", user);
        users = this.usersController.getUsers(USER_SERVICE);
        found = false;
        for (Object u : users.getUsers()) {
            if (!"pipo".equals(u.getUserName())) continue;
            Assert.assertFalse((boolean)u.isEnabled());
            found = true;
        }
        Assert.assertTrue((boolean)found);
        this.rolesController.insert("vozen");
        this.rolesController.insert("kwiestenbiebel");
        users = this.usersController.getUsers(USER_SERVICE);
        JaxbRoleList roles = this.rolesController.get();
        Assert.assertTrue((boolean)roles.getRoles().contains("vozen"));
        Assert.assertTrue((boolean)roles.getRoles().contains("kwiestenbiebel"));
        this.rolesController.associateUser("vozen", "pipo");
        this.rolesController.associateUser("kwiestenbiebel", "pipo");
        roles = this.rolesController.getUser("pipo");
        Assert.assertEquals((long)2L, (long)roles.getRoles().size());
        Assert.assertTrue((boolean)roles.getRoles().contains("vozen"));
        Assert.assertTrue((boolean)roles.getRoles().contains("kwiestenbiebel"));
        this.rolesController.disassociateUser("kwiestenbiebel", "pipo");
        roles = this.rolesController.getUser("pipo");
        Assert.assertEquals((long)1L, (long)roles.getRoles().size());
        Assert.assertTrue((boolean)roles.getRoles().contains("vozen"));
        Assert.assertFalse((boolean)roles.getRoles().contains("kwiestenbiebel"));
        this.rolesController.delete("kwiestenbiebel");
        Assert.assertEquals((long)1L, (long)roles.getRoles().size());
        Assert.assertTrue((boolean)roles.getRoles().contains("vozen"));
        Assert.assertFalse((boolean)roles.getRoles().contains("kwiestenbiebel"));
        this.usersController.deleteUser(USER_SERVICE, "pipo");
        users = this.usersController.getUsers(USER_SERVICE);
        found = false;
        for (JaxbUser u : users.getUsers()) {
            if (!"pipo".equals(u.getUserName())) continue;
            found = true;
        }
        Assert.assertFalse((boolean)found);
        boolean notfound = false;
        try {
            this.usersController.getUsers("blabla");
        }
        catch (IllegalArgumentException e) {
            notfound = true;
        }
        Assert.assertTrue((boolean)notfound);
        notfound = false;
        try {
            this.usersController.getGroupsFromUser(USER_SERVICE, "niemand");
        }
        catch (IllegalArgumentException e) {
            notfound = true;
        }
        Assert.assertTrue((boolean)notfound);
        notfound = false;
        try {
            this.usersController.getUsersFromGroup(USER_SERVICE, "onbestaand");
        }
        catch (IllegalArgumentException e) {
            notfound = true;
        }
        Assert.assertTrue((boolean)notfound);
        notfound = false;
        try {
            this.rolesController.delete("onbestaand");
        }
        catch (IllegalArgumentException e) {
            notfound = true;
        }
        Assert.assertTrue((boolean)notfound);
    }

    @Test
    public void testUserRolesEndpoint() throws Exception {
        String userXML = this.getAsString("rest/security/roles/user/admin.xml");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><roles><role>ADMIN</role></roles>", (Object)userXML.trim());
    }

    @Test
    public void testRolesEndpoint() throws Exception {
        String userXML = this.getAsString("rest/security/roles");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><roles><role>ADMIN</role><role>GROUP_ADMIN</role></roles>", (Object)userXML.trim());
    }

    @Test
    public void testUserEndpoint() throws Exception {
        String userXML = this.getAsString("rest/security/usergroup/service/default/users");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><users><user><enabled>true</enabled><userName>admin</userName></user></users>", (Object)userXML.trim());
    }

    @Test
    public void testGroupEndpoint() throws Exception {
        this.usersController.insertGroup(USER_SERVICE, "clowns");
        this.usersController.insertGroup(USER_SERVICE, "circus");
        String userXML = this.getAsString("rest/security/usergroup/service/default/groups");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><groups><group>circus</group><group>clowns</group></groups>", (Object)userXML.trim());
    }

    @Test
    public void testGroups() throws PasswordPolicyException, IOException {
        JaxbUser user = new JaxbUser();
        user.setUserName("pipo");
        user.setPassword("secret");
        user.setEnabled(Boolean.valueOf(true));
        this.usersController.insertUser(USER_SERVICE, user);
        this.usersController.insertGroup(USER_SERVICE, "clowns");
        this.usersController.insertGroup(USER_SERVICE, "circus");
        this.usersController.associateUserToGroup(USER_SERVICE, "pipo", "clowns");
        this.usersController.associateUserToGroup(USER_SERVICE, "pipo", "circus");
        this.rolesController.insert("vozen");
        this.rolesController.insert("kwiestenbiebel");
        JaxbRoleList roles = this.rolesController.get();
        Assert.assertTrue((boolean)roles.getRoles().contains("vozen"));
        Assert.assertTrue((boolean)roles.getRoles().contains("kwiestenbiebel"));
        this.rolesController.associateGroup("vozen", "clowns");
        this.rolesController.associateGroup("kwiestenbiebel", "clowns");
        roles = this.rolesController.getGroup("clowns");
        Assert.assertEquals((long)2L, (long)roles.getRoles().size());
        Assert.assertTrue((boolean)roles.getRoles().contains("vozen"));
        Assert.assertTrue((boolean)roles.getRoles().contains("kwiestenbiebel"));
        this.rolesController.disassociateGroup("kwiestenbiebel", "clowns");
        roles = this.rolesController.getGroup("clowns");
        Assert.assertEquals((long)1L, (long)roles.getRoles().size());
        Assert.assertTrue((boolean)roles.getRoles().contains("vozen"));
        Assert.assertFalse((boolean)roles.getRoles().contains("kwiestenbiebel"));
        this.rolesController.associateGroup(USER_SERVICE, "vozen", "circus");
        this.rolesController.associateGroup(USER_SERVICE, "kwiestenbiebel", "circus");
        roles = this.rolesController.getGroup(USER_SERVICE, "circus");
        Assert.assertEquals((long)2L, (long)roles.getRoles().size());
        Assert.assertTrue((boolean)roles.getRoles().contains("vozen"));
        Assert.assertTrue((boolean)roles.getRoles().contains("kwiestenbiebel"));
        this.rolesController.disassociateGroup(USER_SERVICE, "kwiestenbiebel", "circus");
        roles = this.rolesController.getGroup(USER_SERVICE, "circus");
        Assert.assertEquals((long)1L, (long)roles.getRoles().size());
        Assert.assertTrue((boolean)roles.getRoles().contains("vozen"));
        Assert.assertFalse((boolean)roles.getRoles().contains("kwiestenbiebel"));
    }

    @Test
    public void testDoubleUserGroupAssociation() throws PasswordPolicyException, IOException {
        JaxbUser user = new JaxbUser();
        user.setUserName("pipo");
        user.setPassword("secret");
        user.setEnabled(Boolean.valueOf(true));
        this.usersController.insertUser(USER_SERVICE, user);
        this.usersController.insertGroup(USER_SERVICE, "clowns");
        this.usersController.associateUserToGroup(USER_SERVICE, "pipo", "clowns");
        RestException exception = (RestException)Assert.assertThrows(RestException.class, () -> this.usersController.associateUserToGroup(USER_SERVICE, "pipo", "clowns"));
        Assert.assertEquals((Object)"Username already associated with this groupname", (Object)exception.getMessage());
        Assert.assertEquals((Object)HttpStatus.OK, (Object)exception.getStatus());
    }
}

