/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import freemarker.template.ObjectWrapper;
import java.lang.reflect.Type;
import java.util.Collections;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.SettingsInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.rest.AbstractGeoServerController;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/workspaces/{workspaceName}/settings"})
public class LocalSettingsController
extends AbstractGeoServerController {
    @Autowired
    public LocalSettingsController(@Qualifier(value="geoServer") GeoServer geoServer) {
        super(geoServer);
    }

    @GetMapping(produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<SettingsInfo> localSettingsGet(@PathVariable String workspaceName) {
        WorkspaceInfo workspaceInfo = this.geoServer.getCatalog().getWorkspaceByName(workspaceName);
        SettingsInfo settingsInfo = this.geoServer.getSettings(workspaceInfo);
        if (settingsInfo == null) {
            settingsInfo = new SettingsInfoImpl();
            settingsInfo.setVerbose(false);
        }
        return this.wrapObject(settingsInfo, SettingsInfo.class);
    }

    @PostMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public String localSettingsCreate(@PathVariable String workspaceName, @RequestBody SettingsInfo settingsInfo) {
        String name = "";
        if (workspaceName != null) {
            Catalog catalog = this.geoServer.getCatalog();
            WorkspaceInfo workspaceInfo = catalog.getWorkspaceByName(workspaceName);
            settingsInfo.setWorkspace(workspaceInfo);
            this.geoServer.add(settingsInfo);
            this.geoServer.save(this.geoServer.getSettings(workspaceInfo));
            name = settingsInfo.getWorkspace().getName();
        }
        return name;
    }

    @PutMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void localSettingsPut(@PathVariable String workspaceName, @RequestBody SettingsInfo settingsInfo) {
        if (workspaceName != null) {
            WorkspaceInfo workspaceInfo = this.geoServer.getCatalog().getWorkspaceByName(workspaceName);
            SettingsInfo original = this.geoServer.getSettings(workspaceInfo);
            if (original == null) {
                settingsInfo.setWorkspace(workspaceInfo);
                this.geoServer.add(settingsInfo);
                this.geoServer.save(this.geoServer.getSettings(workspaceInfo));
            } else {
                OwsUtils.copy((Object)settingsInfo, (Object)original, SettingsInfo.class);
                original.setWorkspace(workspaceInfo);
                this.geoServer.save(original);
            }
        }
    }

    @DeleteMapping
    public void localSetingsDelete(@PathVariable String workspaceName) {
        if (workspaceName != null) {
            WorkspaceInfo workspaceInfo = this.geoServer.getCatalog().getWorkspaceByName(workspaceName);
            SettingsInfo settingsInfo = this.geoServer.getSettings(workspaceInfo);
            this.geoServer.remove(settingsInfo);
        }
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return SettingsInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    protected String getTemplateName(Object object) {
        return "localSettings";
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper(clazz, Collections.singletonList(WorkspaceInfo.class));
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        persister.setHideFeatureTypeAttributes();
        persister.getXStream().alias("contact", ContactInfo.class);
    }
}

