/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.IOException;
import org.geoserver.rest.catalog.FeatureCollectionConverter;
import org.geoserver.rest.catalog.FormatCollectionWrapper;
import org.geoserver.rest.util.MediaTypeExtensions;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class FormatCollectionWrapperConverter
extends FeatureCollectionConverter<FormatCollectionWrapper> {
    public FormatCollectionWrapperConverter() {
        super(MediaType.APPLICATION_XML, MediaType.TEXT_XML, MediaTypeExtensions.TEXT_JSON, MediaType.APPLICATION_JSON);
    }

    protected void writeInternal(FormatCollectionWrapper content, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        MediaType mediaType = outputMessage.getHeaders().getContentType();
        if (MediaType.APPLICATION_JSON.includes(mediaType) || MediaTypeExtensions.TEXT_JSON.includes(mediaType)) {
            this.writeGeoJson(content.getCollection(), outputMessage);
        } else if (MediaType.APPLICATION_XML.includes(mediaType) || MediaTypeExtensions.TEXT_JSON.includes(mediaType)) {
            this.writeGML(content.getCollection(), outputMessage);
        }
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return FormatCollectionWrapper.class.isAssignableFrom(clazz);
    }
}

