/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.IOException;
import org.geoserver.config.util.SecureXStream;
import org.geoserver.rest.catalog.StringsList;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class StringsListXMLConverter
extends BaseMessageConverter<StringsList> {
    public StringsListXMLConverter() {
        super(new MediaType[]{MediaType.TEXT_XML, MediaType.APPLICATION_XML});
    }

    protected boolean supports(Class<?> clazz) {
        return StringsList.class.isAssignableFrom(clazz);
    }

    protected boolean canRead(MediaType mediaType) {
        return false;
    }

    public void writeInternal(StringsList stringsList, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        SecureXStream xstream = new SecureXStream();
        xstream.alias(stringsList.getAlias(), String.class);
        xstream.toXML(stringsList.getValues(), outputMessage.getBody());
    }
}

