/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.geometry.Bounds;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.util.NumberRange;
import org.geotools.util.URLs;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class CoverageControllerTest
extends CatalogRESTTestSupport {
    private static final double DELTA = 1.0E-6;

    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpDefaultRasterLayers();
    }

    @Before
    public void addBlueMarbleCoverage() throws Exception {
        ((SystemTestData)this.getTestData()).addDefaultRasterLayer(SystemTestData.TASMANIA_BM, this.getCatalog());
    }

    @Test
    public void testGetAllByWorkspaceXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coverages.xml");
        Assert.assertEquals((long)catalog.getCoveragesByNamespace(catalog.getNamespaceByPrefix("wcs")).size(), (long)dom.getElementsByTagName("coverage").getLength());
    }

    @Test
    public void testGetAllByWorkspaceJSON() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("/rest/workspaces/wcs/coverages.json");
        JSONArray coverages = json.getJSONObject("coverages").getJSONArray("coverage");
        Assert.assertEquals((long)catalog.getCoveragesByNamespace(catalog.getNamespaceByPrefix("wcs")).size(), (long)coverages.size());
    }

    @Test
    public void testGetAllByWorkspaceJSON_no_coverages() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("/rest/workspaces/cite/coverages.json");
        Assert.assertEquals((Object)"", (Object)json.getString("coverages"));
    }

    @Test
    public void testGetAllByWorkspaceJSON_single_element() throws Exception {
        QName tazDem = new QName(SystemTestData.CDF_URI, "tazdem", SystemTestData.CDF_PREFIX);
        ((SystemTestData)this.getTestData()).addRasterLayer(tazDem, "tazdem.tiff", null, this.getCatalog());
        JSONObject json = (JSONObject)this.getAsJSON("/rest/workspaces/cdf/coverages.json");
        JSONArray coverages = json.getJSONObject("coverages").getJSONArray("coverage");
        Assert.assertEquals((long)1L, (long)coverages.size());
        Assert.assertEquals((Object)"tazdem", (Object)coverages.getJSONObject(0).getString("name"));
    }

    void addCoverageStore(boolean autoConfigureCoverage) throws Exception {
        URL zip = ((Object)((Object)this)).getClass().getResource("test-data/usa.zip");
        byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)zip));
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/usaWorldImage/file.worldimage" + (!autoConfigureCoverage ? "?configure=none" : ""), bytes, "application/zip");
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertEquals((long)201L, (long)response.getStatus());
    }

    @Test
    public void testPutAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages").getStatus());
    }

    @Test
    public void testDeleteAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages").getStatus());
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"BlueMarble", (String)"/coverage/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//latLonBoundingBox)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//nativeFormat)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//grid)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//supportedFormats)", (Document)dom);
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble.json");
        JSONObject coverage = ((JSONObject)json).getJSONObject("coverage");
        Assert.assertNotNull((Object)coverage);
        Assert.assertEquals((Object)"BlueMarble", (Object)coverage.get("name"));
    }

    @Test
    public void testGetAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble.html");
        Assert.assertEquals((Object)"html", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testGetWrongCoverage() throws Exception {
        String ws = "wcs";
        String cs = "BlueMarble";
        String c = "BlueMarblesssss";
        String requestPath = "/rest/workspaces/" + ws + "/coverages/" + c + ".html";
        String requestPath2 = "/rest/workspaces/" + ws + "/coveragestores/" + cs + "/coverages/" + c + ".html";
        String exception = "No such coverage: " + ws + "," + c;
        String exception2 = "No such coverage: " + ws + "," + cs + "," + c;
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().contains(exception));
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertFalse((boolean)response.getContentAsString().contains(exception));
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
        response = this.getAsServletResponse(requestPath2);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().contains(exception2));
        response = this.getAsServletResponse(requestPath2 + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertFalse((boolean)response.getContentAsString().contains(exception2));
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
    }

    @Test
    public void testPutWithCalculation() throws Exception {
        String path = "/rest/workspaces/wcs/coveragestores/DEM/coverages/DEM.xml";
        String clearLatLonBoundingBox = "<coverage><latLonBoundingBox/></coverage>";
        MockHttpServletResponse response = this.putAsServletResponse(path, clearLatLonBoundingBox, "text/xml");
        Assert.assertEquals((String)("Couldn't remove lat/lon bounding box: \n" + response.getContentAsString()), (long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM(path);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"/coverage/latLonBoundingBox/minx", (Document)dom);
        this.print(dom);
        String updateNativeBounds = "<coverage><srs>EPSG:3785</srs></coverage>";
        response = this.putAsServletResponse(path, updateNativeBounds, "text/xml");
        Assert.assertEquals((String)("Couldn't update native bounding box: \n" + response.getContentAsString()), (long)200L, (long)response.getStatus());
        dom = this.getAsDOM(path);
        this.print(dom);
        XMLAssert.assertXpathExists((String)"/coverage/nativeBoundingBox/minx[text()!='0.0']", (Document)dom);
    }

    @Test
    public void testPostToResource() throws Exception {
        String xml = "<coverage><name>foo</name></coverage>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testPutXML() throws Exception {
        String xml = "<coverage><title>new title</title></coverage>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"new title", (String)"/coverage/title", (Document)dom);
        CoverageInfo c = catalog.getCoverageByName("wcs", "BlueMarble");
        Assert.assertEquals((Object)"new title", (Object)c.getTitle());
    }

    @Test
    public void testPutJSON() throws Exception {
        String jsonPayload = "{\n    \"coverage\": {\n        \"title\": \"new title 2\"\n    }\n}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble", jsonPayload, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSONObject json = (JSONObject)this.getAsJSON("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble.json");
        MatcherAssert.assertThat((Object)json.getJSONObject("coverage").getString("title"), (Matcher)CoreMatchers.is((Object)"new title 2"));
        CoverageInfo coverage = catalog.getCoverageByName("wcs", "BlueMarble");
        Assert.assertEquals((Object)"new title 2", (Object)coverage.getTitle());
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        CoverageInfo c = catalog.getCoverageByName("wcs", "BlueMarble");
        Assert.assertTrue((boolean)c.isEnabled());
        boolean isAdvertised = c.isAdvertised();
        String xml = "<coverage><title>new title</title></coverage>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        c = catalog.getCoverageByName("wcs", "BlueMarble");
        Assert.assertTrue((boolean)c.isEnabled());
        Assert.assertEquals((Object)isAdvertised, (Object)c.isAdvertised());
    }

    @Test
    public void testPutNonExistant() throws Exception {
        String xml = "<coverage><title>new title</title></coverage>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/NonExistant", xml, "text/xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertNotNull((Object)catalog.getCoverageByName("wcs", "BlueMarble"));
        for (LayerInfo l : catalog.getLayers((ResourceInfo)catalog.getCoverageByName("wcs", "BlueMarble"))) {
            catalog.remove(l);
        }
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble").getStatus());
        Assert.assertNull((Object)catalog.getCoverageByName("wcs", "BlueMarble"));
    }

    @Test
    public void testDeleteNonExistant() throws Exception {
        Assert.assertEquals((long)404L, (long)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/NonExistant").getStatus());
    }

    @Test
    public void testDeleteRecursive() throws Exception {
        Assert.assertNotNull((Object)catalog.getCoverageByName("wcs", "BlueMarble"));
        Assert.assertNotNull((Object)catalog.getLayerByName("wcs:BlueMarble"));
        Assert.assertEquals((long)403L, (long)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble").getStatus());
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble?recurse=true").getStatus());
        Assert.assertNull((Object)catalog.getCoverageByName("wcs", "BlueMarble"));
        Assert.assertNull((Object)catalog.getLayerByName("wcs:BlueMarble"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoverageWrapping() throws Exception {
        GridCoverageReader reader;
        block9: {
            String xml = "<coverage><name>tazdem</name><title>new title</title></coverage>";
            MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/DEM/coverages/DEM", xml, "text/xml");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/DEM/coverages/tazdem.xml");
            XMLAssert.assertXpathEvaluatesTo((String)"new title", (String)"/coverage/title", (Document)dom);
            CoverageInfo c = catalog.getCoverageByName("wcs", "tazdem");
            Assert.assertEquals((Object)"new title", (Object)c.getTitle());
            List dimensions = c.getDimensions();
            CoverageDimensionInfo dimension = (CoverageDimensionInfo)dimensions.get(0);
            Assert.assertEquals((Object)"GRAY_INDEX", (Object)dimension.getName());
            NumberRange range = dimension.getRange();
            Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)range.getMinimum(), (double)1.0E-6);
            Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)range.getMaximum(), (double)1.0E-6);
            Assert.assertEquals((Object)"GridSampleDimension[-Infinity,Infinity]", (Object)dimension.getDescription());
            List nullValues = dimension.getNullValues();
            Assert.assertEquals((double)-9999.0, (double)((Double)nullValues.get(0)), (double)1.0E-6);
            xml = "<coverage><name>tazdem</name><title>new title</title><dimensions><coverageDimension><name>Elevation</name><description>GridSampleDimension[-100.0,1000.0]</description><nullValues><double>-999</double></nullValues><range><min>-100</min><max>1000</max></range></coverageDimension></dimensions></coverage>";
            response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/DEM/coverages/tazdem", xml, "text/xml");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            c = catalog.getCoverageByName("wcs", "tazdem");
            dimensions = c.getDimensions();
            dimension = (CoverageDimensionInfo)dimensions.get(0);
            Assert.assertEquals((Object)"Elevation", (Object)dimension.getName());
            range = dimension.getRange();
            Assert.assertEquals((double)-100.0, (double)range.getMinimum(), (double)1.0E-6);
            Assert.assertEquals((double)1000.0, (double)range.getMaximum(), (double)1.0E-6);
            Assert.assertEquals((Object)"GridSampleDimension[-100.0,1000.0]", (Object)dimension.getDescription());
            nullValues = dimension.getNullValues();
            Assert.assertEquals((double)-999.0, (double)((Double)nullValues.get(0)), (double)1.0E-6);
            CoverageStoreInfo coverageStore = (CoverageStoreInfo)catalog.getStoreByName("wcs", "DEM", CoverageStoreInfo.class);
            reader = null;
            GridCoverage2D coverage = null;
            try {
                reader = catalog.getResourcePool().getGridCoverageReader(coverageStore, "tazdem", null);
                coverage = (GridCoverage2D)reader.read("tazdem", null);
                GridSampleDimension sampleDim = coverage.getSampleDimension(0);
                double[] noDataValues = sampleDim.getNoDataValues();
                Assert.assertEquals((double)-999.0, (double)noDataValues[0], (double)1.0E-6);
                range = sampleDim.getRange();
                Assert.assertEquals((double)-100.0, (double)range.getMinimum(), (double)1.0E-6);
                Assert.assertEquals((double)1000.0, (double)range.getMaximum(), (double)1.0E-6);
                if (coverage == null) break block9;
            }
            catch (Throwable throwable) {
                if (coverage != null) {
                    CoverageControllerTest.dispose(coverage);
                }
                if (reader != null) {
                    try {
                        reader.dispose();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            CoverageControllerTest.dispose(coverage);
        }
        if (reader != null) {
            try {
                reader.dispose();
            }
            catch (Throwable throwable) {}
        }
    }

    @Test
    public void testCoverageReset() throws Exception {
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(SystemTestData.TASMANIA_BM));
        Assert.assertNotNull((Object)ci);
        GridCoverage2D gridCoverage = (GridCoverage2D)ci.getGridCoverage(null, null);
        Bounds envelope = gridCoverage.getEnvelope();
        CoverageControllerTest.dispose(gridCoverage);
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble/reset", "", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        try (InputStream is = SystemTestData.class.getResourceAsStream("world.tiff");
             OutputStream os = this.getDataDirectory().get(new String[]{"BlueMarble/tazbm.tiff"}).out();){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        gridCoverage = (GridCoverage2D)ci.getGridCoverage(null, null);
        Bounds envelopeNew = gridCoverage.getEnvelope();
        Assert.assertNotEquals((Object)envelopeNew, (Object)envelope);
        CoverageControllerTest.dispose(gridCoverage);
    }

    @Test
    public void testCoverageResetReloadBands() throws Exception {
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(SystemTestData.TASMANIA_BM));
        Assert.assertNotNull((Object)ci);
        GridCoverage2D gridCoverage = (GridCoverage2D)ci.getGridCoverage(null, null);
        Bounds envelope = gridCoverage.getEnvelope();
        Assert.assertEquals((long)3L, (long)ci.getDimensions().size());
        CoverageControllerTest.dispose(gridCoverage);
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble/reset", "", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        try (InputStream is = SystemTestData.class.getResourceAsStream("tazdem.tiff");
             OutputStream os = this.getDataDirectory().get(new String[]{"BlueMarble/tazbm.tiff"}).out();){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble?calculate=dimensions", "<coverage/>", "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ci = catalog.getCoverageByName(this.getLayerId(SystemTestData.TASMANIA_BM));
        gridCoverage = (GridCoverage2D)ci.getGridCoverage(null, null);
        Bounds envelopeNew = gridCoverage.getEnvelope();
        Assert.assertNotEquals((Object)envelopeNew, (Object)envelope);
        Assert.assertEquals((long)1L, (long)ci.getDimensions().size());
        CoverageControllerTest.dispose(gridCoverage);
    }
}

