/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.rest.util.IOUtils;
import org.geoserver.rest.util.RESTUtils;
import org.geoserver.security.FileAccessManager;
import org.geoserver.security.impl.DefaultFileAccessManager;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.FactoryException;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.URLs;
import org.geotools.util.factory.GeoTools;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class CoverageStoreFileUploadTest
extends CatalogRESTTestSupport {
    @ClassRule
    public static TemporaryFolder temp = new TemporaryFolder();

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        DataStoreInfo store = cb.buildDataStore("h2test");
        store.getConnectionParameters().put("dbtype", "h2");
        store.getConnectionParameters().put("database", new File(this.getDataDirectory().findOrCreateDir(new String[]{"data"}), "h2_test").getAbsolutePath());
        store.getConnectionParameters().put("MVCC", true);
        catalog.save((StoreInfo)store);
    }

    @Before
    public void cleanup() throws IOException {
        CoverageInfo coverage = (CoverageInfo)this.getCatalog().getResourceByName("mosaic", CoverageInfo.class);
        if (coverage != null) {
            this.removeStore(coverage.getStore().getWorkspace().getName(), coverage.getStore().getName());
        }
        this.removeStore("sf", "usa");
    }

    @Test
    public void testWorldImageUploadZipped() throws Exception {
        this.uploadUSAWorldImage();
        CoverageStoreInfo cs = this.getCatalog().getCoverageStoreByName("sf", "usa");
        Assert.assertNotNull((Object)cs);
        CoverageInfo ci = this.getCatalog().getCoverageByName("sf", "usa");
        Assert.assertNotNull((Object)ci);
    }

    @Test
    @Ignore
    public void testUploadWithSpaces() throws Exception {
        URL zip = ((Object)((Object)this)).getClass().getResource("test-data/usa.zip");
        byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)zip));
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/store%20with%20spaces/file.worldimage", bytes, "application/zip");
        Assert.assertEquals((long)500L, (long)response.getStatus());
    }

    @Test
    public void testUploadImageMosaic() throws Exception {
        URL zip = MockData.class.getResource("watertemp.zip");
        byte[] bytes = this.getBytes(zip);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/watertemp/file.imagemosaic", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        String content = response.getContentAsString();
        Document d = this.dom(new ByteArrayInputStream(content.getBytes()));
        XMLAssert.assertXpathEvaluatesTo((String)"watertemp", (String)"//coverageStore/name", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"ImageMosaic", (String)"//coverageStore/type", (Document)d);
        CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("watertemp");
        Assert.assertNotNull((Object)storeInfo);
        CoverageInfo ci = this.getCatalog().getCoverageByName("watertemp");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
    }

    @Test
    public void testUploadImageMosaicRepoReference() throws Exception {
        URL zip = CoverageStoreFileUploadTest.class.getResource("watertemp-repo.zip");
        byte[] bytes = this.getBytes(zip);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/watertemp-repo/file.imagemosaic", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        String content = response.getContentAsString();
        Document d = this.dom(new ByteArrayInputStream(content.getBytes()));
        XMLAssert.assertXpathEvaluatesTo((String)"watertemp-repo", (String)"//coverageStore/name", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"ImageMosaic", (String)"//coverageStore/type", (Document)d);
        CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("watertemp-repo");
        Assert.assertNotNull((Object)storeInfo);
        CoverageInfo ci = this.getCatalog().getCoverageByName("watertemp-repo");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
        DataStore ds = (DataStore)this.getCatalog().getDataStoreByName("h2test").getDataStore(null);
        Assert.assertNotNull((Object)ds);
        SimpleFeatureSource fs = ds.getFeatureSource("watertemp-repo");
        Assert.assertNotNull((Object)fs);
        Assert.assertEquals((long)4L, (long)fs.getCount(Query.ALL));
    }

    public byte[] getBytes(URL zip) throws IOException {
        try (InputStream is = zip.openStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    @Test
    public void testHarvestImageMosaic() throws Exception {
        URL zip = MockData.class.getResource("watertemp.zip");
        byte[] bytes = this.getBytes(zip);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/watertemp2/file.imagemosaic", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        String content = response.getContentAsString();
        Document d = this.dom(new ByteArrayInputStream(content.getBytes()));
        XMLAssert.assertXpathEvaluatesTo((String)"watertemp2", (String)"//coverageStore/name", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"ImageMosaic", (String)"//coverageStore/type", (Document)d);
        CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("watertemp2");
        Assert.assertNotNull((Object)storeInfo);
        CoverageInfo ci = this.getCatalog().getCoverageByName("watertemp2");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
        URL zipHarvest = MockData.class.getResource("harvesting.zip");
        try (InputStream is = zipHarvest.openStream();){
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        MockHttpServletRequest request = this.createRequest("/rest/workspaces/gs/coveragestores/watertemp2/file.imagemosaic");
        request.setMethod("POST");
        request.setContentType("application/zip");
        request.setContent(bytes);
        request.addHeader("Content-type", (Object)"application/zip");
        this.dispatch((HttpServletRequest)request);
        GridCoverageReader reader = storeInfo.getGridCoverageReader(null, GeoTools.getDefaultHints());
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z,2008-11-01T00:00:00.000Z,2008-11-02T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
    }

    @Test
    public void testHarvestNotAllowedOnSimpleCoverageStore() throws Exception {
        ((SystemTestData)this.getTestData()).addDefaultRasterLayer(SystemTestData.TASMANIA_BM, this.getCatalog());
        URL zipHarvest = MockData.class.getResource("harvesting.zip");
        byte[] bytes = this.getBytes(zipHarvest);
        MockHttpServletRequest request = this.createRequest("/rest/workspaces/wcs/coveragestores/BlueMarble");
        request.setMethod("POST");
        request.setContentType("application/zip");
        request.setContent(bytes);
        request.addHeader("Content-type", (Object)"application/zip");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testHarvestImageMosaicWithDirectory() throws Exception {
        URL zip = MockData.class.getResource("watertemp.zip");
        byte[] bytes = this.getBytes(zip);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/watertemp3/file.imagemosaic", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        String content = response.getContentAsString();
        Document d = this.dom(new ByteArrayInputStream(content.getBytes()));
        XMLAssert.assertXpathEvaluatesTo((String)"watertemp3", (String)"//coverageStore/name", (Document)d);
        XMLAssert.assertXpathEvaluatesTo((String)"ImageMosaic", (String)"//coverageStore/type", (Document)d);
        CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("watertemp3");
        Assert.assertNotNull((Object)storeInfo);
        CoverageInfo ci = this.getCatalog().getCoverageByName("watertemp3");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
        URL zipHarvest = MockData.class.getResource("harvesting.zip");
        Resource newZip = Files.asResource((File)new File("./target/harvesting2.zip"));
        IOUtils.copyStream((InputStream)zipHarvest.openStream(), (OutputStream)newZip.out(), (boolean)true, (boolean)true);
        Resource outputDirectory = Files.asResource((File)new File("./target/harvesting"));
        RESTUtils.unzipFile((Resource)newZip, (Resource)outputDirectory);
        MockHttpServletRequest request = this.createRequest("/rest/workspaces/gs/coveragestores/watertemp3/external.imagemosaic");
        request.setMethod("POST");
        request.setContentType("text/plain");
        request.setContent(("file:///" + outputDirectory.dir().getAbsolutePath()).getBytes(StandardCharsets.UTF_8));
        request.addHeader("Content-type", (Object)"text/plain");
        this.dispatch((HttpServletRequest)request);
        GridCoverageReader reader = storeInfo.getGridCoverageReader(null, GeoTools.getDefaultHints());
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z,2008-11-01T00:00:00.000Z,2008-11-02T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
        outputDirectory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestExternalImageMosaic() throws Exception {
        File oldDir;
        URL resource = ((Object)((Object)this)).getClass().getResource("test-data/mosaic");
        if (resource != null && (oldDir = URLs.urlToFile((URL)resource)).exists()) {
            FileUtils.deleteDirectory((File)oldDir);
        }
        Resource mosaic = this.readMosaic();
        CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("gs");
        CoverageStoreInfo store = builder.buildCoverageStore("watertemp4");
        store.setURL(URLs.fileToUrl((File)Resources.find((Resource)mosaic)).toExternalForm());
        store.setWorkspace(ws);
        ImageMosaicFormat imageMosaicFormat = new ImageMosaicFormat();
        store.setType(imageMosaicFormat.getName());
        this.getCatalog().add((StoreInfo)store);
        builder.setStore((StoreInfo)store);
        ImageMosaicReader reader = null;
        StructuredGridCoverage2DReader reader2 = null;
        try {
            reader = imageMosaicFormat.getReader((Object)URLs.fileToUrl((File)Resources.find((Resource)mosaic)));
            this.configureCoverageInfo(builder, store, (GridCoverage2DReader)reader);
            CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("watertemp4");
            Assert.assertNotNull((Object)storeInfo);
            CoverageInfo ci = this.getCatalog().getCoverageByName("mosaic");
            Assert.assertNotNull((Object)ci);
            Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
            URL zipHarvest = MockData.class.getResource("harvesting.zip");
            byte[] bytes = this.getBytes(zipHarvest);
            MockHttpServletRequest request = this.createRequest("/rest/workspaces/gs/coveragestores/watertemp4/file.imagemosaic");
            request.setMethod("POST");
            request.setContentType("application/zip");
            request.setContent(bytes);
            request.addHeader("Content-type", (Object)"application/zip");
            this.dispatch((HttpServletRequest)request);
            reader2 = (StructuredGridCoverage2DReader)storeInfo.getGridCoverageReader(null, GeoTools.getDefaultHints());
            String[] metadataNames = reader2.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((Object)"true", (Object)reader2.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z,2008-11-01T00:00:00.000Z,2008-11-02T00:00:00.000Z", (Object)reader2.getMetadataValue(metadataNames[0]));
            reader2.delete(true);
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Throwable throwable) {}
            }
            if (reader2 != null) {
                try {
                    reader2.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReHarvestSingleTiff() throws Exception {
        File oldDir;
        URL resource = ((Object)((Object)this)).getClass().getResource("test-data/mosaic");
        if (resource != null && (oldDir = URLs.urlToFile((URL)resource)).exists()) {
            FileUtils.deleteDirectory((File)oldDir);
        }
        Resource mosaic = this.readMosaic();
        CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("gs");
        CoverageStoreInfo store = builder.buildCoverageStore("watertemp5");
        store.setURL(URLs.fileToUrl((File)Resources.find((Resource)mosaic)).toExternalForm());
        store.setWorkspace(ws);
        ImageMosaicFormat imageMosaicFormat = new ImageMosaicFormat();
        store.setType(imageMosaicFormat.getName());
        this.getCatalog().add((StoreInfo)store);
        builder.setStore((StoreInfo)store);
        ImageMosaicReader reader = null;
        StructuredGridCoverage2DReader reader2 = null;
        try {
            reader = imageMosaicFormat.getReader((Object)URLs.fileToUrl((File)Resources.find((Resource)mosaic)));
            this.configureCoverageInfo(builder, store, (GridCoverage2DReader)reader);
            CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("watertemp5");
            Assert.assertNotNull((Object)storeInfo);
            CoverageInfo ci = this.getCatalog().getCoverageByName("mosaic");
            Assert.assertNotNull((Object)ci);
            Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
            URL zipHarvest = MockData.class.getResource("harvesting.zip");
            byte[] bytes = null;
            try (ZipInputStream zis = new ZipInputStream(zipHarvest.openStream());){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    if (!"NCOM_wattemp_000_20081102T0000000_12.tiff".equals(entry.getName())) continue;
                    bytes = IOUtils.toByteArray((InputStream)zis);
                }
                if (bytes == null) {
                    Assert.fail((String)"Could not find the expected zip entry NCOM_wattemp_000_20081102T0000000_12.tiff");
                }
            }
            reader2 = this.uploadGeotiffAndCheck(storeInfo, bytes, "NCOM_wattemp_000_20081102T0000000_12.tiff");
            reader2 = this.uploadGeotiffAndCheck(storeInfo, bytes, "NCOM_wattemp_000_20081102T0000000_12.tiff");
            reader2.delete(true);
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Throwable throwable) {}
            }
            if (reader2 != null) {
                try {
                    reader2.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private StructuredGridCoverage2DReader uploadGeotiffAndCheck(CoverageStoreInfo storeInfo, byte[] bytes, String filename) throws Exception {
        MockHttpServletRequest request = this.createRequest("/rest/workspaces/gs/coveragestores/watertemp5/file.imagemosaic?filename=" + filename);
        request.setMethod("POST");
        request.setContentType("image/tiff");
        request.setContent(bytes);
        request.addHeader("Content-type", (Object)"image/tiff");
        Assert.assertEquals((long)202L, (long)this.dispatch((HttpServletRequest)request).getStatus());
        StructuredGridCoverage2DReader reader2 = (StructuredGridCoverage2DReader)storeInfo.getGridCoverageReader(null, GeoTools.getDefaultHints());
        String[] metadataNames = reader2.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((Object)"true", (Object)reader2.getMetadataValue("HAS_TIME_DOMAIN"));
        Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z,2008-11-01T00:00:00.000Z,2008-11-02T00:00:00.000Z", (Object)reader2.getMetadataValue(metadataNames[0]));
        return reader2;
    }

    private Resource readMosaic() throws FactoryException, IOException {
        URL mosaicZip = ((Object)((Object)this)).getClass().getResource("test-data/watertemp2.zip");
        Resource zipFile = Files.asResource((File)URLs.urlToFile((URL)mosaicZip));
        Resource newZip = zipFile.parent().get("watertemp2_temp.zip");
        IOUtils.copyStream((InputStream)zipFile.in(), (OutputStream)newZip.out(), (boolean)true, (boolean)true);
        Resource mosaic = zipFile.parent().get("mosaic");
        mosaic.delete();
        RESTUtils.unzipFile((Resource)newZip, (Resource)mosaic);
        return mosaic;
    }

    private void configureCoverageInfo(CatalogBuilder builder, CoverageStoreInfo storeInfo, GridCoverage2DReader reader) throws Exception {
        CoverageInfo cinfo = builder.buildCoverage(reader, new HashMap());
        String name = reader.getGridCoverageNames()[0];
        cinfo.setName(name);
        cinfo.setNativeCoverageName(name);
        this.getCatalog().add((ResourceInfo)cinfo);
    }

    @Test
    public void testDefaultBehaviourUpdateBBoxPOST() throws Exception {
        this.setUpBBoxTest("bboxtest", "test_bbox_raster1.zip");
        byte[] bytes = null;
        CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("bboxtest");
        Assert.assertNotNull((Object)storeInfo);
        CoverageInfo ci = this.getCatalog().getCoverageByName("bboxtest");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
        URL zipHarvest = ((Object)((Object)this)).getClass().getResource("test_bbox_granules.zip");
        try (InputStream is = zipHarvest.openStream();){
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        MockHttpServletRequest request = this.createRequest("/rest/workspaces/gs/coveragestores/bboxtest/file.imagemosaic");
        request.setMethod("POST");
        request.setContentType("application/zip");
        request.setContent(bytes);
        request.addHeader("Content-type", (Object)"application/zip");
        this.dispatch((HttpServletRequest)request);
        CoverageStoreFileUploadTest.testBBoxLayerConfiguration(storeInfo, (current, old) -> Assert.assertNotEquals((Object)current, (Object)old), catalog);
        CoverageInfo coverage = (CoverageInfo)this.getCatalog().getResourceByName("bboxtest", CoverageInfo.class);
        if (coverage != null) {
            this.removeStore(coverage.getStore().getWorkspace().getName(), coverage.getStore().getName());
        }
    }

    @Test
    public void testUpdateBBoxTrueParameterPOST() throws Exception {
        this.setUpBBoxTest("bboxtest2", "test_bbox_raster1.zip");
        byte[] bytes = null;
        CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("bboxtest2");
        Assert.assertNotNull((Object)storeInfo);
        CoverageInfo ci = this.getCatalog().getCoverageByName("bboxtest2");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
        URL zipHarvest = ((Object)((Object)this)).getClass().getResource("test_bbox_granules.zip");
        try (InputStream is = zipHarvest.openStream();){
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        MockHttpServletRequest request = this.createRequest("/rest/workspaces/gs/coveragestores/bboxtest2/file.imagemosaic");
        request.setMethod("POST");
        request.setParameter("updateBBox", "true");
        request.setContentType("application/zip");
        request.setContent(bytes);
        request.addHeader("Content-type", (Object)"application/zip");
        this.dispatch((HttpServletRequest)request);
        CoverageStoreFileUploadTest.testBBoxLayerConfiguration(storeInfo, (current, old) -> Assert.assertEquals((Object)current, (Object)old), catalog);
        CoverageInfo coverage = (CoverageInfo)this.getCatalog().getResourceByName("bboxtest2", CoverageInfo.class);
        if (coverage != null) {
            this.removeStore(coverage.getStore().getWorkspace().getName(), coverage.getStore().getName());
        }
    }

    @Test
    public void testUpdateBBoxTrueOnCoverageView() throws Exception {
        this.setUpBBoxTest("coverageview", "test_bbox_coverageview.zip");
        byte[] bytes = null;
        Catalog cat = this.getCatalog();
        CoverageStoreInfo storeInfo = this.getCatalog().getCoverageStoreByName("coverageview");
        Assert.assertNotNull((Object)storeInfo);
        CoverageView coverageView = this.buildCoverageView();
        CatalogBuilder builder = new CatalogBuilder(cat);
        builder.setStore((StoreInfo)storeInfo);
        CoverageInfo coverageInfo = coverageView.createCoverageInfo("coverageView", storeInfo, builder);
        coverageInfo.getParameters().put("USE_JAI_IMAGEREAD", "false");
        ((CoverageDimensionInfo)coverageInfo.getDimensions().get(0)).setName("rasterA");
        ((CoverageDimensionInfo)coverageInfo.getDimensions().get(1)).setName("rasterB");
        cat.add((ResourceInfo)coverageInfo);
        CoverageInfo ci = this.getCatalog().getCoverageByName("coverageView");
        Assert.assertNotNull((Object)ci);
        Assert.assertEquals((Object)storeInfo, (Object)ci.getStore());
        URL zipHarvest = ((Object)((Object)this)).getClass().getResource("test_bbox_singlegranule.zip");
        try (InputStream is = zipHarvest.openStream();){
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        MockHttpServletRequest request = this.createRequest("/rest/workspaces/gs/coveragestores/coverageview/file.imagemosaic");
        request.setMethod("POST");
        request.setParameter("updateBBox", "true");
        request.setContentType("application/zip");
        request.setContent(bytes);
        request.addHeader("Content-type", (Object)"application/zip");
        this.dispatch((HttpServletRequest)request);
        CoverageStoreFileUploadTest.testBBoxLayerConfiguration(storeInfo, (current, old) -> Assert.assertEquals((Object)current, (Object)old), catalog);
        CoverageInfo coverage = (CoverageInfo)this.getCatalog().getResourceByName("coverageview", CoverageInfo.class);
        if (coverage != null) {
            this.removeStore(coverage.getStore().getWorkspace().getName(), coverage.getStore().getName());
        }
    }

    private CoverageView buildCoverageView() {
        CoverageView.CoverageBand aBand = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand("rasterA", "0")), "rasterA", 0, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.CoverageBand bBand = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand("rasterB", "0")), "rasterB", 1, CoverageView.CompositionType.BAND_SELECT);
        CoverageView coverageView = new CoverageView("coverageView", Arrays.asList(aBand, bBand));
        coverageView.setEnvelopeCompositionType(CoverageView.EnvelopeCompositionType.UNION);
        coverageView.setSelectedResolution(null);
        return coverageView;
    }

    private void setUpBBoxTest(String storeName, String fileName) throws Exception {
        URL zip = ((Object)((Object)this)).getClass().getResource(fileName);
        byte[] bytes = this.getBytes(zip);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/" + storeName + "/file.imagemosaic", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
    }

    static void testBBoxLayerConfiguration(CoverageStoreInfo storeInfo, BiConsumer<ReferencedEnvelope, ReferencedEnvelope> assertConsumer, Catalog catalog) throws IOException {
        String[] coveragesNames;
        StructuredGridCoverage2DReader sr = (StructuredGridCoverage2DReader)storeInfo.getGridCoverageReader(null, null);
        for (String name : coveragesNames = sr.getGridCoverageNames()) {
            ReferencedEnvelope current = new ReferencedEnvelope((Bounds)sr.getOriginalEnvelope(name));
            ReferencedEnvelope old = catalog.getCoverageByCoverageStore(storeInfo, name).getNativeBoundingBox();
            assertConsumer.accept(current, old);
        }
    }

    @Test
    public void testWorldImageUploadExternalZipDirectory() throws Exception {
        File file = temp.getRoot();
        String body = file.getAbsolutePath();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/foo/coveragestores/bar/external.worldimage", body, "application/zip");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.startsWith((String)"Error renaming zip file from "));
        Assert.assertTrue((String)"The external file was unexpectedly deleted", (boolean)file.exists());
    }

    @Test
    public void testWorldImageUploadExternalZipExistingDirectory() throws Exception {
        File file1 = temp.newFile("test1.zip");
        String body = file1.getAbsolutePath();
        File file2 = this.getResourceLoader().createDirectory("data/foo/bar1/test1.zip");
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/foo/coveragestores/bar1/external.worldimage", body, "application/zip");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.startsWith((String)"Error renaming zip file from "));
        Assert.assertTrue((String)"The external file was unexpectedly deleted", (boolean)file1.exists());
        Assert.assertTrue((String)"The file in the data directory was unexpectedly deleted", (boolean)file2.isDirectory());
    }

    @Test
    public void testWorldImageUploadExternalZipBadFile() throws Exception {
        File file = temp.newFile("test2.zip");
        String body = file.getAbsolutePath();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/foo/coveragestores/bar2/external.worldimage", body, "application/zip");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)"Error occured unzipping file", (Object)response.getContentAsString());
        Assert.assertTrue((String)"The external file was unexpectedly deleted", (boolean)file.exists());
        Assert.assertEquals((String)"The data directory file was not deleted", (Object)Resource.Type.UNDEFINED, (Object)this.getResourceLoader().get("data/foo/bar2/test2.zip").getType());
    }

    @Test
    public void testWorldImageUploadExternalZipValid() throws Exception {
        File file = temp.newFile("test3.zip");
        FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("test-data/usa.zip"), (File)file);
        String body = file.getAbsolutePath();
        Assert.assertNull((Object)this.getCatalog().getCoverageStoreByName("sf", "usa"));
        Assert.assertNull((Object)this.getCatalog().getCoverageByName("sf", "usa"));
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/coveragestores/usa/external.worldimage", body, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        String content = response.getContentAsString();
        Document d = this.dom(new ByteArrayInputStream(content.getBytes()));
        Assert.assertEquals((Object)"coverageStore", (Object)d.getDocumentElement().getNodeName());
        Assert.assertNotNull((Object)this.getCatalog().getCoverageStoreByName("sf", "usa"));
        Assert.assertNotNull((Object)this.getCatalog().getCoverageByName("sf", "usa"));
        Assert.assertTrue((String)"The external file was unexpectedly deleted", (boolean)file.exists());
        Assert.assertEquals((String)"The data directory file was not deleted", (Object)Resource.Type.UNDEFINED, (Object)this.getResourceLoader().get("data/sf/usa/test3.zip").getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilesystemSandbox() throws Exception {
        File systemSandbox = new File("./target/systemSandbox").getCanonicalFile();
        System.setProperty(DefaultFileAccessManager.GEOSERVER_DATA_SANDBOX, systemSandbox.getAbsolutePath());
        DefaultFileAccessManager fam = (DefaultFileAccessManager)FileAccessManager.lookupFileAccessManager();
        fam.reload();
        try {
            this.uploadUSAWorldImage();
            CoverageStoreInfo cs = this.getCatalog().getCoverageStoreByName("sf", "usa");
            Assert.assertNotNull((Object)cs);
            String expected = new File(systemSandbox, "/sf/usa/usa.png").getAbsolutePath().replace("\\", "/");
            MatcherAssert.assertThat((Object)cs.getURL(), (Matcher)Matchers.containsString((String)expected));
        }
        finally {
            System.clearProperty(DefaultFileAccessManager.GEOSERVER_DATA_SANDBOX);
            fam.reload();
        }
    }

    private void uploadUSAWorldImage() throws Exception {
        URL zip = ((Object)((Object)this)).getClass().getResource("test-data/usa.zip");
        byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)zip));
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/coveragestores/usa/file.worldimage", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        String content = response.getContentAsString();
        Document d = this.dom(new ByteArrayInputStream(content.getBytes()));
        Assert.assertEquals((Object)"coverageStore", (Object)d.getDocumentElement().getNodeName());
    }
}

