/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.Filter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.filters.LoggingFilter;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.security.FileAccessManager;
import org.geoserver.security.impl.DefaultFileAccessManager;
import org.geotools.util.URLs;
import org.h2.tools.DeleteDbFiles;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataStoreFileUploadTest
extends CatalogRESTTestSupport {
    @ClassRule
    public static TemporaryFolder temp = new TemporaryFolder();

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        NamespaceInfoImpl gsmlNamespace = new NamespaceInfoImpl();
        gsmlNamespace.setPrefix("gsml");
        gsmlNamespace.setURI("http://www.cgi-iugs.org/xml/GeoSciML/2");
        WorkspaceInfoImpl gsmlWorkspace = new WorkspaceInfoImpl();
        gsmlWorkspace.setName("gsml");
        this.getCatalog().add((NamespaceInfo)gsmlNamespace);
        this.getCatalog().add((WorkspaceInfo)gsmlWorkspace);
    }

    protected List<Filter> getFilters() {
        LoggingFilter filter = new LoggingFilter(null);
        filter.setEnabled(true);
        filter.setLogBodies(true);
        return Collections.singletonList(filter);
    }

    @Before
    public void removePdsDataStore() {
        this.removeStore("gs", "pds");
        this.removeStore("gs", "store with spaces");
        this.removeStore("gs", "san_andres_y_providencia");
    }

    @After
    public void cleanUpDbFiles() throws Exception {
        DeleteDbFiles.execute((String)"target", (String)"foo", (boolean)true);
        DeleteDbFiles.execute((String)"target", (String)"pds", (boolean)true);
        DeleteDbFiles.execute((String)"target", (String)"chinese_poly", (boolean)true);
        DeleteDbFiles.execute((String)"target", (String)"san_andres_y_providencia", (boolean)true);
    }

    byte[] propertyFile() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
        writer.write("_=name:String,pointProperty:Point\n");
        writer.write("ds.0='zero'|POINT(0 0)\n");
        writer.write("ds.1='one'|POINT(1 1)\n");
        writer.flush();
        return output.toByteArray();
    }

    void assertFeatures(Document dom) throws Exception {
        this.assertFeatures(dom, "gs");
    }

    void assertFeatures(Document dom, String ns) throws Exception {
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagName(ns + ":pds").getLength());
    }

    byte[] shpZipAsBytes() throws IOException {
        return this.toBytes(((Object)((Object)this)).getClass().getResourceAsStream("test-data/pds.zip"));
    }

    byte[] shpChineseZipAsBytes() throws IOException {
        return this.toBytes(((Object)((Object)this)).getClass().getResourceAsStream("test-data/chinese_poly.zip"));
    }

    byte[] shpSanAndresShapefilesZipAsBytes() throws IOException {
        return this.toBytes(((Object)((Object)this)).getClass().getResourceAsStream("test-data/san_andres_y_providencia.zip"));
    }

    byte[] shpMultiZipAsBytes() throws IOException {
        return this.toBytes(((Object)((Object)this)).getClass().getResourceAsStream("test-data/pdst.zip"));
    }

    byte[] shpSameNameZipAsBytes(String path) throws IOException {
        return this.toBytes(((Object)((Object)this)).getClass().getResourceAsStream(path));
    }

    byte[] toBytes(InputStream in) throws IOException {
        int c;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        return out.toByteArray();
    }

    @Test
    public void testShapeFileUploadNotExisting() throws Exception {
        File file = new File("./target/notThere.tiff");
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        URL url = URLs.fileToUrl((File)file.getCanonicalFile());
        String body = url.toExternalForm();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/datastores/pds/external.shp", body, "text/plain");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    @Ignore
    public void testShapeFileUploadWithSpaces() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getDataStoreByName("gs", "store with spaces"));
        byte[] bytes = this.shpZipAsBytes();
        this.put("/rest/workspaces/gs/datastores/store%20with%20spaces/file.shp", bytes, "application/zip");
        DataStoreInfo ds = cat.getDataStoreByName("gs", "store with spaces");
        Assert.assertNull((Object)ds);
    }

    @Test
    public void testShapefileUploadMultiple() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getDataStoreByName("gs", "pdst"));
        this.put("/rest/workspaces/gs/datastores/pdst/file.shp?configure=all", this.shpMultiZipAsBytes(), "application/zip");
        DataStoreInfo ds = cat.getDataStoreByName("gs", "pdst");
        Assert.assertNotNull((Object)ds);
        Assert.assertEquals((long)2L, (long)cat.getFeatureTypesByDataStore(ds).size());
    }

    @Test
    public void testRenamingFeatureTypeAlreadyInCatalog() throws Exception {
        Catalog cat = this.getCatalog();
        this.put("/rest/workspaces/gs/datastores/10bt/file.shp?configure=all", this.shpSameNameZipAsBytes("test-data/10bt.zip"), "application/zip");
        ArrayList ftNames = new ArrayList(10);
        DataStoreInfo ds = cat.getDataStoreByName("gs", "10bt");
        cat.getFeatureTypesByDataStore(ds).forEach(ft -> ftNames.add(ft.getName()));
        Assert.assertEquals((long)10L, (long)ftNames.size());
        this.put("/rest/workspaces/gs/datastores/bt/file.shp?configure=all", this.shpSameNameZipAsBytes("test-data/bt.zip"), "application/zip");
        DataStoreInfo ds2 = cat.getDataStoreByName("gs", "bt");
        Assert.assertEquals((Object)"bt10", (Object)((FeatureTypeInfo)cat.getFeatureTypesByDataStore(ds2).get(0)).getName());
    }

    @Test
    public void testShapefileUploadZip() throws Exception {
        this.uploadSanAndreas();
    }

    @Test
    public void testGetProperties() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("/rest/workspaces/gs/datastores/pds/file.properties");
        Assert.assertEquals((long)404L, (long)resp.getStatus());
        byte[] bytes = this.propertyFile();
        this.put("/rest/workspaces/gs/datastores/pds/file.properties", bytes, "text/plain");
        resp = this.getAsServletResponse("/rest/workspaces/gs/datastores/pds/file.properties");
        Assert.assertEquals((long)200L, (long)resp.getStatus());
        Assert.assertEquals((Object)"application/zip", (Object)resp.getContentType());
        ByteArrayInputStream bin = this.getBinaryInputStream(resp);
        ZipInputStream zin = new ZipInputStream(bin);
        ZipEntry entry = zin.getNextEntry();
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"pds.properties", (Object)entry.getName());
    }

    @Test
    public void testAppSchemaMappingFileUpload() throws Exception {
        byte[] bytes = this.appSchemaMappingAsBytes();
        if (bytes == null) {
            LOGGER.warning("app-schema test data not available: skipping test");
            return;
        }
        this.loadAppSchemaTestData();
        this.put("/rest/workspaces/gsml/datastores/mappedPolygons/file.appschema", bytes, "text/xml");
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gsml:MappedFeature");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        NodeList mappedFeatureNodes = dom.getDocumentElement().getElementsByTagNameNS("http://www.cgi-iugs.org/xml/GeoSciML/2", "MappedFeature");
        Assert.assertNotNull((Object)mappedFeatureNodes);
        Assert.assertEquals((long)2L, (long)mappedFeatureNodes.getLength());
        int namesCount = this.countNameAttributes(mappedFeatureNodes.item(0));
        Assert.assertEquals((long)2L, (long)namesCount);
        bytes = this.appSchemaAlternativeMappingAsBytes();
        this.put("/rest/workspaces/gsml/datastores/mappedPolygons/file.appschema?configure=none", bytes, "text/xml");
        dom = this.getAsDOM("wfs?request=getfeature&typename=gsml:MappedFeature");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        mappedFeatureNodes = dom.getDocumentElement().getElementsByTagNameNS("http://www.cgi-iugs.org/xml/GeoSciML/2", "MappedFeature");
        Assert.assertNotNull((Object)mappedFeatureNodes);
        Assert.assertEquals((long)2L, (long)mappedFeatureNodes.getLength());
        namesCount = this.countNameAttributes(mappedFeatureNodes.item(0));
        Assert.assertEquals((long)1L, (long)namesCount);
    }

    private int countNameAttributes(Node mappedFeatureNode) {
        NodeList attrNodes = mappedFeatureNode.getChildNodes();
        int namesCount = 0;
        for (int i = 0; i < attrNodes.getLength(); ++i) {
            Node attribute = attrNodes.item(i);
            if (!"name".equals(attribute.getLocalName())) continue;
            ++namesCount;
        }
        return namesCount;
    }

    private void loadAppSchemaTestData() throws IOException {
        GeoServerResourceLoader loader = new GeoServerResourceLoader(((SystemTestData)this.getTestData()).getDataDirectoryRoot());
        loader.copyFromClassPath("test-data/mappedPolygons.properties", "data/gsml/mappedPolygons.properties");
        loader.copyFromClassPath("test-data/mappedPolygons.oasis.xml", "data/gsml/mappedPolygons.oasis.xml");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/CGI_basicTypes.xsd", "data/gsml/commonSchemas_new/GeoSciML/CGI_basicTypes.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/CGI_Value.xsd", "data/gsml/commonSchemas_new/GeoSciML/CGI_Value.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/earthMaterial.xsd", "data/gsml/commonSchemas_new/GeoSciML/earthMaterial.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/fossil.xsd", "data/gsml/commonSchemas_new/GeoSciML/fossil.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/geologicStructure.xsd", "data/gsml/commonSchemas_new/GeoSciML/geologicStructure.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/geologicUnit.xsd", "data/gsml/commonSchemas_new/GeoSciML/geologicUnit.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/geosciml.xsd", "data/gsml/commonSchemas_new/GeoSciML/geosciml.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/Gsml.xsd", "data/gsml/commonSchemas_new/GeoSciML/Gsml.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/metadata.xsd", "data/gsml/commonSchemas_new/GeoSciML/metadata.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/ObsAndMeas.xsd", "data/gsml/commonSchemas_new/GeoSciML/ObsAndMeas.xsd");
        loader.copyFromClassPath("test-data/commonSchemas_new/GeoSciML/vocabulary.xsd", "data/gsml/commonSchemas_new/GeoSciML/vocabulary.xsd");
    }

    private byte[] appSchemaMappingAsBytes() throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/test-data/mappedPolygons.xml");
        if (in != null) {
            byte[] original = this.toBytes(in);
            String originalAsString = new String(original, StandardCharsets.UTF_8);
            String modifiedAsString = originalAsString.replace("file:./", "file:../").replace("commonSchemas_new/", "../commonSchemas_new/").replace("mappedPolygons.oasis", "../mappedPolygons.oasis");
            byte[] modified = modifiedAsString.getBytes(StandardCharsets.UTF_8);
            return modified;
        }
        return null;
    }

    private byte[] appSchemaAlternativeMappingAsBytes() throws Exception {
        byte[] mapping = this.appSchemaMappingAsBytes();
        if (mapping != null) {
            Document mappingDom = this.dom(new ByteArrayInputStream(mapping));
            NodeList attrMappingNodes = mappingDom.getDocumentElement().getElementsByTagName("AttributeMapping");
            block0: for (int i = 0; i < attrMappingNodes.getLength(); ++i) {
                Node attrMapping = attrMappingNodes.item(i);
                NodeList children = attrMapping.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    if (!"MappedFeature/gml:name[2]".equals(children.item(j).getTextContent())) continue;
                    attrMapping.getParentNode().removeChild(attrMapping);
                    continue block0;
                }
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.print(mappingDom, output);
            return output.toByteArray();
        }
        return null;
    }

    @Test
    public void testShapefileUploadExternalZipDirectory() throws Exception {
        File file = temp.getRoot();
        String body = file.getAbsolutePath();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/foo/datastores/bar/external.shp", body, "application/zip");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.startsWith((String)"Error renaming zip file from "));
        Assert.assertTrue((String)"The external file was unexpectedly deleted", (boolean)file.exists());
    }

    @Test
    public void testShapefileUploadExternalZipExistingDirectory() throws Exception {
        File file1 = temp.newFile("test1.zip");
        String body = file1.getAbsolutePath();
        File file2 = this.getResourceLoader().createDirectory("data/foo/bar1/test1.zip");
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/foo/datastores/bar1/external.shp", body, "application/zip");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.startsWith((String)"Error renaming zip file from "));
        Assert.assertTrue((String)"The external file was unexpectedly deleted", (boolean)file1.exists());
        Assert.assertTrue((String)"The file in the data directory was unexpectedly deleted", (boolean)file2.isDirectory());
    }

    @Test
    public void testShapefileUploadExternalZipBadFile() throws Exception {
        File file = temp.newFile("test2.zip");
        String body = file.getAbsolutePath();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/foo/datastores/bar2/external.shp", body, "application/zip");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)"Error occured unzipping file", (Object)response.getContentAsString());
        Assert.assertTrue((String)"The external file was unexpectedly deleted", (boolean)file.exists());
        Assert.assertEquals((String)"The data directory file was not deleted", (Object)Resource.Type.UNDEFINED, (Object)this.getResourceLoader().get("data/foo/bar2/test2.zip").getType());
    }

    @Test
    public void testShapefileUploadExternalZipValid() throws Exception {
        File file = temp.newFile("test3.zip");
        Files.write(file.toPath(), this.shpSanAndresShapefilesZipAsBytes(), new OpenOption[0]);
        String body = file.getAbsolutePath();
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getDataStoreByName("gs", "san_andres_y_providencia"));
        this.put("/rest/workspaces/gs/datastores/san_andres_y_providencia/external.shp", body, "application/zip");
        DataStoreInfo ds = cat.getDataStoreByName("gs", "san_andres_y_providencia");
        Assert.assertNotNull((Object)ds);
        Assert.assertEquals((long)1L, (long)cat.getFeatureTypesByDataStore(ds).size());
        Assert.assertTrue((String)"The external file was unexpectedly deleted", (boolean)file.exists());
        Assert.assertEquals((String)"The data directory file was not deleted", (Object)Resource.Type.UNDEFINED, (Object)this.getResourceLoader().get("data/gs/san_andres_y_providencia/test3.zip").getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilesystemSandbox() throws Exception {
        File systemSandbox = new File("./target/systemSandbox").getCanonicalFile();
        System.setProperty(DefaultFileAccessManager.GEOSERVER_DATA_SANDBOX, systemSandbox.getAbsolutePath());
        DefaultFileAccessManager fam = (DefaultFileAccessManager)FileAccessManager.lookupFileAccessManager();
        fam.reload();
        try {
            DataStoreInfo ds = this.uploadSanAndreas();
            String expected = new File(systemSandbox, "gs/san_andres_y_providencia").getAbsolutePath().replace("\\", "/");
            MatcherAssert.assertThat((Object)String.valueOf(ds.getConnectionParameters().get("url")), (Matcher)Matchers.containsString((String)expected));
        }
        finally {
            System.clearProperty(DefaultFileAccessManager.GEOSERVER_DATA_SANDBOX);
            fam.reload();
        }
    }

    private DataStoreInfo uploadSanAndreas() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getDataStoreByName("gs", "san_andres_y_providencia"));
        this.put("/rest/workspaces/gs/datastores/san_andres_y_providencia/file.shp", this.shpSanAndresShapefilesZipAsBytes(), "application/zip");
        DataStoreInfo ds = cat.getDataStoreByName("gs", "san_andres_y_providencia");
        Assert.assertNotNull((Object)ds);
        Assert.assertEquals((long)1L, (long)cat.getFeatureTypesByDataStore(ds).size());
        return ds;
    }
}

