/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.net.URL;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.TestHttpClientRule;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.rest.catalog.HttpTestUtils;
import org.geoserver.rest.catalog.WMTSStoreController;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WMTSStoreTest
extends CatalogRESTTestSupport {
    private static final String LAYER_NAME = "AMSR2_Snow_Water_Equivalent";
    @ClassRule
    public static TestHttpClientRule clientMocker = new TestHttpClientRule();
    private static String capabilities;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.setWorkspace(catalog.getWorkspaceByName("sf"));
        WMTSStoreInfo wmts = cb.buildWMTSStore("demo");
        wmts.setCapabilitiesURL(capabilities);
        catalog.add((StoreInfo)wmts);
        cb.setStore((StoreInfo)wmts);
        WMTSLayerInfo layer = cb.buildWMTSLayer(LAYER_NAME);
        catalog.add((ResourceInfo)layer);
    }

    @BeforeClass
    public static void mockServer() throws Exception {
        capabilities = clientMocker.getServer() + "/geoserver/gwc?REQUEST=GetCapabilities&VERSION=1.0.0&SERVICE=WMTS";
        MockHttpClient client = new MockHttpClient();
        client.expectGet(new URL(capabilities), (HTTPResponse)new MockHttpResponse(WMTSStoreTest.class.getResource("nasa.getcapa.xml"), "text/xml", new String[0]));
        clientMocker.bind((HTTPClient)client, capabilities);
    }

    @Test
    public void testBeanPresent() throws Exception {
        MatcherAssert.assertThat((Object)GeoServerExtensions.extensions(RestBaseController.class), (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(WMTSStoreController.class)));
    }

    @Test
    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmtsstores.xml");
        Assert.assertEquals((Object)"wmtsStores", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)catalog.getStoresByWorkspace("sf", WMTSStoreInfo.class).size(), (long)dom.getElementsByTagName("wmtsStore").getLength());
    }

    @Test
    public void testGetAllAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/wmtsstores.json");
        Assert.assertTrue((boolean)(json instanceof JSONObject));
        Object stores = ((JSONObject)json).getJSONObject("wmtsStores").get("wmtsStore");
        Assert.assertNotNull((Object)stores);
        if (stores instanceof JSONArray) {
            Assert.assertEquals((long)catalog.getStoresByWorkspace("sf", WMTSStoreInfo.class).size(), (long)((JSONArray)stores).size());
        } else {
            Assert.assertEquals((long)1L, (long)catalog.getStoresByWorkspace("sf", WMTSStoreInfo.class).size());
        }
    }

    @Test
    public void testGetAllAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmtsstores.html");
        List stores = catalog.getStoresByWorkspace("sf", WMTSStoreInfo.class);
        NodeList links = xp.getMatchingNodes("//html:a", dom);
        Assert.assertEquals((long)stores.size(), (long)links.getLength());
        for (int i = 0; i < stores.size(); ++i) {
            WMTSStoreInfo store = (WMTSStoreInfo)stores.get(i);
            Element link = (Element)links.item(i);
            Assert.assertTrue((boolean)link.getAttribute("href").endsWith(store.getName() + ".html"));
        }
    }

    @Test
    public void testPutAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.putAsServletResponse("/rest/workspaces/sf/wmtsstores").getStatus());
    }

    @Test
    public void testDeleteAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/wmtsstores").getStatus());
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmtsstores/demo.xml");
        Assert.assertEquals((Object)"wmtsStore", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"demo", (Object)xp.evaluate("/wmtsStore/name", dom));
        Assert.assertEquals((Object)"sf", (Object)xp.evaluate("/wmtsStore/workspace/name", dom));
        XMLAssert.assertXpathExists((String)"/wmtsStore/capabilitiesURL", (Document)dom);
    }

    @Test
    public void testGetAsHTML() throws Exception {
        WMTSStoreInfo store = (WMTSStoreInfo)catalog.getStoreByName("sf", "demo", WMTSStoreInfo.class);
        MatcherAssert.assertThat((Object)store, (Matcher)Matchers.notNullValue());
        List resources = catalog.getResourcesByStore((StoreInfo)store, WMTSLayerInfo.class);
        MatcherAssert.assertThat((Object)resources, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmtsstores/demo.html");
        WMTSStoreInfo wmts = (WMTSStoreInfo)catalog.getStoreByName("demo", WMTSStoreInfo.class);
        List wmtsLayers = catalog.getResourcesByStore((StoreInfo)wmts, WMTSLayerInfo.class);
        NodeList links = xp.getMatchingNodes("//html:a", dom);
        Assert.assertEquals((long)wmtsLayers.size(), (long)links.getLength());
        for (int i = 0; i < wmtsLayers.size(); ++i) {
            WMTSLayerInfo wl = (WMTSLayerInfo)wmtsLayers.get(i);
            Element link = (Element)links.item(i);
            Assert.assertTrue((boolean)link.getAttribute("href").endsWith(wl.getName() + ".html"));
        }
    }

    @Test
    public void testGetWrongWMTSStore() throws Exception {
        String ws = "sf";
        String wmts = "sfssssss";
        String requestPath = "/rest/workspaces/" + ws + "/wmtsstores/" + wmts + ".html";
        String exception = "No such wmts store: " + ws + "," + wmts;
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().contains(exception));
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertFalse((boolean)response.getContentAsString().contains(exception));
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
    }

    @Test
    public void testPostAsXML() throws Exception {
        String xml = "<wmtsStore><name>newWMTSStore</name><capabilitiesURL>http://somehost/wmts?</capabilitiesURL><workspace>sf</workspace></wmtsStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmtsstores", xml, "text/xml");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.CREATED));
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasHeader("Location", (Matcher<String>)Matchers.endsWith((String)"/workspaces/sf/wmtsstores/newWMTSStore")));
        WMTSStoreInfo newStore = (WMTSStoreInfo)catalog.getStoreByName("newWMTSStore", WMTSStoreInfo.class);
        Assert.assertNotNull((Object)newStore);
        Assert.assertEquals((Object)"http://somehost/wmts?", (Object)newStore.getCapabilitiesURL());
    }

    @Test
    public void testPostAsXMLNoWorkspace() throws Exception {
        String xml = "<wmtsStore><name>newWMTSStore</name><capabilitiesURL>http://somehost/wmts?</capabilitiesURL></wmtsStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmtsstores", xml, "text/xml");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.CREATED));
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasHeader("Location", (Matcher<String>)Matchers.endsWith((String)"/workspaces/sf/wmtsstores/newWMTSStore")));
        WMTSStoreInfo newStore = (WMTSStoreInfo)catalog.getStoreByName("newWMTSStore", WMTSStoreInfo.class);
        Assert.assertNotNull((Object)newStore);
        Assert.assertEquals((Object)"http://somehost/wmts?", (Object)newStore.getCapabilitiesURL());
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/wmtsstores/demo.json");
        JSONObject store = ((JSONObject)json).getJSONObject("wmtsStore");
        Assert.assertNotNull((Object)store);
        Assert.assertEquals((Object)"demo", (Object)store.get("name"));
        Assert.assertEquals((Object)"sf", (Object)store.getJSONObject("workspace").get("name"));
        Assert.assertEquals((Object)capabilities, (Object)store.getString("capabilitiesURL"));
    }

    @Test
    public void testPostAsJSON() throws Exception {
        this.removeStore("sf", "newWMTSStore");
        String json = "{'wmtsStore':{'capabilitiesURL': 'http://somehost/wmts?','workspace':'sf','name':'newWMTSStore',}}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmtsstores", json, "text/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/sf/wmtsstores/newWMTSStore"));
        WMTSStoreInfo newStore = (WMTSStoreInfo)catalog.getStoreByName("newWMTSStore", WMTSStoreInfo.class);
        Assert.assertNotNull((Object)newStore);
        Assert.assertEquals((Object)"http://somehost/wmts?", (Object)newStore.getCapabilitiesURL());
    }

    @Test
    public void testPostToResource() throws Exception {
        String xml = "<wmtsStore><name>demo</name><enabled>false</enabled></wmtsStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmtsstores/demo", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testPut() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmtsstores/demo.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wmtsStore/enabled", (Document)dom);
        String xml = "<wmtsStore><name>demo</name><enabled>false</enabled></wmtsStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmtsstores/demo", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        dom = this.getAsDOM("/rest/workspaces/sf/wmtsstores/demo.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wmtsStore/enabled", (Document)dom);
        Assert.assertFalse((boolean)((WMTSStoreInfo)catalog.getStoreByName("sf", "demo", WMTSStoreInfo.class)).isEnabled());
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        WMTSStoreInfo wsi = (WMTSStoreInfo)catalog.getStoreByName("sf", "demo", WMTSStoreInfo.class);
        wsi.setEnabled(true);
        catalog.save((StoreInfo)wsi);
        Assert.assertTrue((boolean)wsi.isEnabled());
        int maxConnections = wsi.getMaxConnections();
        int readTimeout = wsi.getReadTimeout();
        int connectTimeout = wsi.getConnectTimeout();
        boolean useConnectionPooling = wsi.isUseConnectionPooling();
        String xml = "<wmtsStore><name>demo</name></wmtsStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmtsstores/demo", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        wsi = (WMTSStoreInfo)catalog.getStoreByName("sf", "demo", WMTSStoreInfo.class);
        Assert.assertTrue((boolean)wsi.isEnabled());
        Assert.assertEquals((long)maxConnections, (long)wsi.getMaxConnections());
        Assert.assertEquals((long)readTimeout, (long)wsi.getReadTimeout());
        Assert.assertEquals((long)connectTimeout, (long)wsi.getConnectTimeout());
        Assert.assertEquals((Object)useConnectionPooling, (Object)wsi.isUseConnectionPooling());
    }

    @Test
    public void testPutNonExistant() throws Exception {
        String xml = "<wmtsStore><name>changed</name></wmtsStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmtsstores/nonExistant", xml, "text/xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testDeleteNonExistant() throws Exception {
        Assert.assertEquals((long)404L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/nonExistant").getStatus());
    }

    @Test
    public void testDelete() throws Exception {
        this.removeStore("sf", "newWMTSStore");
        this.testPostAsXML();
        Assert.assertNotNull((Object)catalog.getStoreByName("sf", "newWMTSStore", WMTSStoreInfo.class));
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/wmtsstores/newWMTSStore").getStatus());
        Assert.assertNull((Object)catalog.getStoreByName("sf", "newWMTSStore", WMTSStoreInfo.class));
    }

    @Test
    public void testPutNameChangeForbidden() throws Exception {
        String xml = "<wmtsStore><name>newName</name></wmtsStore>";
        Assert.assertEquals((long)403L, (long)this.putAsServletResponse("/rest/workspaces/sf/wmtsstores/demo", xml, "text/xml").getStatus());
    }

    @Test
    public void testPutWorkspaceChangeForbidden() throws Exception {
        String xml = "<wmtsStore><workspace>gs</workspace></wmtsStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmtsstores/demo", xml, "text/xml");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.FORBIDDEN));
    }

    @Test
    public void testPutWithDisableOnConnFailure() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmtsstores/demo.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wmtsStore/disableOnConnFailure", (Document)dom);
        String xml = "<wmtsStore><name>demo</name><disableOnConnFailure>true</disableOnConnFailure></wmtsStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmtsstores/demo", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        dom = this.getAsDOM("/rest/workspaces/sf/wmtsstores/demo.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wmtsStore/disableOnConnFailure", (Document)dom);
    }
}

