/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.StringWriter;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WorkspaceTest
extends CatalogRESTTestSupport {
    @Before
    public void addWorkspaces() {
        ((SystemTestData)this.getTestData()).addWorkspace(SystemTestData.DEFAULT_PREFIX, SystemTestData.DEFAULT_URI, catalog);
        ((SystemTestData)this.getTestData()).addWorkspace(SystemTestData.SF_PREFIX, SystemTestData.SF_URI, catalog);
    }

    @Test
    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces.xml");
        Assert.assertEquals((long)catalog.getNamespaces().size(), (long)dom.getElementsByTagName("workspace").getLength());
        NodeList nodes = dom.getElementsByTagName("workspace");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            String nodeValue = node.getTextContent().trim();
            Assert.assertNotNull((Object)catalog.getWorkspaceByName(nodeValue));
        }
    }

    @Test
    public void testGetAllAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces.html");
        List workspaces = catalog.getWorkspaces();
        NodeList links = xp.getMatchingNodes("//html:a", dom);
        Assert.assertEquals((long)workspaces.size(), (long)links.getLength());
        for (int i = 0; i < workspaces.size(); ++i) {
            WorkspaceInfo ws = (WorkspaceInfo)workspaces.get(i);
            Element link = (Element)links.item(i);
            Assert.assertTrue((boolean)link.getAttribute("href").endsWith(ws.getName() + ".html"));
        }
    }

    @Test
    public void testPutAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.putAsServletResponse("/rest/workspaces").getStatus());
    }

    @Test
    public void testDeleteAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse("/rest/workspaces").getStatus());
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf.xml");
        Assert.assertEquals((Object)"workspace", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("name").getLength());
        Element name = (Element)dom.getElementsByTagName("name").item(0);
        Assert.assertEquals((Object)"sf", (Object)name.getFirstChild().getTextContent());
        Element datastores = (Element)dom.getElementsByTagName("dataStores").item(0);
        Assert.assertNotNull((Object)datastores);
    }

    @Test
    public void testGetAsHTML() throws Exception {
        List stores = catalog.getStoresByWorkspace("sf", StoreInfo.class);
        Document dom = this.getAsDOM("/rest/workspaces/sf.html");
        NodeList links = xp.getMatchingNodes("//html:a", dom);
        Assert.assertEquals((long)stores.size(), (long)links.getLength());
        for (int i = 0; i < stores.size(); ++i) {
            StoreInfo store = (StoreInfo)stores.get(i);
            Element link = (Element)links.item(i);
            Assert.assertTrue((boolean)link.getAttribute("href").endsWith(store.getName() + ".html"));
        }
    }

    @Test
    public void testGetWrongWorkspace() throws Exception {
        String workspace = "sfsssss";
        String requestPath = "/rest/workspaces/" + workspace + ".html";
        String exception = "No such workspace: '" + workspace + "'";
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().contains(exception));
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertFalse((boolean)response.getContentAsString().contains(exception));
    }

    @Test
    public void testGetNonExistant() throws Exception {
        Assert.assertEquals((long)404L, (long)this.getAsServletResponse("/rest/workspaces/none").getStatus());
    }

    @Test
    public void testPostAsXML() throws Exception {
        String xml = "<workspace><name>foo</name></workspace>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/foo"));
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("foo");
        Assert.assertNotNull((Object)ws);
        Assert.assertNotNull((Object)ws.getDateCreated());
        NamespaceInfo ns = this.getCatalog().getNamespaceByPrefix("foo");
        Assert.assertNotNull((Object)ns);
        MockHttpServletResponse conflictResponse = this.postAsServletResponse("/rest/workspaces", xml, "text/xml");
        Assert.assertEquals((long)409L, (long)conflictResponse.getStatus());
        this.removeWorkspace("foo");
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf.json");
        JSONObject workspace = ((JSONObject)json).getJSONObject("workspace");
        Assert.assertEquals((Object)"sf", (Object)workspace.get("name"));
        Assert.assertNotNull((Object)workspace.get("dataStores"));
    }

    @Test
    public void testPostAsJSON() throws Exception {
        this.removeWorkspace("foo");
        String json = "{'workspace':{ 'name':'foo' }}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces", json, "text/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/foo"));
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("foo");
        Assert.assertNotNull((Object)ws);
        Assert.assertNotNull((Object)ws.getDateCreated());
        MockHttpServletResponse conflictResponse = this.postAsServletResponse("/rest/workspaces", json, "text/json");
        Assert.assertEquals((long)409L, (long)conflictResponse.getStatus());
    }

    @Test
    public void testPostToResource() throws Exception {
        String xml = "<workspace><name>changed</name></workspace>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testDeleteNonExistant() throws Exception {
        Assert.assertEquals((long)404L, (long)this.deleteAsServletResponse("/rest/workspaces/newExistant").getStatus());
    }

    @Test
    public void testDelete() throws Exception {
        String xml = "<workspace><name>foo</name></workspace>";
        this.post("/rest/workspaces", xml);
        Document dom = this.getAsDOM("/rest/workspaces/foo.xml");
        Assert.assertEquals((Object)"workspace", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/foo").getStatus());
        Assert.assertEquals((long)404L, (long)this.getAsServletResponse("/rest/workspaces/foo.xml").getStatus());
    }

    @Test
    public void testDeleteNonEmptyForbidden() throws Exception {
        ((SystemTestData)this.getTestData()).addVectorLayer(SystemTestData.PRIMITIVEGEOFEATURE, catalog);
        Assert.assertEquals((long)403L, (long)this.deleteAsServletResponse("/rest/workspaces/sf").getStatus());
    }

    @Test
    public void testDeleteDefault() throws Exception {
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/default").getStatus());
    }

    @Test
    public void testDeleteAllOneByOne() throws Exception {
        for (WorkspaceInfo ws : this.getCatalog().getWorkspaces()) {
            CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(this.getCatalog());
            for (StoreInfo store : this.getCatalog().getStoresByWorkspace(ws, StoreInfo.class)) {
                store.accept((CatalogVisitor)visitor);
            }
            String resource = "/rest/workspaces/" + ws.getName();
            Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse(resource).getStatus());
            Assert.assertEquals((long)404L, (long)this.getAsServletResponse(resource).getStatus());
        }
        Document dom = this.getAsDOM("/rest/workspaces.xml");
        Assert.assertEquals((long)0L, (long)dom.getElementsByTagName("workspace").getLength());
    }

    @Test
    public void testDeleteRecursive() throws Exception {
        ((SystemTestData)this.getTestData()).addVectorLayer(SystemTestData.PRIMITIVEGEOFEATURE, catalog);
        List stores = catalog.getStoresByWorkspace("sf", StoreInfo.class);
        Assert.assertFalse((boolean)stores.isEmpty());
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/sf?recurse=true");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNull((Object)catalog.getWorkspaceByName("sf"));
        Assert.assertNull((Object)catalog.getNamespaceByPrefix("sf"));
        for (StoreInfo s : stores) {
            Assert.assertNull((Object)catalog.getStoreByName(s.getName(), StoreInfo.class));
        }
    }

    @Test
    public void testPut() throws Exception {
        String xml = "<workspace><metadata><foo><string>bar</string></foo></metadata></workspace>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/workspaces/gs.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//name[text()='gs'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//entry[@key='foo' and text()='bar'])", (Document)dom);
    }

    @Test
    public void testPutNameChangeForbidden() throws Exception {
        String xml = "<workspace><name></name></workspace>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs", xml, "text/xml");
        Assert.assertEquals((long)403L, (long)response.getStatus());
        String json = "{'workspace':{ 'name': '' }}";
        response = this.putAsServletResponse("/rest/workspaces/gs", json, "application/json");
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void testPutNameChange() throws Exception {
        String xml = "<workspace><name>changed</name></workspace>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON json = this.getAsJSON("/rest/workspaces/changed.json");
        JSONObject workspace = ((JSONObject)json).getJSONObject("workspace");
        Assert.assertEquals((Object)"changed", (Object)workspace.get("name"));
        xml = "<workspace><name>gs</name></workspace>";
        response = this.putAsServletResponse("/rest/workspaces/changed", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        json = this.getAsJSON("/rest/workspaces/gs.json");
        workspace = ((JSONObject)json).getJSONObject("workspace");
        Assert.assertEquals((Object)"gs", (Object)workspace.get("name"));
    }

    @Test
    public void testPutNonExistant() throws Exception {
        String xml = "<workspace><metadata><entry><string>foo</string><string>bar</string></entry></metadata></workspace>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/nonExistant", xml, "text/xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testGetDefaultWorkspace() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/default.xml");
        Assert.assertEquals((Object)"workspace", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("name").getLength());
    }

    @Test
    public void testPutDefaultWorkspace() throws Exception {
        WorkspaceInfo def = this.getCatalog().getDefaultWorkspace();
        Assert.assertEquals((Object)"gs", (Object)def.getName());
        String json = "{'workspace':{ 'name':'sf' }}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/default", json, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        def = this.getCatalog().getDefaultWorkspace();
        Assert.assertEquals((Object)"sf", (Object)def.getName());
    }

    @Test
    public void testRoundTripXMLSerialization() throws Exception {
        this.removeWorkspace("ian");
        String xml = "<workspace><name>foo</name></workspace>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/foo"));
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("foo");
        Assert.assertNotNull((Object)ws);
        Document dom = this.getAsDOM("/rest/workspaces/foo.xml");
        Assert.assertEquals((Object)"workspace", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("name").getLength());
        Element name = (Element)dom.getElementsByTagName("name").item(0);
        Assert.assertEquals((Object)"foo", (Object)name.getFirstChild().getTextContent());
        dom = this.getAsDOM("/rest/workspaces/" + SystemTestData.SF_PREFIX + ".xml");
        name = (Element)dom.getElementsByTagName("name").item(0);
        name.setTextContent("ian");
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(dom), new StreamResult(writer));
        String output = writer.getBuffer().toString();
        response = this.postAsServletResponse("/rest/workspaces", output, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/ian"));
    }

    @Test
    public void testRoundTripJSONSerialization() throws Exception {
        this.removeWorkspace("ian");
        String json = "{'workspace':{'name':'foo'}}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces", json, "application/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/foo"));
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("foo");
        Assert.assertNotNull((Object)ws);
        JSON jsonObj = this.getAsJSON("/rest/workspaces/foo.json");
        JSONObject workspace = ((JSONObject)jsonObj).getJSONObject("workspace");
        Assert.assertEquals((Object)"foo", (Object)workspace.get("name"));
        jsonObj = this.getAsJSON("/rest/workspaces/" + SystemTestData.SF_PREFIX + ".json");
        workspace = ((JSONObject)jsonObj).getJSONObject("workspace");
        workspace.put((Object)"name", (Object)"ian");
        String output = jsonObj.toString();
        response = this.postAsServletResponse("/rest/workspaces", output, "application/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/ian"));
    }

    @Test
    public void testIsolatedWorkspaceHandling() throws Exception {
        String xmlPost = "<workspace>  <name>isolated_workspace</name>  <isolated>true</isolated></workspace>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces.xml", xmlPost, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        WorkspaceInfo workspace = this.getCatalog().getWorkspaceByName("isolated_workspace");
        MatcherAssert.assertThat((Object)workspace, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)workspace.isIsolated(), (Matcher)Matchers.is((Object)true));
        Assert.assertNotNull((Object)workspace.getDateCreated());
        NamespaceInfo namespace = this.getCatalog().getNamespaceByPrefix("isolated_workspace");
        MatcherAssert.assertThat((Object)namespace, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)namespace.isIsolated(), (Matcher)Matchers.is((Object)true));
        String xmlPut = "<workspace>  <name>isolated_workspace</name>  <isolated>false</isolated></workspace>";
        response = this.putAsServletResponse("/rest/workspaces/isolated_workspace", xmlPut, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        workspace = this.getCatalog().getWorkspaceByName("isolated_workspace");
        MatcherAssert.assertThat((Object)workspace, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)workspace.isIsolated(), (Matcher)Matchers.is((Object)false));
        Assert.assertNotNull((Object)workspace.getDateModified());
        namespace = this.getCatalog().getNamespaceByPrefix("isolated_workspace");
        MatcherAssert.assertThat((Object)namespace, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)namespace.isIsolated(), (Matcher)Matchers.is((Object)false));
    }
}

