/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.IntStream;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.rest.security.RolesRestController;
import org.geoserver.rest.security.UsersRestController;
import org.geoserver.rest.security.xml.JaxbRoleList;
import org.geoserver.rest.security.xml.JaxbUser;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.test.GeoServerTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class SequentialExecutionControllerTest
extends GeoServerTestSupport {
    private static final String USER_SERVICE = "default";
    protected UsersRestController usersController;
    protected RolesRestController rolesController;

    @Before
    public void oneTimeSetUp() throws Exception {
        this.setValidating(true);
        super.oneTimeSetUp();
        this.usersController = (UsersRestController)applicationContext.getBean(UsersRestController.class);
        this.rolesController = (RolesRestController)applicationContext.getBean(RolesRestController.class);
    }

    @Test
    public void testMultipleRolesAttachment() throws PasswordPolicyException, IOException {
        JaxbUser user = new JaxbUser();
        user.setUserName("popo");
        user.setPassword("secret");
        user.setEnabled(Boolean.valueOf(true));
        this.usersController.insertUser(USER_SERVICE, user);
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("rolea");
        roles.add("roleb");
        roles.add("rolec");
        roles.add("roled");
        for (String role2 : roles) {
            try {
                this.rolesController.insert(role2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList requestUrls = new ArrayList();
        roles.forEach(role -> requestUrls.add("rest/security/roles/role/" + role + "/user/popo"));
        requestUrls.parallelStream().forEach(requestUrl -> {
            MockHttpServletRequest request = this.createRequest((String)requestUrl);
            request.setMethod("POST");
            try {
                this.dispatch((HttpServletRequest)request, "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        JaxbRoleList jaxbRoleList = this.rolesController.getUser("popo");
        Assert.assertEquals((long)4L, (long)jaxbRoleList.getRoles().size());
        Assert.assertTrue((boolean)jaxbRoleList.getRoles().contains("rolea"));
        Assert.assertTrue((boolean)jaxbRoleList.getRoles().contains("roleb"));
        Assert.assertTrue((boolean)jaxbRoleList.getRoles().contains("rolec"));
        Assert.assertTrue((boolean)jaxbRoleList.getRoles().contains("roled"));
    }

    @Test
    public void testMultipleUserCreation() throws PasswordPolicyException, IOException {
        int USERS_COUNT = 16;
        IntStream.range(0, USERS_COUNT).parallel().forEach(i -> this.createUser(i));
        GeoServerSecurityManager manager = (GeoServerSecurityManager)applicationContext.getBean(GeoServerSecurityManager.class);
        GeoServerUserGroupService userService = manager.loadUserGroupService(USER_SERVICE);
        for (int i2 = 0; i2 < USERS_COUNT; ++i2) {
            Assert.assertNotNull((Object)userService.getUserByUsername("user" + i2));
        }
    }

    private void createUser(int i) {
        String userBody = String.format("<user><userName>%s</userName><password>%s</password><enabled>true</enabled></user>", "user" + i, "password" + i);
        try {
            this.postAsServletResponse("rest/security/usergroup/users", userBody, "text/xml");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

