/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.system.status;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.system.status.MetricInfo;
import org.geoserver.system.status.MetricValue;
import org.geoserver.system.status.Metrics;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MonitorRestTest
extends GeoServerSystemTestSupport {
    @Test
    public void testDefaultCallback() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/about/system-status");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        XStream xs = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
        xs.setMode(1001);
        xs.alias("metric", MetricValue.class);
        xs.alias("metrics", Metrics.class);
        xs.addImplicitCollection(Metrics.class, "metrics");
        xs.allowTypes(new Class[]{Metrics.class, MetricValue.class});
        Metrics metrics = (Metrics)xs.fromXML(response.getContentAsString());
        Assert.assertTrue((metrics.getMetrics().size() >= MetricInfo.values().length ? 1 : 0) != 0);
    }

    @Test
    public void testXmlCallback() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/about/system-status.xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        XStream xs = new XStream();
        xs.alias("metric", MetricValue.class);
        xs.alias("metrics", Metrics.class);
        xs.addImplicitCollection(Metrics.class, "metrics");
        xs.allowTypes(new Class[]{Metrics.class, MetricValue.class});
        Metrics metrics = (Metrics)xs.fromXML(response.getContentAsString());
        Assert.assertTrue((metrics.getMetrics().size() >= MetricInfo.values().length ? 1 : 0) != 0);
    }

    @Test
    public void testJsonCallback() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/about/system-status.json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        XStream xs = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
        xs.setMode(1001);
        xs.alias("metric", MetricValue.class);
        xs.alias("metrics", Metrics.class);
        xs.addImplicitCollection(Metrics.class, "metrics");
        xs.allowTypes(new Class[]{Metrics.class, MetricValue.class});
        Metrics metrics = (Metrics)xs.fromXML(response.getContentAsString());
        Assert.assertTrue((metrics.getMetrics().size() >= MetricInfo.values().length ? 1 : 0) != 0);
    }

    @Test
    public void testJsonValueFieldIsEncoded() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/about/system-status.json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONArray metrics = ((JSONObject)this.json(response)).getJSONObject("metrics").getJSONArray("metric");
        for (Object metric : metrics) {
            Assert.assertNotNull((Object)((JSONObject)metric).containsKey((Object)"value"));
        }
    }

    @Test
    public void testXmlValueFieldIsEncoded() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/about/system-status.xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(response.getContentAsString())));
        XPathExpression expression = XPathFactory.newInstance().newXPath().compile("//value");
        NodeList nodes = (NodeList)expression.evaluate(xml, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Assert.assertNotNull((Object)nodes.item(i).getFirstChild().getNodeValue());
        }
    }

    @Test
    public void testHtmlCallback() throws Exception {
        Document doc = this.getAsDOM("/rest/about/system-status.html");
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate("/html/body/table/tr", doc, XPathConstants.NODESET);
        Assert.assertTrue((nodes.getLength() >= MetricInfo.values().length ? 1 : 0) != 0);
    }
}

